/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.transports.sap;

import com.sap.conn.jco.ext.DestinationDataEventListener;
import com.sap.conn.jco.ext.DestinationDataProvider;
import com.sap.conn.jco.ext.ServerDataEventListener;
import com.sap.conn.jco.ext.ServerDataProvider;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.securevault.SecretResolver;
import org.wso2.securevault.SecretResolverFactory;
import org.wso2.securevault.commons.MiscellaneousUtil;

public class CarbonDestinationDataProvider
implements DestinationDataProvider,
ServerDataProvider {
    private static final Log log = LogFactory.getLog(CarbonDestinationDataProvider.class);

    public Properties getServerProperties(String server) {
        File file = this.getConfigurationFile(server, true);
        if (file != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Loading server configuration from: " + file.getPath()));
            }
            try {
                Properties props = new Properties();
                props.load(new FileInputStream(file));
                return props;
            }
            catch (IOException e) {
                log.error((Object)("Error while loading server configuration from: " + file.getPath()), (Throwable)e);
            }
        }
        return null;
    }

    public void setServerDataEventListener(ServerDataEventListener listener) {
    }

    public Properties getDestinationProperties(String destination) {
        Properties props = null;
        File file = this.getConfigurationFile(destination, false);
        if (file != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Loading destination configuration from: " + file.getPath()));
            }
            try {
                props = new Properties();
                props.load(new FileInputStream(file));
            }
            catch (IOException e) {
                log.error((Object)("Error while loading destination configuration from: " + file.getPath()), (Throwable)e);
            }
            SecretResolver secretResolver = SecretResolverFactory.create((Properties)props);
            for (String key : props.stringPropertyNames()) {
                if (secretResolver == null || !secretResolver.isInitialized()) continue;
                String value = props.getProperty(key);
                if (value != null) {
                    value = value.startsWith("secretAlias:") ? (secretResolver.isTokenProtected(value = value.split("secretAlias:")[1]) ? secretResolver.resolve(value) : value) : MiscellaneousUtil.resolve((String)value, (SecretResolver)secretResolver);
                }
                props.put(key, value);
            }
            return props;
        }
        return null;
    }

    public void setDestinationDataEventListener(DestinationDataEventListener listener) {
    }

    public boolean supportsEvents() {
        return false;
    }

    private File getConfigurationFile(String destination, boolean server) {
        File file1;
        String fileName = destination + "." + (server ? "server" : "dest");
        String confPath = System.getProperty("conf.location");
        if (confPath == null) {
            confPath = Paths.get("conf", new String[0]).toString();
        }
        if ((file1 = Paths.get(confPath, "sap", fileName).toFile()).exists()) {
            return file1;
        }
        File file2 = new File(fileName);
        if (file2.exists()) {
            return file2;
        }
        log.warn((Object)("JCo configuration file for the destination : " + destination + " does not exist - Please specify the JCo configuration in " + file1.getPath() + " or " + file2.getPath()));
        return null;
    }
}

