/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.transports.sap;

import com.sap.conn.idoc.IDocDocumentList;
import com.sap.conn.idoc.IDocRepository;
import com.sap.conn.idoc.jco.JCoIDoc;
import com.sap.conn.jco.JCoContext;
import com.sap.conn.jco.JCoDestination;
import com.sap.conn.jco.JCoDestinationManager;
import com.sap.conn.jco.JCoException;
import com.sap.conn.jco.JCoFunction;
import com.sap.conn.jco.JCoRuntimeException;
import com.sap.conn.jco.JCoStructure;
import com.sap.conn.jco.ext.DestinationDataProvider;
import com.sap.conn.jco.ext.Environment;
import com.sap.conn.jco.ext.ServerDataProvider;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URI;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.soap.SOAPBody;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.OutInAxisOperation;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.description.TransportOutDescription;
import org.apache.axis2.engine.AxisEngine;
import org.apache.axis2.transport.OutTransportInfo;
import org.apache.axis2.transport.TransportUtils;
import org.apache.axis2.transport.base.AbstractTransportSender;
import org.apache.axis2.util.MessageContextBuilder;
import org.wso2.carbon.transports.sap.CarbonDestinationDataProvider;
import org.wso2.carbon.transports.sap.bapi.SAPOutTransportInfo;
import org.wso2.carbon.transports.sap.bapi.util.RFCMetaDataParser;
import org.wso2.carbon.transports.sap.idoc.DefaultIDocXMLMapper;
import org.wso2.carbon.transports.sap.idoc.IDocXMLMapper;

public class SAPTransportSender
extends AbstractTransportSender {
    private Map<String, IDocXMLMapper> xmlMappers = new HashMap<String, IDocXMLMapper>();
    private IDocXMLMapper defaultMapper = new DefaultIDocXMLMapper();
    public static final String ERROR_CODE = "ERROR_CODE";
    public static final int SAP_TRANSPORT_ERROR = 8000;
    public static final String SAP_WAIT = "sap.wait";
    public static final String SAP_TRANSACTION_ID = "SAP-Transaction-Id";
    public static final int SAP_DESTINATION_ERROR = 8001;
    public static final String LEFT_ANGLE_BRACKET = "<";
    public static final String RIGHT_ANGLE_BRACKET = ">";
    public static final String FORWARD_SLASH = "/";
    private static final String AGGREGATED_RESPONSE_OPENING_TAG = "<BAPI_TRANSACTION>";
    private static final String AGGREGATED_RESPONSE_CLOSING_TAG = "</BAPI_TRANSACTION>";
    private static final String SAP_ESCAPE_ERROR_HANDLING = "sap.escape.error.handling";
    public static final String FIELD_NAME_WAIT = "WAIT";

    public void init(ConfigurationContext cfgCtx, TransportOutDescription trpOut) throws AxisFault {
        Parameter xmlMappersParam;
        super.init(cfgCtx, trpOut);
        CarbonDestinationDataProvider provider = new CarbonDestinationDataProvider();
        if (!Environment.isServerDataProviderRegistered()) {
            Environment.registerServerDataProvider((ServerDataProvider)provider);
        }
        if (!Environment.isDestinationDataProviderRegistered()) {
            Environment.registerDestinationDataProvider((DestinationDataProvider)provider);
        }
        if ((xmlMappersParam = trpOut.getParameter("transport.sap.customXMLMappers")) != null) {
            OMElement mappersElt = xmlMappersParam.getParameterElement().getFirstElement();
            Iterator mappers = mappersElt.getChildrenWithName(new QName("mapper"));
            try {
                while (mappers.hasNext()) {
                    OMElement m = (OMElement)mappers.next();
                    String key = m.getAttributeValue(new QName("key"));
                    String value = m.getText().trim();
                    Class<?> clazz = ((Object)((Object)this)).getClass().getClassLoader().loadClass(value);
                    IDocXMLMapper mapper = (IDocXMLMapper)clazz.newInstance();
                    this.xmlMappers.put(key, mapper);
                }
            }
            catch (Exception e) {
                throw new AxisFault("Error while initializing the SAP transport sender", (Throwable)e);
            }
        }
    }

    public void sendMessage(MessageContext messageContext, String targetEPR, OutTransportInfo outTransportInfo) throws AxisFault {
        block12: {
            if (!messageContext.isServerSide()) {
                if (targetEPR == null) {
                    throw new AxisFault("Cannot send an IDoc without a target SAP EPR");
                }
                try {
                    URI uri = new URI(targetEPR);
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)("Started sending message to uri=" + uri));
                    }
                    String destName = uri.getPath().substring(1);
                    JCoDestination destination = JCoDestinationManager.getDestination((String)destName);
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)("Retrieved destination: " + destination.getDestinationID()));
                    }
                    if (uri.getScheme().equals("idoc")) {
                        IDocRepository iDocRepository = JCoIDoc.getIDocRepository((JCoDestination)destination);
                        String tid = destination.createTID();
                        if (this.log.isDebugEnabled()) {
                            this.log.debug((Object)("Created transaction ID: " + tid));
                        }
                        Object headers = messageContext.getProperty("TRANSPORT_HEADERS");
                        Map headersMap = (Map)headers;
                        headersMap.put(SAP_TRANSACTION_ID, tid);
                        IDocDocumentList iDocList = this.getIDocs(messageContext, iDocRepository);
                        JCoIDoc.send((IDocDocumentList)iDocList, (char)this.getIDocVersion(uri), (JCoDestination)destination, (String)tid);
                        destination.confirmTID(tid);
                        if (this.log.isDebugEnabled()) {
                            this.log.debug((Object)("Successfully sent Idoc. Destination:" + destination.getDestinationID()));
                        }
                        break block12;
                    }
                    if (uri.getScheme().equals("bapi")) {
                        this.sendBapiRequest(messageContext, destination);
                        break block12;
                    }
                    this.handleException("Invalid protocol name : " + uri.getScheme() + " in SAP URL");
                }
                catch (Exception e) {
                    this.log.error((Object)("Error while sending request to the EPR" + targetEPR), (Throwable)e);
                    this.sendFault(messageContext, e, 8001);
                    this.handleException("Error while sending request to the EPR : " + targetEPR, e);
                }
            } else {
                SAPOutTransportInfo outTransportInfoValue;
                this.log.debug((Object)"Handling response");
                if (messageContext.getProperty("OutTransportInfo") instanceof SAPOutTransportInfo && (outTransportInfoValue = (SAPOutTransportInfo)messageContext.getProperty("OutTransportInfo")).getProtocol().equals("bapi")) {
                    this.populateBapiReponse(messageContext, outTransportInfoValue);
                }
            }
        }
    }

    private boolean isTransaction(MessageContext messageContext) {
        String transactionCommit = (String)messageContext.getProperty("transport.sap.transactionCommit");
        return null != transactionCommit && "true".equalsIgnoreCase(transactionCommit);
    }

    private char getIDocVersion(URI uri) {
        String query = uri.getQuery();
        if (query != null && query.startsWith("version")) {
            String version = query.substring(query.indexOf(61) + 1);
            if ("2".equals(version)) {
                return '2';
            }
            if ("3".equals(version)) {
                return '3';
            }
        }
        return '0';
    }

    private boolean isLogon(MessageContext messageContext) {
        String logon = (String)messageContext.getProperty("transport.sap.logon");
        return null != logon && "true".equalsIgnoreCase(logon);
    }

    private void logon(MessageContext messageContext, JCoDestination destination, String escapeErrorHandling) throws AxisFault {
        JCoFunction logonFunction = this.getRFCfunction(destination, "BAPI_XMI_LOGON");
        logonFunction.getImportParameterList().setValue("EXTCOMPANY", (String)messageContext.getProperty("transport.sap.EXTCOMPANY"));
        logonFunction.getImportParameterList().setValue("EXTPRODUCT", (String)messageContext.getProperty("transport.sap.EXTPRODUCT"));
        logonFunction.getImportParameterList().setValue("INTERFACE", (String)messageContext.getProperty("transport.sap.INTERFACE"));
        logonFunction.getImportParameterList().setValue("VERSION", (String)messageContext.getProperty("transport.sap.VERSION"));
        String logonResponse = this.evaluateRFCfunction(logonFunction, destination, escapeErrorHandling);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("BAPI XMI Logon response: " + logonResponse));
        }
    }

    private IDocDocumentList getIDocs(MessageContext msgContext, IDocRepository repo) throws Exception {
        Object mapper = msgContext.getOptions().getProperty("transport.sap.xmlMapper");
        if (mapper != null && this.xmlMappers.containsKey(mapper.toString())) {
            return this.xmlMappers.get(mapper.toString()).getDocumentList(repo, msgContext);
        }
        return this.defaultMapper.getDocumentList(repo, msgContext);
    }

    private String evaluateRFCfunction(JCoFunction function, JCoDestination destination, String escapeErrorHandling) throws AxisFault {
        this.log.info((Object)("Invoking the RFC function :" + function.getName()));
        try {
            function.execute(destination);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Invoked the RFC function :" + function.getName()));
            }
        }
        catch (JCoException e) {
            throw new AxisFault("Cloud not execute the RFC function: " + function, (Throwable)e);
        }
        if (function.getExportParameterList() != null) {
            JCoStructure returnStructure;
            block8: {
                returnStructure = null;
                try {
                    returnStructure = function.getExportParameterList().getStructure("RETURN");
                }
                catch (JCoRuntimeException e) {
                    if (e.getKey().equals("JCO_ERROR_FIELD_NOT_FOUND")) break block8;
                    throw e;
                }
            }
            if (returnStructure != null) {
                String type;
                String returnStructureStr = returnStructure.toXML();
                if (!(!"false".equals(escapeErrorHandling) || "S".equals(type = returnStructure.getString("TYPE")) || "I".equals(type) || "W".equals(type) || "".equals(type))) {
                    throw new AxisFault("Erroneous response while invoking the function: " + function.getName() + ", of type" + type + " response: " + returnStructureStr);
                }
            }
        }
        return function.toXML();
    }

    private JCoFunction getRFCfunction(JCoDestination destination, String rfcName) throws AxisFault {
        this.log.info((Object)("Retriving the BAPI/RFC function : " + rfcName + " from the destination : " + destination));
        JCoFunction function = null;
        try {
            function = destination.getRepository().getFunction(rfcName);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("retrieved function: " + function.getName()));
            }
        }
        catch (JCoException e) {
            throw new AxisFault("RFC function " + function + " cloud not found in SAP system", (Throwable)e);
        }
        return function;
    }

    private void processResponse(MessageContext msgContext, String payLoad) throws AxisFault {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Response received: " + payLoad));
        }
        if (!(msgContext.getAxisOperation() instanceof OutInAxisOperation)) {
            return;
        }
        try {
            MessageContext responseMessageContext = this.createResponseMessageContext(msgContext);
            ByteArrayInputStream bais = new ByteArrayInputStream(payLoad.getBytes());
            SOAPEnvelope envelope = TransportUtils.createSOAPMessage((MessageContext)msgContext, (InputStream)bais, (String)"application/xml");
            responseMessageContext.setEnvelope(envelope);
            AxisEngine.receive((MessageContext)responseMessageContext);
            this.log.info((Object)"Sending response out..");
        }
        catch (XMLStreamException e) {
            throw new AxisFault("Error while processing response", (Throwable)e);
        }
    }

    private void sendFault(MessageContext msgContext, Exception e, int errorCode) {
        try {
            MessageContext faultContext = MessageContextBuilder.createFaultMessageContext((MessageContext)msgContext, (Throwable)e);
            faultContext.setProperty(ERROR_CODE, (Object)errorCode);
            faultContext.setProperty("ERROR_MESSAGE", (Object)e.getMessage());
            faultContext.setProperty("SENDING_FAULT", (Object)Boolean.TRUE);
            if (msgContext.getAxisOperation() != null && msgContext.getAxisOperation().getMessageReceiver() != null) {
                msgContext.getAxisOperation().getMessageReceiver().receive(faultContext);
            } else {
                this.log.error((Object)"Could not create the fault message.", (Throwable)e);
            }
        }
        catch (AxisFault axisFault) {
            this.log.fatal((Object)"Cloud not create the fault message.", (Throwable)axisFault);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendBapiRequest(MessageContext messageContext, JCoDestination destination) throws AxisFault, JCoException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"Invoking BAPI endpoint");
        }
        String escapeErrorHandling = (String)messageContext.getProperty(SAP_ESCAPE_ERROR_HANDLING);
        boolean isLogon = this.isLogon(messageContext);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Transaction property :" + messageContext.getProperty("transport.sap.transactionCommit")));
            this.log.debug((Object)("Logon property :" + messageContext.getProperty("transport.sap.logon")));
        }
        String rfcFunctionName = null;
        try {
            SOAPBody body = messageContext.getEnvelope().getBody();
            OMElement payLoad = body.getFirstChildWithName(new QName("bapirfc"));
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Received RFC/Meta DATA: " + payLoad));
            }
            rfcFunctionName = RFCMetaDataParser.getBAPIRFCFunctionName(payLoad);
            if (this.isTransaction(messageContext) || isLogon) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Beginning Transaction for function: " + rfcFunctionName));
                }
                JCoContext.begin((JCoDestination)destination);
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Transaction begun. Function: " + rfcFunctionName));
                }
            }
            if (isLogon) {
                this.logon(messageContext, destination, escapeErrorHandling);
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Looking up the BAPI/RFC function: " + rfcFunctionName + ". In the meta data repository"));
            }
            JCoFunction function = this.getRFCfunction(destination, rfcFunctionName);
            RFCMetaDataParser.processMetaDataDocument(payLoad, function);
            String bapiResponse = this.evaluateRFCfunction(function, destination, escapeErrorHandling);
            if (this.isTransaction(messageContext)) {
                JCoFunction commitFunction = this.getRFCfunction(destination, "BAPI_TRANSACTION_COMMIT");
                Object headers = messageContext.getProperty("TRANSPORT_HEADERS");
                Map headersMap = (Map)headers;
                String waitValue = (String)headersMap.get(SAP_WAIT);
                if (waitValue != null && !waitValue.isEmpty()) {
                    RFCMetaDataParser.processFieldValue(FIELD_NAME_WAIT, waitValue, commitFunction);
                }
                String commitResponse = this.evaluateRFCfunction(commitFunction, destination, escapeErrorHandling);
                StringBuilder sb = new StringBuilder();
                sb.append(AGGREGATED_RESPONSE_OPENING_TAG);
                sb.append(bapiResponse).append(commitResponse);
                sb.append(AGGREGATED_RESPONSE_CLOSING_TAG);
                bapiResponse = sb.toString();
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Committed transaction. Function: " + rfcFunctionName));
                }
            }
            this.processResponse(messageContext, bapiResponse);
        }
        catch (Exception e) {
            this.log.error((Object)"Error while sending request", (Throwable)e);
            if (this.isTransaction(messageContext)) {
                JCoFunction rollbackFunction = this.getRFCfunction(destination, "BAPI_TRANSACTION_ROLLBACK");
                this.evaluateRFCfunction(rollbackFunction, destination, escapeErrorHandling);
                this.log.warn((Object)("Rolled-back transaction. Function: " + rfcFunctionName));
            }
            this.sendFault(messageContext, e, 8000);
        }
        finally {
            if (this.isTransaction(messageContext) || isLogon) {
                JCoContext.end((JCoDestination)destination);
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Ended transaction. Function: " + rfcFunctionName));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void populateBapiReponse(MessageContext messageContext, SAPOutTransportInfo outTransportInfo) {
        SAPOutTransportInfo sAPOutTransportInfo = outTransportInfo;
        synchronized (sAPOutTransportInfo) {
            this.log.debug((Object)"Populating response to outTransportInfo");
            outTransportInfo.setPayload((OMElement)messageContext.getEnvelope().getBody());
            outTransportInfo.notify();
        }
    }
}

