/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.transports.sap.bapi;

import com.sap.conn.jco.AbapClassException;
import com.sap.conn.jco.AbapException;
import com.sap.conn.jco.JCoField;
import com.sap.conn.jco.JCoFieldIterator;
import com.sap.conn.jco.JCoFunction;
import com.sap.conn.jco.JCoRecord;
import com.sap.conn.jco.JCoRuntimeException;
import com.sap.conn.jco.JCoStructure;
import com.sap.conn.jco.JCoTable;
import com.sap.conn.jco.server.JCoServerContext;
import com.sap.conn.jco.server.JCoServerFunctionHandler;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Iterator;
import java.util.Objects;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.engine.AxisEngine;
import org.apache.axis2.transport.TransportUtils;
import org.apache.axis2.transport.base.threads.WorkerPool;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.transports.sap.bapi.BAPIEndpoint;
import org.wso2.carbon.transports.sap.bapi.SAPOutTransportInfo;
import org.wso2.carbon.transports.sap.bapi.util.RFCConstants;

public class Axis2RFCHandler
implements JCoServerFunctionHandler {
    private static final Log log = LogFactory.getLog(Axis2RFCHandler.class);
    private WorkerPool workerPool;
    private BAPIEndpoint endpoint;

    public Axis2RFCHandler(BAPIEndpoint endpoint, WorkerPool workerPool) {
        this.endpoint = endpoint;
        this.workerPool = workerPool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleRequest(JCoServerContext jCoServerContext, JCoFunction jCoFunction) throws AbapException, AbapClassException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"New BAPI function call received");
        }
        String xml = jCoFunction.toXML();
        SAPOutTransportInfo bapiOutTransportInfo = new SAPOutTransportInfo();
        bapiOutTransportInfo.setProtocol("bapi");
        this.workerPool.execute((Runnable)new BAPIWorker(xml, jCoFunction, bapiOutTransportInfo));
        if (this.endpoint.isSyncBapiListener()) {
            try {
                SAPOutTransportInfo sAPOutTransportInfo = bapiOutTransportInfo;
                synchronized (sAPOutTransportInfo) {
                    int responseTimeout = this.endpoint.getResponseTimeout();
                    if (log.isDebugEnabled()) {
                        log.debug((Object)(" Waiting for response for JCoFunction: " + jCoFunction.toXML() + " with response timeout: " + responseTimeout));
                    }
                    bapiOutTransportInfo.wait(responseTimeout);
                    if (Objects.isNull(jCoFunction.getExportParameterList())) {
                        log.error((Object)"Trying to respond to a function that has no Export parameters defined in the function definition");
                        return;
                    }
                    OMElement payload = bapiOutTransportInfo.getPayload();
                    if (Objects.isNull(payload)) {
                        JCoStructure returnStructure;
                        block34: {
                            returnStructure = null;
                            try {
                                returnStructure = jCoFunction.getExportParameterList().getStructure("RETURN");
                            }
                            catch (JCoRuntimeException exp) {
                                if (exp.getKey().equals("JCO_ERROR_FIELD_NOT_FOUND")) break block34;
                                log.warn((Object)"Error retrieving RETURN structure", (Throwable)exp);
                                return;
                            }
                        }
                        if (returnStructure != null) {
                            JCoFieldIterator e = returnStructure.getFieldIterator();
                            while (e.hasNextField()) {
                                JCoField field = e.nextField();
                                if ("TYPE".equals(field.getName())) {
                                    field.setValue("E");
                                    continue;
                                }
                                if (!"MESSAGE".equals(field.getName())) continue;
                                field.setValue("Did not receive a response within " + responseTimeout + "ms");
                            }
                            jCoFunction.getExportParameterList().setValue("RETURN", returnStructure);
                        } else if (log.isDebugEnabled()) {
                            log.debug((Object)"RETURN structure is NULL");
                        }
                        return;
                    }
                    OMElement exportParameters = payload.getFirstElement();
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Setting payload: " + payload + " to the Export parameters: " + jCoFunction.getExportParameterList()));
                    }
                    boolean found = false;
                    if (Objects.isNull(exportParameters)) {
                        log.error((Object)"Payload with no root element found. A response will not be sent back.");
                    }
                    if (exportParameters.getLocalName().equals("BAPI_EXPORT")) {
                        Iterator childElements = exportParameters.getChildElements();
                        if (Objects.isNull(childElements)) {
                            log.warn((Object)"No children elements found under \"BAPI_EXPORT\" element!");
                            return;
                        }
                        block18: while (childElements.hasNext()) {
                            found = true;
                            OMElement childElement = (OMElement)childElements.next();
                            String qName = Axis2RFCHandler.getQname(childElement);
                            String name = Axis2RFCHandler.getElementName(childElement);
                            switch (qName) {
                                case "structure": {
                                    JCoStructure structure = Axis2RFCHandler.processStructure(childElement, jCoFunction, name);
                                    jCoFunction.getExportParameterList().setValue(name, structure);
                                    continue block18;
                                }
                                case "table": {
                                    JCoTable table = Axis2RFCHandler.processTable(childElement, jCoFunction, name);
                                    jCoFunction.getExportParameterList().setValue(name, table);
                                    continue block18;
                                }
                                case "field": {
                                    String fieldValue = Axis2RFCHandler.getFieldValue(childElement, name);
                                    jCoFunction.getExportParameterList().setValue(name, fieldValue);
                                    continue block18;
                                }
                            }
                            log.warn((Object)("Unknown meta data type tag :" + qName + " detected. This meta data element will be discarded!"));
                        }
                        if (!found) {
                            log.warn((Object)"No children elements found under 'BAPI_EXPORT'. A response will not be sent back.");
                        }
                    } else {
                        log.error((Object)("Invalid root element found: '" + exportParameters.getLocalName() + "' instead of mandatory element: 'BAPI_EXPORT'. A response will not be sent back.'"));
                    }
                }
            }
            catch (Throwable e) {
                log.error((Object)"Error while processing request. A response will not be sent back.", e);
            }
        }
    }

    public static String getQname(OMElement childElement) {
        return childElement.getQName().toString();
    }

    private static JCoTable processTable(OMElement element, JCoFunction function, String tableName) throws AxisFault {
        JCoTable table = function.getExportParameterList().getTable(tableName);
        if (table == null) {
            log.error((Object)("Didn't find the specified table : " + tableName + " on the RFC repository. This table will be ignored"));
        }
        Axis2RFCHandler.processTable(element, table);
        return table;
    }

    private static void processTable(OMElement element, JCoTable jcoTable) throws AxisFault {
        Iterator itr = element.getChildElements();
        boolean found = false;
        while (itr.hasNext()) {
            found = true;
            OMElement childElement = (OMElement)itr.next();
            String qName = Axis2RFCHandler.getQname(childElement);
            if (qName.equals("row")) {
                String id = childElement.getAttributeValue(RFCConstants.ID_Q);
                Axis2RFCHandler.processRow(childElement, jcoTable, id);
                continue;
            }
            log.warn((Object)("Invalid meta data type element found : " + qName + " .This meta data type will be ignored"));
        }
        if (!found) {
            log.warn((Object)("Table: " + element.getLocalName() + " with no children found. This table will be ignored."));
        }
    }

    private static JCoStructure processStructure(OMElement element, JCoFunction function, String structName) throws AxisFault {
        JCoStructure jCoStructure = function.getExportParameterList().getStructure(structName);
        if (jCoStructure != null) {
            Axis2RFCHandler.processRecord(element, (JCoRecord)jCoStructure);
        } else {
            log.error((Object)("Didn't find the specified structure : " + structName + " on the RFC repository. This structure will be ignored"));
        }
        return jCoStructure;
    }

    private static void processStructure(OMElement element, JCoStructure jCoStructure, String structName) throws AxisFault {
        if (jCoStructure != null) {
            Axis2RFCHandler.processRecord(element, (JCoRecord)jCoStructure);
        } else {
            log.error((Object)("Didn't find the specified structure : " + structName + " on the RFC repository. This structure will be ignored"));
        }
    }

    public static String getElementName(OMElement element) throws AxisFault {
        String name = element.getAttributeValue(RFCConstants.NAME_Q);
        if (name == null) {
            String message = "Attribute value of qualified name : 'name' for the element: '" + element.getLocalName() + "' is null. A response will not be sent back";
            throw new AxisFault(message);
        }
        return name;
    }

    private static void processRow(OMElement element, JCoTable table, String id) throws AxisFault {
        int rowId;
        try {
            rowId = Integer.parseInt(id);
        }
        catch (NumberFormatException ex) {
            log.warn((Object)("Row ID should be an integer, found " + id + ". Skipping row"), (Throwable)ex);
            return;
        }
        if (table.getNumRows() <= rowId) {
            table.appendRow();
        } else {
            table.setRow(rowId);
        }
        Axis2RFCHandler.processRecord(element, (JCoRecord)table);
    }

    private static void processRecord(OMElement element, JCoRecord record) throws AxisFault {
        Iterator itr = element.getChildElements();
        boolean found = false;
        block10: while (itr.hasNext()) {
            String qName;
            found = true;
            OMElement childElement = (OMElement)itr.next();
            switch (qName = Axis2RFCHandler.getQname(childElement)) {
                case "structure": {
                    String structureName = Axis2RFCHandler.getElementName(childElement);
                    Axis2RFCHandler.processStructure(childElement, record.getStructure(structureName), structureName);
                    continue block10;
                }
                case "table": {
                    String tableName = Axis2RFCHandler.getElementName(childElement);
                    Axis2RFCHandler.processTable(childElement, record.getTable(tableName));
                    continue block10;
                }
                case "field": {
                    Axis2RFCHandler.processField(childElement, record);
                    continue block10;
                }
            }
            log.warn((Object)("Invalid meta data type element found : " + qName + " .This meta data type will be ignored"));
        }
        if (!found) {
            log.warn((Object)("Record: " + element.getLocalName() + " with no children found. This record will be ignored."));
        }
    }

    public static String getFieldValue(OMElement element, String name) throws AxisFault {
        String fieldValue = element.getText();
        if (fieldValue != null) {
            return fieldValue;
        }
        return "";
    }

    private static void processField(OMElement element, JCoRecord record) throws AxisFault {
        String fieldName = element.getAttributeValue(RFCConstants.NAME_Q);
        if (fieldName == null) {
            throw new AxisFault("A field should have a name. A response will not be sent back");
        }
        String fieldValue = Axis2RFCHandler.getFieldValue(element, fieldName);
        record.setValue(fieldName, fieldValue);
    }

    private class BAPIWorker
    implements Runnable {
        private JCoFunction function;
        private String xmlContent;
        private SAPOutTransportInfo bapiOutTransportInfo;

        BAPIWorker(String xmlContent, JCoFunction function, SAPOutTransportInfo bapiOutTransportInfo) {
            this.xmlContent = xmlContent;
            this.function = function;
            this.bapiOutTransportInfo = bapiOutTransportInfo;
        }

        BAPIWorker(String xmlContent) {
            this.xmlContent = xmlContent;
        }

        @Override
        public void run() {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Starting a new BAPI worker thread to process the incoming request");
            }
            try (ByteArrayInputStream bais = new ByteArrayInputStream(this.xmlContent.getBytes());){
                MessageContext msgContext = Axis2RFCHandler.this.endpoint.createMessageContext();
                msgContext.setIncomingTransportName("bapi");
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Creating SOAP envelope from the BAPI function call");
                }
                SOAPEnvelope envelope = TransportUtils.createSOAPMessage((MessageContext)msgContext, (InputStream)bais, (String)"application/xml");
                msgContext.setEnvelope(envelope);
                msgContext.setProperty("OutTransportInfo", (Object)this.bapiOutTransportInfo);
                AxisEngine.receive((MessageContext)msgContext);
            }
            catch (Exception e) {
                log.error((Object)"Error while processing the BAPI call through the Axis engine", (Throwable)e);
            }
        }
    }
}

