/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.transports.sap.bapi;

import com.sap.conn.jco.server.DefaultServerHandlerFactory;
import com.sap.conn.jco.server.JCoServer;
import com.sap.conn.jco.server.JCoServerCallHandlerFactory;
import com.sap.conn.jco.server.JCoServerFactory;
import org.apache.axis2.AxisFault;
import org.apache.axis2.transport.base.threads.WorkerPool;
import org.wso2.carbon.transports.sap.SAPEndpoint;
import org.wso2.carbon.transports.sap.bapi.Axis2RFCHandler;

public class BAPIEndpoint
extends SAPEndpoint {
    private JCoServer server;

    @Override
    public void startEndpoint(WorkerPool workerPool) throws AxisFault {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Starting the JCo endpoint : " + this.serverName));
        }
        try {
            this.server = JCoServerFactory.getServer((String)this.serverName);
            DefaultServerHandlerFactory.FunctionHandlerFactory factory = new DefaultServerHandlerFactory.FunctionHandlerFactory();
            factory.registerGenericHandler((Object)new Axis2RFCHandler(this, workerPool));
            this.server.setCallHandlerFactory((JCoServerCallHandlerFactory)factory);
            this.setupOptionalFeatures(this.server);
            this.server.start();
            log.info((Object)("JCo server started with server name : " + this.serverName + " and program ID : " + this.server.getProgramID()));
        }
        catch (Exception e) {
            this.handleException("Error while initializing the SAP JCo server", e);
        }
    }

    @Override
    public void stopEndpoint() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Stopping the JCo endpoint : " + this.serverName));
        }
        this.server.stop();
        this.server.release();
        if (!this.waitForServerStop(this.server)) {
            log.warn((Object)("JCo server : " + this.serverName + " is taking an unusually long time to stop."));
        } else {
            log.info((Object)("JCo server : " + this.serverName + " stopped"));
        }
    }
}

