/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.transports.sap.bapi.util;

import com.sap.conn.jco.JCoField;
import com.sap.conn.jco.JCoFunction;
import com.sap.conn.jco.JCoStructure;
import com.sap.conn.jco.JCoTable;
import java.util.Iterator;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.AxisFault;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.transports.sap.bapi.util.RFCConstants;

public class RFCMetaDataParser {
    private static Log log = LogFactory.getLog(RFCMetaDataParser.class);

    public static void processMetaDataDocument(OMElement document, JCoFunction function) throws AxisFault {
        Iterator itr = document.getChildElements();
        while (itr.hasNext()) {
            OMElement childElement = (OMElement)itr.next();
            RFCMetaDataParser.processElement(childElement, function);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Processed metadata document");
        }
    }

    public static String getBAPIRFCFunctionName(OMElement rootElement) throws AxisFault {
        if (rootElement != null) {
            String rfcFunctionName = rootElement.getAttributeValue(RFCConstants.NAME_Q);
            if (rfcFunctionName != null) {
                return rfcFunctionName;
            }
            throw new AxisFault("BAPI/RFC function name is mandatory in meta data configuration");
        }
        throw new AxisFault("Invalid meta data root element.Found: " + rootElement + ". Required:" + "bapirfc");
    }

    private static void processElement(OMElement element, JCoFunction function) throws AxisFault {
        String qname = element.getQName().toString();
        if (qname != null) {
            if (qname.equals("import")) {
                RFCMetaDataParser.processImport(element, function);
            } else if (qname.equals("tables")) {
                RFCMetaDataParser.processTables(element, function);
            } else {
                log.warn((Object)("Unknown meta data type tag :" + qname + " detected. This meta data element will be discarded!"));
            }
        }
    }

    private static void processImport(OMElement element, JCoFunction function) throws AxisFault {
        Iterator itr = element.getChildElements();
        while (itr.hasNext()) {
            OMElement childElement = (OMElement)itr.next();
            String qname = childElement.getQName().toString();
            String name = childElement.getAttributeValue(RFCConstants.NAME_Q);
            if (qname.equals("structure")) {
                RFCMetaDataParser.processStructure(childElement, function, name);
                continue;
            }
            if (qname.equals("field")) {
                RFCMetaDataParser.processField(childElement, function, name);
                continue;
            }
            if (qname.equals("tables")) {
                RFCMetaDataParser.processTablesParameter(childElement, function);
                continue;
            }
            log.warn((Object)("Unknown meta data type tag :" + qname + " detected. This meta data element will be discarded!"));
        }
    }

    private static void processStructure(OMElement element, JCoFunction function, String strcutName) throws AxisFault {
        if (strcutName == null) {
            throw new AxisFault("A structure should have a name!");
        }
        JCoStructure jcoStrcture = function.getImportParameterList().getStructure(strcutName);
        if (jcoStrcture != null) {
            Iterator itr = element.getChildElements();
            boolean isRecordFound = false;
            while (itr.hasNext()) {
                OMElement childElement = (OMElement)itr.next();
                String qname = childElement.getQName().toString();
                if (qname.equals("field")) {
                    String fieldName = childElement.getAttributeValue(RFCConstants.NAME_Q);
                    String fieldValue = childElement.getText();
                    for (JCoField field : jcoStrcture) {
                        if (fieldName == null || !fieldName.equals(field.getName())) continue;
                        isRecordFound = true;
                        field.setValue(fieldValue);
                        break;
                    }
                    if (isRecordFound) continue;
                    throw new AxisFault("Invalid configuration! The field : " + fieldName + " did not find the the strcture : " + strcutName);
                }
                if (qname.equals("structure")) {
                    String structureName = childElement.getAttributeValue(RFCConstants.NAME_Q);
                    JCoStructure jcoStructureInner = jcoStrcture.getStructure(structureName);
                    if (jcoStructureInner == null) {
                        throw new AxisFault("Invalid configuration! The structure : " + structureName + " did not find the the strcture : " + strcutName);
                    }
                    RFCMetaDataParser.processStructure(childElement, jcoStructureInner, structureName);
                    continue;
                }
                if (qname.equals("table")) {
                    String name = childElement.getAttributeValue(RFCConstants.NAME_Q);
                    JCoTable jcoTableInner = jcoStrcture.getTable(name);
                    RFCMetaDataParser.processTable(childElement, jcoTableInner);
                    continue;
                }
                log.warn((Object)("Invalid meta data type element found : " + qname + " .This meta data type will be ignored"));
            }
        } else {
            log.error((Object)("Didn't find the specified structure : " + strcutName + " on the RFC repository. This structure will be ignored"));
        }
    }

    private static void processStructure(OMElement element, JCoStructure jcoStrcture, String strcutName) throws AxisFault {
        if (jcoStrcture != null) {
            Iterator itr = element.getChildElements();
            boolean isRecordFound = false;
            while (itr.hasNext()) {
                OMElement childElement = (OMElement)itr.next();
                String qname = childElement.getQName().toString();
                if (qname.equals("field")) {
                    String fieldName = childElement.getAttributeValue(RFCConstants.NAME_Q);
                    String fieldValue = childElement.getText();
                    for (JCoField field : jcoStrcture) {
                        if (fieldName == null || !fieldName.equals(field.getName())) continue;
                        isRecordFound = true;
                        field.setValue(fieldValue);
                        break;
                    }
                    if (isRecordFound) continue;
                    throw new AxisFault("Invalid configuration! The field : " + fieldName + " did not find the the strcture : " + strcutName);
                }
                if (qname.equals("structure")) {
                    String structureName = childElement.getAttributeValue(RFCConstants.NAME_Q);
                    JCoStructure jcoStructureInner = jcoStrcture.getStructure(structureName);
                    if (jcoStructureInner == null) {
                        throw new AxisFault("Invalid configuration! The structure : " + structureName + " did not find the the strcture : " + strcutName);
                    }
                    RFCMetaDataParser.processStructure(childElement, jcoStructureInner, structureName);
                    continue;
                }
                if (qname.equals("table")) {
                    String tableName = childElement.getAttributeValue(RFCConstants.NAME_Q);
                    JCoTable jcoTableInner = jcoStrcture.getTable(tableName);
                    if (jcoTableInner == null) {
                        throw new AxisFault("Invalid configuration! The table : " + tableName + " did not find the the strcture : " + strcutName);
                    }
                    RFCMetaDataParser.processTable(childElement, jcoTableInner);
                    continue;
                }
                log.warn((Object)("Invalid meta data type element found : " + qname + " .This meta data type will be ignored"));
            }
        } else {
            log.error((Object)("Didn't find the specified structure : " + strcutName + " on the RFC repository. This structure will be ignored"));
        }
    }

    private static void processTable(OMElement element, JCoTable jconTable) throws AxisFault {
        JCoTable inputTable = jconTable;
        Iterator itr = element.getChildElements();
        while (itr.hasNext()) {
            OMElement childElement = (OMElement)itr.next();
            String qname = childElement.getQName().toString();
            String id = childElement.getAttributeValue(RFCConstants.ID_Q);
            if (!qname.equals("row")) continue;
            RFCMetaDataParser.processRow(childElement, inputTable, id);
        }
    }

    private static void processField(OMElement element, JCoFunction function, String fieldName) throws AxisFault {
        if (fieldName == null) {
            throw new AxisFault("A field should have a name!");
        }
        String fieldValue = element.getText();
        if (fieldValue != null) {
            function.getImportParameterList().setValue(fieldName, fieldValue);
        }
    }

    public static void processFieldValue(String fieldName, String fieldValue, JCoFunction function) throws AxisFault {
        if (fieldValue != null) {
            function.getImportParameterList().setValue(fieldName, fieldValue);
        } else {
            log.warn((Object)(fieldName + "is set with an empty value"));
        }
    }

    private static void processTables(OMElement element, JCoFunction function) throws AxisFault {
        Iterator itr = element.getChildElements();
        while (itr.hasNext()) {
            OMElement childElement = (OMElement)itr.next();
            String qname = childElement.getQName().toString();
            String tableName = childElement.getAttributeValue(RFCConstants.NAME_Q);
            if (qname.equals("table")) {
                RFCMetaDataParser.processTable(childElement, function, tableName);
                continue;
            }
            log.warn((Object)("Invalid meta data type element found : " + qname + " .This meta data type will be ignored"));
        }
    }

    private static void processTablesParameter(OMElement element, JCoFunction function) throws AxisFault {
        Iterator itr = element.getChildElements();
        while (itr.hasNext()) {
            OMElement childElement = (OMElement)itr.next();
            String qname = childElement.getQName().toString();
            String tableName = childElement.getAttributeValue(RFCConstants.NAME_Q);
            if (qname.equals("table")) {
                RFCMetaDataParser.processTableParameter(childElement, function, tableName);
                continue;
            }
            log.warn((Object)("Invalid meta data type element found : " + qname + " .This meta data type will be ignored"));
        }
    }

    private static void processTable(OMElement element, JCoFunction function, String tableName) throws AxisFault {
        JCoTable inputTable = function.getTableParameterList().getTable(tableName);
        if (inputTable == null) {
            throw new AxisFault("Input table :" + tableName + " does not exist");
        }
        Iterator itr = element.getChildElements();
        while (itr.hasNext()) {
            OMElement childElement = (OMElement)itr.next();
            String qname = childElement.getQName().toString();
            String id = childElement.getAttributeValue(RFCConstants.ID_Q);
            if (qname.equals("row")) {
                RFCMetaDataParser.processRow(childElement, inputTable, id);
                continue;
            }
            log.warn((Object)("Invalid meta data type element found : " + qname + " .This meta data type will be ignored"));
        }
    }

    private static void processTableParameter(OMElement element, JCoFunction function, String tableName) throws AxisFault {
        JCoTable inputTable = function.getImportParameterList().getTable(tableName);
        if (inputTable == null) {
            throw new AxisFault("Input table parameter :" + tableName + " does not exist");
        }
        Iterator itr = element.getChildElements();
        while (itr.hasNext()) {
            OMElement childElement = (OMElement)itr.next();
            String qname = childElement.getQName().toString();
            String id = childElement.getAttributeValue(RFCConstants.ID_Q);
            if (qname.equals("row")) {
                RFCMetaDataParser.processRow(childElement, inputTable, id);
                continue;
            }
            log.warn((Object)("Invalid meta data type element found : " + qname + " .This meta data type will be ignored"));
        }
    }

    private static void processRow(OMElement element, JCoTable table, String id) throws AxisFault {
        int rowId;
        try {
            rowId = Integer.parseInt(id);
        }
        catch (NumberFormatException ex) {
            log.warn((Object)("Row ID should be a integer, found " + id + ". Skipping row"), (Throwable)ex);
            return;
        }
        if (table.getNumRows() <= rowId) {
            table.appendRow();
        } else {
            table.setRow(rowId);
        }
        Iterator itr = element.getChildElements();
        while (itr.hasNext()) {
            OMElement childElement = (OMElement)itr.next();
            String qname = childElement.getQName().toString();
            if (qname != null && qname.equals("field")) {
                RFCMetaDataParser.processField(childElement, table);
                continue;
            }
            if (qname != null && qname.equals("structure")) {
                String structureName = childElement.getAttributeValue(RFCConstants.NAME_Q);
                JCoStructure jcoStrctureInner = table.getStructure(structureName);
                if (jcoStrctureInner != null) {
                    RFCMetaDataParser.processStructure(childElement, jcoStrctureInner, structureName);
                    continue;
                }
                log.warn((Object)("Invalid meta data type element found : " + structureName + " .This meta data type will be ignored"));
                continue;
            }
            if (qname != null && qname.equals("table")) {
                String tableName = childElement.getAttributeValue(RFCConstants.NAME_Q);
                JCoTable jCoTableInner = table.getTable(tableName);
                if (jCoTableInner != null) {
                    RFCMetaDataParser.processTable(childElement, jCoTableInner);
                    continue;
                }
                log.warn((Object)("Invalid table name found : " + tableName + ". Processing this table will be ignored"));
                continue;
            }
            log.warn((Object)("Invalid meta data type element found : " + qname + " .This meta data type will be ignored"));
        }
    }

    private static void processField(OMElement element, JCoTable table) throws AxisFault {
        String fieldName = element.getAttributeValue(RFCConstants.NAME_Q);
        String fieldValue = element.getText();
        if (fieldName == null) {
            throw new AxisFault("A field should have a name!");
        }
        if (fieldValue != null) {
            table.setValue(fieldName, fieldValue);
        }
    }
}

