/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.transports.sap.idoc;

import com.sap.conn.idoc.IDocDocumentList;
import com.sap.conn.idoc.IDocXMLProcessor;
import com.sap.conn.idoc.jco.JCoIDoc;
import com.sap.conn.idoc.jco.JCoIDocHandler;
import com.sap.conn.jco.server.JCoServerContext;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.engine.AxisEngine;
import org.apache.axis2.transport.TransportUtils;
import org.apache.axis2.transport.base.threads.WorkerPool;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.transports.sap.idoc.IDocEndpoint;
import org.wso2.carbon.transports.sap.idoc.util.IDoCAdapterUtils;

public class Axis2IDocHandler
implements JCoIDocHandler {
    private static final Log log = LogFactory.getLog(Axis2IDocHandler.class);
    private WorkerPool workerPool;
    private IDocEndpoint endpoint;
    private IDocXMLProcessor xmlProcessor;

    public Axis2IDocHandler(WorkerPool workerPool, IDocEndpoint endpoint) {
        this.workerPool = workerPool;
        this.endpoint = endpoint;
        this.xmlProcessor = JCoIDoc.getIDocFactory().getIDocXMLProcessor();
    }

    public void handleRequest(JCoServerContext jCoServerContext, IDocDocumentList iDocDocumentList) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"New IDoc received");
        }
        this.workerPool.execute((Runnable)new IDocWorker(jCoServerContext, iDocDocumentList));
    }

    private class IDocWorker
    implements Runnable {
        private JCoServerContext serverContext;
        private IDocDocumentList docList;

        private IDocWorker(JCoServerContext serverContext, IDocDocumentList docList) {
            this.serverContext = serverContext;
            this.docList = docList;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Starting a new IDoc worker thread to process the incoming request");
            }
            ByteArrayInputStream bais = null;
            ByteArrayOutputStream baos = null;
            OutputStreamWriter osw = null;
            try {
                baos = new ByteArrayOutputStream();
                osw = new OutputStreamWriter((OutputStream)baos, "UTF8");
                Axis2IDocHandler.this.xmlProcessor.render(this.docList, (Writer)osw);
                osw.flush();
                String output = baos.toString();
                if (output.contains("<?xml version=\"1.1\"?>")) {
                    output = output.replaceFirst("1.1", "1.0");
                }
                MessageContext msgContext = Axis2IDocHandler.this.endpoint.createMessageContext();
                msgContext.setIncomingTransportName("idoc");
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Creating SOAP envelope from the IDoc");
                }
                bais = new ByteArrayInputStream(output.getBytes());
                if (log.isDebugEnabled()) {
                    int len;
                    StringBuffer buffer = new StringBuffer("Received IDoc content: ");
                    ByteArrayInputStream loggingStream = new ByteArrayInputStream(baos.toByteArray());
                    byte[] data = new byte[1024];
                    while ((len = loggingStream.read(data)) != -1) {
                        buffer.append(new String(data, 0, len));
                    }
                    log.debug((Object)buffer.toString());
                }
                SOAPEnvelope envelope = TransportUtils.createSOAPMessage((MessageContext)msgContext, (InputStream)bais, (String)"application/xml");
                msgContext.setEnvelope(envelope);
                String stampArcKey = IDoCAdapterUtils.getProperty("stamp_r_arc_key");
                if (stampArcKey == null || !stampArcKey.equals("false")) {
                    IDoCAdapterUtils.stampArcKey(envelope.getBody().getFirstElement(), msgContext.getMessageID());
                }
                AxisEngine.receive((MessageContext)msgContext);
                this.closeStream(osw);
                this.closeStream(baos);
                this.closeStream(bais);
            }
            catch (Exception e) {
                try {
                    log.error((Object)"Error while processing the IDoc through the Axis engine", (Throwable)e);
                    this.closeStream(osw);
                    this.closeStream(baos);
                    this.closeStream(bais);
                }
                catch (Throwable throwable) {
                    this.closeStream(osw);
                    this.closeStream(baos);
                    this.closeStream(bais);
                    throw throwable;
                }
            }
        }

        private void closeStream(Closeable obj) {
            try {
                obj.close();
            }
            catch (IOException e) {
                log.error((Object)"Error while closing the stream", (Throwable)e);
            }
        }
    }
}

