/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.transports.sap.idoc;

import com.sap.conn.idoc.IDocDocumentList;
import com.sap.conn.idoc.IDocRepository;
import com.sap.conn.idoc.IDocXMLProcessor;
import com.sap.conn.idoc.jco.JCoIDoc;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.soap.SOAPBody;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.transports.sap.idoc.IDocXMLMapper;
import org.wso2.carbon.transports.sap.idoc.util.IDoCAdapterUtils;

public class DefaultIDocXMLMapper
implements IDocXMLMapper {
    private Log log = LogFactory.getLog(this.getClass());
    private IDocXMLProcessor xmlProcessor = JCoIDoc.getIDocFactory().getIDocXMLProcessor();

    @Override
    public IDocDocumentList getDocumentList(IDocRepository repo, MessageContext msgContext) throws AxisFault {
        ByteArrayOutputStream baos;
        ByteArrayInputStream bais;
        block6: {
            bais = null;
            baos = null;
            baos = new ByteArrayOutputStream();
            SOAPBody body = msgContext.getEnvelope().getBody();
            OMElement idocElement = body.getFirstElement();
            String stampArcKey = IDoCAdapterUtils.getProperty("stamp_s_arc_key");
            if (stampArcKey == null || !stampArcKey.equals("false")) {
                IDoCAdapterUtils.stampArcKey(idocElement, msgContext.getMessageID());
            }
            idocElement.serialize((OutputStream)baos);
            baos.flush();
            bais = new ByteArrayInputStream(baos.toByteArray());
            Object prop = msgContext.getOptions().getProperty("transport.sap.xmlParserOptions");
            if (prop == null) break block6;
            IDocDocumentList iDocDocumentList = this.xmlProcessor.parse(repo, (InputStream)bais, Integer.parseInt(prop.toString()));
            this.closeStream(bais);
            this.closeStream(baos);
            return iDocDocumentList;
        }
        try {
            IDocDocumentList iDocDocumentList = this.xmlProcessor.parse(repo, (InputStream)bais);
            this.closeStream(bais);
            this.closeStream(baos);
            return iDocDocumentList;
        }
        catch (Exception e) {
            try {
                throw new AxisFault("Error while retrieving IDocs from the message context", (Throwable)e);
            }
            catch (Throwable throwable) {
                this.closeStream(bais);
                this.closeStream(baos);
                throw throwable;
            }
        }
    }

    private void closeStream(Closeable stream) {
        try {
            stream.close();
        }
        catch (IOException e) {
            this.log.error((Object)"Error while closing the stream", (Throwable)e);
        }
    }
}

