/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.transports.sap.idoc.util;

import java.util.Iterator;
import java.util.UUID;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNode;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class IDoCAdapterUtils {
    private static Log log = LogFactory.getLog(IDoCAdapterUtils.class);
    private static final QName IDOC_Q = new QName("IDOC");
    private static final QName ARCKEY_Q = new QName("ARCKEY");
    private static final QName EDI_DC40_Q = new QName("EDI_DC40");
    protected static final OMFactory fac = OMAbstractFactory.getOMFactory();

    public static void stampArcKey(OMElement element, String msgId) {
        boolean isStampArcKey = false;
        String arcKey = msgId == null ? IDoCAdapterUtils.generateUUID() : msgId;
        Iterator itr = element.getChildrenWithName(IDOC_Q);
        while (itr.hasNext()) {
            OMElement idocElement = (OMElement)itr.next();
            OMElement controlElement = idocElement.getFirstChildWithName(EDI_DC40_Q);
            OMElement arcKeyElement = controlElement.getFirstChildWithName(ARCKEY_Q);
            if (arcKeyElement != null && !arcKeyElement.getText().equals("")) continue;
            isStampArcKey = true;
            OMElement newArcKeyEle = fac.createOMElement(ARCKEY_Q);
            newArcKeyEle.setText(arcKey);
            controlElement.addChild((OMNode)newArcKeyEle);
        }
        if (log.isDebugEnabled() && isStampArcKey) {
            log.debug((Object)("The ARCKEY ' " + arcKey + " ', stamped into the control segment"));
        }
    }

    public static String getProperty(String name) {
        return System.getProperty(name);
    }

    private static String generateUUID() {
        return UUID.randomUUID().toString();
    }
}

