/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.metrics.common;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.Map;
import java.util.Stack;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMException;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.metrics.common.MetricsConfigException;
import org.wso2.carbon.metrics.common.MetricsConfiguration;
import org.wso2.securevault.SecretResolver;
import org.wso2.securevault.SecretResolverFactory;

public class MetricsXMLConfiguration
extends MetricsConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(MetricsXMLConfiguration.class);
    private Map<String, String> configurationMap = new ConcurrentHashMap<String, String>();
    private SecretResolver secretResolver;
    private boolean initialized;
    private static final Pattern SYSTEM_PROPERTY_PATTERN = Pattern.compile("\\$\\{([\\w\\.]*)\\}");

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void load(String filePath) throws MetricsConfigException {
        if (this.initialized) {
            return;
        }
        FileInputStream in = null;
        try {
            if (logger.isDebugEnabled()) {
                logger.debug(String.format("Loading Metrics Configuration from %s", filePath));
            }
            in = FileUtils.openInputStream((File)new File(filePath));
            StAXOMBuilder builder = new StAXOMBuilder((InputStream)in);
            this.secretResolver = SecretResolverFactory.create((OMElement)builder.getDocumentElement(), (boolean)true);
            this.readChildElements(builder.getDocumentElement(), new Stack<String>());
            this.initialized = true;
        }
        catch (IOException e) {
            try {
                throw new MetricsConfigException("I/O error while reading the configuration file: " + filePath, e);
                catch (XMLStreamException e2) {
                    throw new MetricsConfigException("Error while parsing the configuration file: " + filePath, e2);
                }
                catch (OMException e3) {
                    throw new MetricsConfigException("Error while parsing the configuration file: " + filePath, e3);
                }
                catch (Exception e4) {
                    throw new MetricsConfigException("Unexpected error occurred while parsing configuration: " + filePath, e4);
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(in);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)in);
    }

    @Override
    public String getProperty(String key) {
        return this.configurationMap.get(key);
    }

    private void readChildElements(OMElement serverConfig, Stack<String> nameStack) {
        Iterator childElements = serverConfig.getChildElements();
        while (childElements.hasNext()) {
            OMElement element = (OMElement)childElements.next();
            String localName = element.getLocalName();
            nameStack.push(localName);
            if (this.elementHasText(element)) {
                String key = this.getKey(nameStack);
                String value = element.getText();
                if (this.secretResolver.isInitialized() && this.secretResolver.isTokenProtected(key)) {
                    value = this.secretResolver.resolve(key);
                }
                this.addToConfiguration(key, MetricsXMLConfiguration.replaceSystemProperties(value));
            }
            this.readChildElements(element, nameStack);
            nameStack.pop();
        }
    }

    private String getKey(Stack<String> nameStack) {
        StringBuilder key = new StringBuilder();
        for (int i = 0; i < nameStack.size(); ++i) {
            String name = (String)nameStack.elementAt(i);
            key.append(name).append(".");
        }
        key.deleteCharAt(key.lastIndexOf("."));
        return key.toString();
    }

    private boolean elementHasText(OMElement element) {
        String text = element.getText();
        return text != null && text.trim().length() > 0;
    }

    private void addToConfiguration(String key, String value) {
        if (logger.isTraceEnabled()) {
            logger.trace(String.format("Adding configuration '%s' with value '%s'", key, value));
        }
        this.configurationMap.put(key, value);
    }

    public static String replaceSystemProperties(String text) {
        Matcher matcher = SYSTEM_PROPERTY_PATTERN.matcher(text);
        boolean found = matcher.find();
        if (!found) {
            return text;
        }
        StringBuffer sb = new StringBuffer();
        do {
            String name;
            String value;
            if ((value = System.getProperty(name = matcher.group(1))) == null) continue;
            matcher.appendReplacement(sb, value);
        } while (matcher.find());
        matcher.appendTail(sb);
        String replaced = sb.toString();
        if (logger.isDebugEnabled()) {
            logger.debug(String.format("Replaced. Old: '%s', New: '%s'", text, replaced));
        }
        return replaced;
    }
}

