/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.metrics.core.impl.reservoir;

import com.codahale.metrics.Reservoir;
import com.codahale.metrics.Snapshot;
import org.HdrHistogram.AbstractHistogram;
import org.HdrHistogram.Histogram;
import org.HdrHistogram.Recorder;
import org.wso2.carbon.metrics.core.impl.reservoir.HdrHistogramSnapshot;

public final class HdrHistogramReservoir
implements Reservoir {
    private final Recorder recorder;
    private final Histogram histogram;
    private Histogram intervalHistogram;

    public HdrHistogramReservoir() {
        this(new Recorder(2));
    }

    public HdrHistogramReservoir(Recorder recorder) {
        this.recorder = recorder;
        this.intervalHistogram = recorder.getIntervalHistogram();
        this.histogram = new Histogram(this.intervalHistogram.getNumberOfSignificantValueDigits());
    }

    public int size() {
        return this.getSnapshot().size();
    }

    public void update(long value) {
        this.recorder.recordValue(value);
    }

    public Snapshot getSnapshot() {
        return new HdrHistogramSnapshot(this.getHistogram());
    }

    private synchronized Histogram getHistogram() {
        this.intervalHistogram = this.recorder.getIntervalHistogram(this.intervalHistogram);
        this.histogram.add((AbstractHistogram)this.intervalHistogram);
        return this.histogram.copy();
    }
}

