/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.metrics.core.impl;

import com.codahale.metrics.Timer;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import org.wso2.carbon.metrics.core.Level;
import org.wso2.carbon.metrics.core.Snapshot;
import org.wso2.carbon.metrics.core.Timer;
import org.wso2.carbon.metrics.core.impl.AbstractMetric;
import org.wso2.carbon.metrics.core.impl.SnapshotImpl;

public class TimerImpl
extends AbstractMetric
implements Timer {
    private final com.codahale.metrics.Timer timer;

    public TimerImpl(String name, Level level, com.codahale.metrics.Timer timer) {
        super(name, level);
        this.timer = timer;
    }

    @Override
    public void update(long duration, TimeUnit unit) {
        if (this.isEnabled()) {
            this.timer.update(duration, unit);
        }
    }

    @Override
    public <T> T time(Callable<T> event) throws Exception {
        if (this.isEnabled()) {
            return (T)this.timer.time(event);
        }
        return null;
    }

    @Override
    public Timer.Context start() {
        if (this.isEnabled()) {
            return new ContextImpl(this.timer.time());
        }
        return new DummyContextImpl();
    }

    @Override
    public long getCount() {
        return this.timer.getCount();
    }

    @Override
    public double getFifteenMinuteRate() {
        return this.timer.getFifteenMinuteRate();
    }

    @Override
    public double getFiveMinuteRate() {
        return this.timer.getFiveMinuteRate();
    }

    @Override
    public double getMeanRate() {
        return this.timer.getMeanRate();
    }

    @Override
    public double getOneMinuteRate() {
        return this.timer.getOneMinuteRate();
    }

    @Override
    public Snapshot getSnapshot() {
        return new SnapshotImpl(this.timer.getSnapshot());
    }

    private static class DummyContextImpl
    implements Timer.Context {
        private DummyContextImpl() {
        }

        @Override
        public long stop() {
            return 0L;
        }

        @Override
        public void close() {
        }
    }

    private static class ContextImpl
    implements Timer.Context {
        private Timer.Context context;

        private ContextImpl(Timer.Context context) {
            this.context = context;
        }

        @Override
        public long stop() {
            return this.context.stop();
        }

        @Override
        public void close() {
            this.context.close();
        }
    }
}

