/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.metrics.core.reporter.impl;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.metrics.core.reporter.Reporter;

public abstract class AbstractReporter
implements Reporter {
    private static final Logger logger = LoggerFactory.getLogger(AbstractReporter.class);
    private volatile boolean running;
    private final String name;

    public AbstractReporter(String name) {
        if (name == null || name.trim().isEmpty()) {
            throw new IllegalArgumentException("The reporter name cannot be null");
        }
        this.name = name;
    }

    @Override
    public final String getName() {
        return this.name;
    }

    @Override
    public boolean isRunning() {
        return this.running;
    }

    @Override
    public final void start() {
        if (!this.running) {
            this.startReporter();
            this.running = true;
            if (logger.isDebugEnabled()) {
                logger.debug("Started '{}' reporter for Metrics", (Object)this.name);
            }
        }
    }

    public abstract void startReporter();

    @Override
    public final void stop() {
        if (this.running) {
            this.stopReporter();
            this.running = false;
            if (logger.isDebugEnabled()) {
                logger.debug("Stopped '{}' reporter for Metrics", (Object)this.name);
            }
        }
    }

    public abstract void stopReporter();
}

