/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.metrics.impl;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.metrics.impl.MetricsLevelConfigException;
import org.wso2.carbon.metrics.manager.Level;

public class MetricsLevelConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(MetricsLevelConfiguration.class);
    private Level rootLevel = Level.OFF;
    private final Map<String, Level> levelMap = Collections.synchronizedMap(new HashMap());
    private static final String METRICS_ROOT_LEVEL = "metrics.rootLevel";
    private static final String METRIC_LEVEL_PREFIX = "metric.level.";
    private static final String METRICS_LEVEL_CONFIGURATION = "metrics.level.configuration";

    public void loadFromSystemPropertyFile() throws MetricsLevelConfigException {
        String filePath = System.getProperty(METRICS_LEVEL_CONFIGURATION);
        if (filePath != null && filePath.length() > 0) {
            this.load(filePath);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void load(String filePath) throws MetricsLevelConfigException {
        Properties properties = new Properties();
        FileInputStream in = null;
        try {
            if (logger.isDebugEnabled()) {
                logger.debug(String.format("Loading Metrics Level Configuration from %s", filePath));
            }
            in = new FileInputStream(filePath);
            properties.load(in);
            in.close();
        }
        catch (FileNotFoundException e) {
            try {
                throw new MetricsLevelConfigException("File not found: " + filePath, e);
                catch (IOException e2) {
                    throw new MetricsLevelConfigException("I/O error while reading the configuration file: " + filePath, e2);
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(in);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)in);
        this.setLevels(properties);
    }

    private void setLevels(Properties properties) {
        this.rootLevel = Level.toLevel((String)properties.getProperty(METRICS_ROOT_LEVEL, Level.OFF.name()).trim(), (Level)Level.OFF);
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String key = (String)enumeration.nextElement();
            if (!key.startsWith(METRIC_LEVEL_PREFIX)) continue;
            String metricName = key.substring(METRIC_LEVEL_PREFIX.length());
            String value = properties.getProperty(key);
            if (value == null) continue;
            this.levelMap.put(metricName, Level.toLevel((String)value.trim(), (Level)Level.OFF));
        }
    }

    public Level getRootLevel() {
        return this.rootLevel;
    }

    public void setRootLevel(Level rootLevel) {
        this.rootLevel = rootLevel;
    }

    public Level getLevel(String metricName) {
        return this.levelMap.get(metricName);
    }

    public void setLevel(String metricName, Level level) {
        this.levelMap.put(metricName, level);
    }
}

