/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.metrics.impl.internal;

import java.io.File;
import java.sql.Connection;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.utils.CarbonUtils;
import org.wso2.carbon.utils.dbcreator.DatabaseCreator;

public class LocalDatabaseCreator
extends DatabaseCreator {
    private DataSource dataSource;
    private static final Logger logger = LoggerFactory.getLogger(LocalDatabaseCreator.class);

    public LocalDatabaseCreator(DataSource dataSource) {
        super(dataSource);
        this.dataSource = dataSource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createRegistryDatabase() throws Exception {
        try (Connection connection = null;){
            connection = this.dataSource.getConnection();
            String databaseType = LocalDatabaseCreator.getDatabaseType((Connection)connection);
            String sqlScriptPath = this.getDbScriptLocation(databaseType);
            File scriptFile = new File(sqlScriptPath);
            if (scriptFile.exists()) {
                if (logger.isInfoEnabled()) {
                    logger.info(String.format("Using the SQL script file '%s' to create Metrics Database tables", sqlScriptPath));
                }
            } else {
                if (logger.isWarnEnabled()) {
                    logger.warn(String.format("The expected SQL script file '%s' is not available to create Metrics Database tables", sqlScriptPath));
                }
                return;
            }
            super.createRegistryDatabase();
            connection.close();
            connection = null;
        }
    }

    protected String getDbScriptLocation(String databaseType) {
        String scriptName = databaseType + ".sql";
        if (logger.isDebugEnabled()) {
            logger.debug(String.format("SQL Script File Name: %s", scriptName));
        }
        String carbonHome = CarbonUtils.getCarbonHome();
        return carbonHome + "/dbscripts/metrics/" + scriptName;
    }
}

