/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.metrics.impl.internal;

import java.io.File;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.metrics.common.MetricsConfigException;
import org.wso2.carbon.metrics.common.MetricsConfiguration;
import org.wso2.carbon.metrics.common.MetricsXMLConfiguration;
import org.wso2.carbon.metrics.impl.MetricServiceImpl;
import org.wso2.carbon.metrics.impl.MetricsLevelConfigException;
import org.wso2.carbon.metrics.impl.MetricsLevelConfiguration;
import org.wso2.carbon.metrics.impl.util.CsvReporterBuilder;
import org.wso2.carbon.metrics.impl.util.DASReporterBuilder;
import org.wso2.carbon.metrics.impl.util.JDBCReporterBuilder;
import org.wso2.carbon.metrics.impl.util.JmxReporterBuilder;
import org.wso2.carbon.metrics.manager.MetricService;
import org.wso2.carbon.registry.core.service.RegistryService;
import org.wso2.carbon.utils.CarbonUtils;

@Component(name="org.wso2.carbon.metrics.impl.internal.MetricsImplComponent", immediate=true)
public class MetricsImplComponent {
    private static final Logger logger = LoggerFactory.getLogger(MetricsImplComponent.class);
    private ServiceRegistration metricsServiceRegistration;
    private MetricService metricService;

    @Activate
    protected void activate(ComponentContext componentContext) {
        MetricsLevelConfiguration levelConfiguration;
        MetricsXMLConfiguration configuration;
        block6: {
            String filePath;
            block5: {
                if (logger.isDebugEnabled()) {
                    logger.debug("Metrics Service component activated");
                }
                configuration = new MetricsXMLConfiguration();
                filePath = CarbonUtils.getCarbonConfigDirPath() + File.separator + "metrics.xml";
                try {
                    configuration.load(filePath);
                }
                catch (MetricsConfigException e) {
                    if (!logger.isErrorEnabled()) break block5;
                    logger.error("Error reading configuration from " + filePath, (Throwable)e);
                }
            }
            levelConfiguration = new MetricsLevelConfiguration();
            String propertiesFilePath = CarbonUtils.getCarbonConfigDirPath() + File.separator + "metrics.properties";
            try {
                levelConfiguration.load(propertiesFilePath);
            }
            catch (MetricsLevelConfigException e) {
                if (!logger.isErrorEnabled()) break block6;
                logger.error("Error reading metrics level configuration from " + filePath, (Throwable)e);
            }
        }
        this.metricService = new MetricServiceImpl.Builder().configure((MetricsConfiguration)configuration).addReporterBuilder(new JmxReporterBuilder().configure((MetricsConfiguration)configuration)).addReporterBuilder(new CsvReporterBuilder().configure((MetricsConfiguration)configuration)).addReporterBuilder(new JDBCReporterBuilder().configure((MetricsConfiguration)configuration)).addReporterBuilder(new DASReporterBuilder().configure((MetricsConfiguration)configuration)).build(levelConfiguration);
        this.metricsServiceRegistration = componentContext.getBundleContext().registerService(MetricService.class.getName(), (Object)this.metricService, null);
    }

    @Deactivate
    protected void deactivate(ComponentContext componentContext) {
        if (logger.isDebugEnabled()) {
            logger.debug("Deactivating Metrics Service component");
        }
        this.metricService.disable();
        this.metricsServiceRegistration.unregister();
    }

    @Reference(name="registry.service", service=RegistryService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetRegistryService")
    protected void setRegistryService(RegistryService registryService) {
        if (registryService != null && logger.isDebugEnabled()) {
            logger.debug("Registry service initialized");
        }
    }

    protected void unsetRegistryService(RegistryService registryService) {
    }
}

