/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.metrics.impl.reporter;

import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.MetricRegistry;
import java.util.concurrent.TimeUnit;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.metrics.impl.reporter.AbstractReporter;
import org.wso2.carbon.metrics.impl.reporter.ScheduledReporter;
import org.wso2.carbon.metrics.impl.task.ScheduledJDBCMetricsCleanupTask;
import org.wso2.carbon.metrics.jdbc.reporter.JDBCReporter;

public class JDBCReporterImpl
extends AbstractReporter
implements ScheduledReporter {
    private static final Logger logger = LoggerFactory.getLogger(JDBCReporterImpl.class);
    private final MetricRegistry metricRegistry;
    private final MetricFilter metricFilter;
    private final String source;
    private final DataSource dataSource;
    private final long pollingPeriod;
    private final boolean runCleanupTask;
    private final int daysToKeep;
    private final long cleanupPeriod;
    private JDBCReporter jdbcReporter;
    private ScheduledJDBCMetricsCleanupTask scheduledJDBCMetricsCleanupTask;

    public JDBCReporterImpl(MetricRegistry metricRegistry, MetricFilter metricFilter, String source, DataSource dataSource, long pollingPeriod, boolean runCleanupTask, int daysToKeep, long cleanupPeriod) {
        super("JDBC");
        this.metricRegistry = metricRegistry;
        this.metricFilter = metricFilter;
        this.source = source;
        this.dataSource = dataSource;
        this.pollingPeriod = pollingPeriod;
        this.runCleanupTask = runCleanupTask;
        this.daysToKeep = daysToKeep;
        this.cleanupPeriod = cleanupPeriod;
    }

    @Override
    public void report() {
        if (this.jdbcReporter != null) {
            this.jdbcReporter.report();
        }
    }

    @Override
    public void startReporter() {
        this.jdbcReporter = JDBCReporter.forRegistry((MetricRegistry)this.metricRegistry).filter(this.metricFilter).convertRatesTo(TimeUnit.SECONDS).convertDurationsTo(TimeUnit.MILLISECONDS).convertTimestampTo(TimeUnit.MILLISECONDS).build(this.source, this.dataSource);
        this.jdbcReporter.start(this.pollingPeriod, TimeUnit.SECONDS);
        if (this.runCleanupTask) {
            this.scheduledJDBCMetricsCleanupTask = new ScheduledJDBCMetricsCleanupTask(this.dataSource, this.daysToKeep);
            this.scheduledJDBCMetricsCleanupTask.start(this.cleanupPeriod, TimeUnit.SECONDS);
        }
    }

    @Override
    public void stopReporter() {
        try {
            this.jdbcReporter.stop();
            this.jdbcReporter = null;
        }
        catch (Throwable e) {
            logger.error("An error occurred when trying to stop the reporter", e);
        }
        try {
            if (this.scheduledJDBCMetricsCleanupTask != null) {
                this.scheduledJDBCMetricsCleanupTask.stop();
            }
        }
        catch (Throwable e) {
            logger.error("An error occurred when trying to stop the cleanup task", e);
        }
    }
}

