/*
 * Copyright 2015 WSO2 Inc. (http://wso2.org)
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *     http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.wso2.carbon.metrics.impl.util;

import org.wso2.carbon.metrics.common.MetricsConfiguration;
import org.wso2.carbon.metrics.impl.reporter.Reporter;

import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.MetricRegistry;

public interface ReporterBuilder<T extends Reporter> {

    /**
     * Configure reporters from {@link MetricsConfiguration}.
     * This should not overwrite any reporter property if there is no configuration found.
     * 
     * @param configuration Configure reporter from {@link MetricsConfiguration}
     * @return The {@link ReporterBuilder} instance
     */
    ReporterBuilder<T> configure(MetricsConfiguration configuration);

    T build(MetricRegistry metricRegistry, MetricFilter metricFilter)
            throws ReporterDisabledException, ReporterBuildException;

}
