/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.metrics.impl.metric;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricSet;
import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OperatingSystemMetricSet
implements MetricSet {
    private static final Logger logger = LoggerFactory.getLogger(OperatingSystemMetricSet.class);
    private final OperatingSystemMXBean mxBean;

    public OperatingSystemMetricSet() {
        this(ManagementFactory.getOperatingSystemMXBean());
    }

    public OperatingSystemMetricSet(OperatingSystemMXBean mxBean) {
        this.mxBean = mxBean;
    }

    public Map<String, Metric> getMetrics() {
        Gauge<Long> committedVirtualMemorySizeGauge;
        Gauge<Long> totalSwapSpaceSizeGauge;
        Gauge<Long> freeSwapSpaceSizeGauge;
        Gauge<Long> totalPhysicalMemorySizeGauge;
        Gauge<Long> freePhysicalMemorySizeGauge;
        Gauge<Double> systemCpuLoadGauge;
        Gauge<Double> processCpuLoadGauge;
        Gauge<Long> maxFileDescriptorCountGauge;
        HashMap<String, Object> gauges = new HashMap<String, Object>();
        double loadAverage = this.mxBean.getSystemLoadAverage();
        if (Double.compare(loadAverage, 0.0) >= 0) {
            gauges.put("system.load.average", new Gauge<Double>(){

                public Double getValue() {
                    return OperatingSystemMetricSet.this.mxBean.getSystemLoadAverage();
                }
            });
        } else if (logger.isDebugEnabled()) {
            logger.debug("System Load Average is not available as an Operating System Metric");
        }
        Gauge<Long> openFileDescriptorCountGauge = this.getLongGauge("getOpenFileDescriptorCount");
        if (openFileDescriptorCountGauge != null) {
            gauges.put("file.descriptor.open.count", openFileDescriptorCountGauge);
        }
        if ((maxFileDescriptorCountGauge = this.getLongGauge("getMaxFileDescriptorCount")) != null) {
            gauges.put("file.descriptor.max.count", maxFileDescriptorCountGauge);
        }
        if ((processCpuLoadGauge = this.getDoubleGauge("getProcessCpuLoad")) != null) {
            gauges.put("cpu.load.process", processCpuLoadGauge);
        }
        if ((systemCpuLoadGauge = this.getDoubleGauge("getSystemCpuLoad")) != null) {
            gauges.put("cpu.load.system", systemCpuLoadGauge);
        }
        if ((freePhysicalMemorySizeGauge = this.getLongGauge("getFreePhysicalMemorySize")) != null) {
            gauges.put("physical.memory.free.size", freePhysicalMemorySizeGauge);
        }
        if ((totalPhysicalMemorySizeGauge = this.getLongGauge("getTotalPhysicalMemorySize")) != null) {
            gauges.put("physical.memory.total.size", totalPhysicalMemorySizeGauge);
        }
        if ((freeSwapSpaceSizeGauge = this.getLongGauge("getFreeSwapSpaceSize")) != null) {
            gauges.put("swap.space.free.size", freeSwapSpaceSizeGauge);
        }
        if ((totalSwapSpaceSizeGauge = this.getLongGauge("getTotalSwapSpaceSize")) != null) {
            gauges.put("swap.space.total.size", totalSwapSpaceSizeGauge);
        }
        if ((committedVirtualMemorySizeGauge = this.getLongGauge("getCommittedVirtualMemorySize")) != null) {
            gauges.put("virtual.memory.committed.size", committedVirtualMemorySizeGauge);
        }
        return Collections.unmodifiableMap(gauges);
    }

    private Gauge<Long> getLongGauge(final String methodName) {
        Object value;
        block3: {
            value = null;
            try {
                value = this.invokeMethod(methodName);
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                if (!logger.isTraceEnabled()) break block3;
                logger.trace(String.format("Error when invoking %s", methodName), (Throwable)e);
            }
        }
        if (value != null) {
            return new Gauge<Long>(){

                public Long getValue() {
                    return OperatingSystemMetricSet.this.invokeLong(methodName);
                }
            };
        }
        return null;
    }

    private Gauge<Double> getDoubleGauge(final String methodName) {
        Object value;
        block3: {
            value = null;
            try {
                value = this.invokeMethod(methodName);
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                if (!logger.isTraceEnabled()) break block3;
                logger.trace(String.format("Error when invoking %s", methodName), (Throwable)e);
            }
        }
        if (value != null) {
            return new Gauge<Double>(){

                public Double getValue() {
                    return OperatingSystemMetricSet.this.invokeDouble(methodName);
                }
            };
        }
        return null;
    }

    private Object invokeMethod(String methodName) throws NoSuchMethodException, SecurityException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Method method = this.mxBean.getClass().getDeclaredMethod(methodName, new Class[0]);
        if (!Modifier.isPublic(method.getModifiers())) {
            method.setAccessible(true);
        }
        return method.invoke((Object)this.mxBean, new Object[0]);
    }

    private long invokeLong(String methodName) {
        try {
            return (Long)this.invokeMethod(methodName);
        }
        catch (NoSuchMethodException e) {
            return 0L;
        }
        catch (IllegalAccessException e) {
            return 0L;
        }
        catch (InvocationTargetException e) {
            return 0L;
        }
    }

    private double invokeDouble(String methodName) {
        try {
            return (Double)this.invokeMethod(methodName);
        }
        catch (NoSuchMethodException e) {
            return -1.0;
        }
        catch (IllegalAccessException e) {
            return -1.0;
        }
        catch (InvocationTargetException e) {
            return -1.0;
        }
    }
}

