/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.metrics.impl;

import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.MetricSet;
import com.codahale.metrics.jvm.BufferPoolMetricSet;
import com.codahale.metrics.jvm.GarbageCollectorMetricSet;
import com.codahale.metrics.jvm.MemoryUsageGaugeSet;
import com.codahale.metrics.jvm.ThreadStatesGaugeSet;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.metrics.common.MetricsConfiguration;
import org.wso2.carbon.metrics.impl.AbstractMetric;
import org.wso2.carbon.metrics.impl.CachedGaugeImpl;
import org.wso2.carbon.metrics.impl.CounterImpl;
import org.wso2.carbon.metrics.impl.GaugeImpl;
import org.wso2.carbon.metrics.impl.HistogramImpl;
import org.wso2.carbon.metrics.impl.MeterImpl;
import org.wso2.carbon.metrics.impl.MetricsLevelConfiguration;
import org.wso2.carbon.metrics.impl.TimerImpl;
import org.wso2.carbon.metrics.impl.metric.ClassLoadingGaugeSet;
import org.wso2.carbon.metrics.impl.metric.OperatingSystemMetricSet;
import org.wso2.carbon.metrics.impl.metric.collection.CounterCollection;
import org.wso2.carbon.metrics.impl.metric.collection.HistogramCollection;
import org.wso2.carbon.metrics.impl.metric.collection.MeterCollection;
import org.wso2.carbon.metrics.impl.reporter.ListeningReporter;
import org.wso2.carbon.metrics.impl.reporter.Reporter;
import org.wso2.carbon.metrics.impl.reporter.ScheduledReporter;
import org.wso2.carbon.metrics.impl.util.ReporterBuilder;
import org.wso2.carbon.metrics.impl.util.ReporterDisabledException;
import org.wso2.carbon.metrics.manager.Counter;
import org.wso2.carbon.metrics.manager.Gauge;
import org.wso2.carbon.metrics.manager.Histogram;
import org.wso2.carbon.metrics.manager.Level;
import org.wso2.carbon.metrics.manager.Meter;
import org.wso2.carbon.metrics.manager.Metric;
import org.wso2.carbon.metrics.manager.MetricService;
import org.wso2.carbon.metrics.manager.Timer;
import org.wso2.carbon.metrics.manager.exception.MetricNotFoundException;

public class MetricServiceImpl
implements MetricService {
    private static final Logger logger = LoggerFactory.getLogger(MetricServiceImpl.class);
    private final ConcurrentMap<String, MetricWrapper> metricsMap = new ConcurrentHashMap<String, MetricWrapper>();
    private final ConcurrentMap<String, Metric> metricsCollections = new ConcurrentHashMap<String, Metric>();
    private boolean enabled;
    private final MetricRegistry metricRegistry;
    private static final String SYSTEM_PROPERTY_METRICS_ENABLED = "metrics.enabled";
    private static final String SYSTEM_PROPERTY_METRICS_ROOT_LEVEL = "metrics.rootLevel";
    private static final String METRIC_AGGREGATE_ANNOTATION = "[+]";
    private static final String METRIC_AGGREGATE_ANNOTATION_REGEX = "\\[\\+\\]";
    private static final String ROOT_METRIC_NAME = "";
    private static final String METRIC_PATH_DELIMITER = ".";
    private final MetricsLevelConfiguration levelConfiguration;
    private final Set<Reporter> reporters = new HashSet<Reporter>();
    private final MetricFilter enabledMetricFilter = new EnabledMetricFilter();
    private static final Pattern METRIC_AGGREGATE_ANNOTATION_PATTERN = Pattern.compile("\\[\\+\\]");
    private final MetricBuilder<MeterImpl> METER_BUILDER = new MetricBuilder<MeterImpl>(){

        @Override
        public MeterImpl createMetric(String name, Level level) {
            return new MeterImpl(name, level, MetricServiceImpl.this.metricRegistry.meter(name));
        }

        @Override
        public boolean isInstance(AbstractMetric metric) {
            return MeterImpl.class.isInstance(metric);
        }
    };
    private final MetricBuilder<CounterImpl> COUNTER_BUILDER = new MetricBuilder<CounterImpl>(){

        @Override
        public CounterImpl createMetric(String name, Level level) {
            return new CounterImpl(name, level, MetricServiceImpl.this.metricRegistry.counter(name));
        }

        @Override
        public boolean isInstance(AbstractMetric metric) {
            return CounterImpl.class.isInstance(metric);
        }
    };
    private final MetricBuilder<TimerImpl> TIMER_BUILDER = new MetricBuilder<TimerImpl>(){

        @Override
        public TimerImpl createMetric(String name, Level level) {
            return new TimerImpl(name, level, MetricServiceImpl.this.metricRegistry.timer(name));
        }

        @Override
        public boolean isInstance(AbstractMetric metric) {
            return TimerImpl.class.isInstance(metric);
        }
    };
    private final MetricBuilder<HistogramImpl> HISTOGRAM_BUILDER = new MetricBuilder<HistogramImpl>(){

        @Override
        public HistogramImpl createMetric(String name, Level level) {
            return new HistogramImpl(name, level, MetricServiceImpl.this.metricRegistry.histogram(name));
        }

        @Override
        public boolean isInstance(AbstractMetric metric) {
            return HistogramImpl.class.isInstance(metric);
        }
    };

    private MetricServiceImpl(boolean enabled, Level rootLevel, MetricsLevelConfiguration levelConfiguration, Set<ReporterBuilder<? extends Reporter>> reporterBuilders) {
        Level level;
        String rootLevelProperty;
        this.levelConfiguration = levelConfiguration;
        String metricsEnabledProperty = System.getProperty(SYSTEM_PROPERTY_METRICS_ENABLED);
        if (metricsEnabledProperty != null && !metricsEnabledProperty.trim().isEmpty()) {
            enabled = Boolean.valueOf(metricsEnabledProperty);
        }
        if ((rootLevelProperty = System.getProperty(SYSTEM_PROPERTY_METRICS_ROOT_LEVEL)) != null && !rootLevelProperty.trim().isEmpty() && (level = Level.getLevel((String)rootLevelProperty)) != null) {
            rootLevel = level;
        }
        if (rootLevel != null) {
            levelConfiguration.setRootLevel(rootLevel);
        }
        this.metricRegistry = new MetricRegistry();
        for (ReporterBuilder<? extends Reporter> reporterBuilder : reporterBuilders) {
            try {
                this.reporters.add(reporterBuilder.build(this.metricRegistry, this.enabledMetricFilter));
            }
            catch (ReporterDisabledException reporterDisabledException) {
            }
            catch (Throwable e) {
                if (!logger.isWarnEnabled()) continue;
                logger.warn("Failed to build the reporter", e);
            }
        }
        this.setEnabled(enabled);
        this.registerJVMMetrics();
    }

    public void enable() {
        this.setEnabled(true);
    }

    public void disable() {
        this.setEnabled(false);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    private void setEnabled(boolean enabled) {
        boolean changed = this.enabled != enabled;
        this.enabled = enabled;
        if (changed) {
            this.notifyEnabledStatus();
            if (enabled) {
                this.startReporters();
            } else {
                this.stopReporters();
            }
        }
    }

    private void notifyEnabledStatus() {
        for (MetricWrapper metricWrapper : this.metricsMap.values()) {
            AbstractMetric metric = metricWrapper.metric;
            metric.setEnabled(this.isMetricEnabled(metricWrapper.name, metric.getLevel(), this.levelConfiguration.getLevel(metric.getName()), false));
        }
    }

    public Level getMetricLevel(String name) {
        if (!this.metricsMap.containsKey(name)) {
            throw new IllegalArgumentException("Invalid Metric Name");
        }
        return this.levelConfiguration.getLevel(name);
    }

    public void setMetricLevel(String name, Level level) {
        MetricWrapper metricWrapper = (MetricWrapper)this.metricsMap.get(name);
        if (metricWrapper == null) {
            throw new IllegalArgumentException("Invalid Metric Name");
        }
        Level currentLevel = this.levelConfiguration.getLevel(name);
        if (currentLevel == null || !currentLevel.equals((Object)level)) {
            this.levelConfiguration.setLevel(name, level);
            AbstractMetric metric = metricWrapper.metric;
            metric.setEnabled(this.isMetricEnabled(metricWrapper.name, metric.getLevel(), level, false));
            this.restartListeningReporters();
        }
    }

    public Level getRootLevel() {
        return this.levelConfiguration.getRootLevel();
    }

    public void setRootLevel(Level level) {
        boolean changed = !this.getRootLevel().equals((Object)level);
        this.levelConfiguration.setRootLevel(level);
        if (changed) {
            this.notifyEnabledStatus();
            this.restartListeningReporters();
        }
    }

    private boolean isMetricEnabled(String name, Level metricLevel, Level configLevel, boolean getFromCache) {
        MetricWrapper metricWrapper = (MetricWrapper)this.metricsMap.get(name);
        if (!getFromCache || metricWrapper.enabled == null) {
            metricWrapper.enabled = this.isMetricEnabledBasedOnHierarchyLevel(name, metricLevel, configLevel);
        }
        return metricWrapper.enabled;
    }

    private boolean isMetricEnabledBasedOnHierarchyLevel(String name, Level metricLevel, Level configLevel) {
        String parentName;
        if (configLevel != null) {
            return this.enabled && configLevel.intLevel() >= metricLevel.intLevel() && configLevel.intLevel() > Level.OFF.intLevel();
        }
        int index = name.lastIndexOf(METRIC_PATH_DELIMITER);
        if (index != -1) {
            parentName = name.substring(0, index);
            configLevel = this.levelConfiguration.getLevel(parentName);
        } else {
            parentName = ROOT_METRIC_NAME;
            configLevel = this.levelConfiguration.getRootLevel();
        }
        return this.isMetricEnabledBasedOnHierarchyLevel(parentName, metricLevel, configLevel);
    }

    private <T extends AbstractMetric> T getMetric(String name, MetricBuilder<T> metricBuilder) throws MetricNotFoundException {
        MetricWrapper metricWrapper = (MetricWrapper)this.metricsMap.get(name);
        if (metricWrapper != null && metricWrapper.metric != null) {
            AbstractMetric metric = metricWrapper.metric;
            if (metricBuilder.isInstance(metric)) {
                return (T)metric;
            }
            throw new IllegalArgumentException("The name \"" + name + "\" is used for a different type of metric");
        }
        throw new MetricNotFoundException("Metric \"" + name + "\" is not found");
    }

    private <T extends AbstractMetric> T getOrCreateMetric(String name, Level level, MetricBuilder<T> metricBuilder) {
        if (this.isAnnotated(name)) {
            throw new IllegalArgumentException(name + " invalid metric name (annotated)");
        }
        MetricWrapper metricWrapper = (MetricWrapper)this.metricsMap.get(name);
        if (metricWrapper != null && metricWrapper.metric != null) {
            AbstractMetric metric = metricWrapper.metric;
            if (metricBuilder.isInstance(metric)) {
                if (level.equals((Object)metricWrapper.level)) {
                    return (T)metric;
                }
                throw new IllegalArgumentException(name + " is already used with a different level");
            }
            throw new IllegalArgumentException(name + " is already used for a different type of metric");
        }
        boolean enabled = this.isMetricEnabledBasedOnHierarchyLevel(name, level, this.levelConfiguration.getLevel(name));
        metricWrapper = new MetricWrapper(name, level, enabled);
        this.metricsMap.put(name, metricWrapper);
        T newMetric = metricBuilder.createMetric(name, level);
        metricWrapper.metric = newMetric;
        ((AbstractMetric)newMetric).setEnabled(enabled);
        return newMetric;
    }

    private <T extends AbstractMetric> Metric getOrCreateMetricCollection(String annotatedName, Level[] levels, MetricBuilder<T> metricBuilder) throws MetricNotFoundException {
        Object metricCollection;
        Level level = null;
        if (levels != null && !this.isLevelsMatch(annotatedName, levels)) {
            throw new IllegalArgumentException("number of metric levels doesn't match the annotated name");
        }
        if (levels != null && levels.length > 0) {
            level = levels[levels.length - 1];
        }
        if ((metricCollection = (Metric)this.metricsCollections.get(annotatedName)) == null) {
            String name = annotatedName.replaceAll(METRIC_AGGREGATE_ANNOTATION_REGEX, ROOT_METRIC_NAME);
            T metric = level != null ? this.getOrCreateMetric(name, level, metricBuilder) : this.getMetric(name, metricBuilder);
            boolean annotated = this.isAnnotated(annotatedName);
            List<Counter> affected = this.getAffectedMetrics(annotatedName, levels, metricBuilder);
            if (annotated && metric instanceof Counter) {
                metricCollection = new CounterCollection((Counter)metric, affected);
                this.metricsCollections.put(annotatedName, (Metric)metricCollection);
            } else if (annotated && metric instanceof Histogram) {
                metricCollection = new HistogramCollection((Histogram)metric, affected);
                this.metricsCollections.put(annotatedName, (Metric)metricCollection);
            } else if (annotated && metric instanceof Meter) {
                metricCollection = new MeterCollection((Meter)metric, affected);
                this.metricsCollections.put(annotatedName, (Metric)metricCollection);
            } else {
                metricCollection = metric;
            }
        }
        return metricCollection;
    }

    private boolean isAnnotated(String annotatedName) {
        return annotatedName.contains(METRIC_AGGREGATE_ANNOTATION);
    }

    private boolean isLevelsMatch(String annotatedName, Level[] levels) {
        Matcher m = METRIC_AGGREGATE_ANNOTATION_PATTERN.matcher(annotatedName);
        int affectedMetrics = 0;
        while (m.find()) {
            ++affectedMetrics;
        }
        return levels.length == affectedMetrics + 1;
    }

    private <T extends AbstractMetric> List<?> getAffectedMetrics(String annotatedName, Level[] levels, MetricBuilder<T> metricBuilder) throws MetricNotFoundException {
        boolean getOrCreate = levels != null && levels.length > 0;
        int levelIndex = 0;
        int index = annotatedName.lastIndexOf(METRIC_PATH_DELIMITER);
        String annotatedPath = annotatedName.substring(0, index);
        String statName = annotatedName.substring(index + 1);
        ArrayList<T> affected = new ArrayList<T>();
        String[] chunks = annotatedPath.split("\\.");
        StringBuilder builder = new StringBuilder();
        int chunksLength = chunks.length;
        for (int i = 0; i < chunksLength - 1; ++i) {
            String chunk = chunks[i];
            if (builder.length() > 0) {
                builder.append('.');
            }
            builder.append(chunk);
            if (!chunk.contains(METRIC_AGGREGATE_ANNOTATION)) continue;
            String affectedName = builder.toString().replaceAll(METRIC_AGGREGATE_ANNOTATION_REGEX, ROOT_METRIC_NAME);
            String metricName = String.format("%s.%s", affectedName, statName);
            if (getOrCreate) {
                Level level = levels[levelIndex];
                affected.add(this.getOrCreateMetric(metricName, level, metricBuilder));
            } else {
                affected.add(this.getMetric(metricName, metricBuilder));
            }
            ++levelIndex;
        }
        return affected;
    }

    public Meter getMeter(String name) throws MetricNotFoundException {
        if (this.isAnnotated(name)) {
            return (Meter)this.getOrCreateMetricCollection(name, null, this.METER_BUILDER);
        }
        return this.getMetric(name, this.METER_BUILDER);
    }

    public boolean removeMetric(String name) {
        return this.metricRegistry.remove(name) && (this.metricsMap.remove(name) != null || this.metricsCollections.remove(name) != null);
    }

    public Meter meter(String name, Level ... levels) {
        if (levels.length == 1) {
            return this.getOrCreateMetric(name, levels[0], this.METER_BUILDER);
        }
        try {
            return (Meter)this.getOrCreateMetricCollection(name, levels, this.METER_BUILDER);
        }
        catch (MetricNotFoundException ignored) {
            return null;
        }
    }

    public Counter getCounter(String name) throws MetricNotFoundException {
        if (this.isAnnotated(name)) {
            return (Counter)this.getOrCreateMetricCollection(name, null, this.COUNTER_BUILDER);
        }
        return this.getMetric(name, this.COUNTER_BUILDER);
    }

    public Counter counter(String name, Level ... levels) {
        if (levels.length == 1) {
            return this.getOrCreateMetric(name, levels[0], this.COUNTER_BUILDER);
        }
        try {
            return (Counter)this.getOrCreateMetricCollection(name, levels, this.COUNTER_BUILDER);
        }
        catch (MetricNotFoundException ignored) {
            return null;
        }
    }

    public Timer timer(String name) throws MetricNotFoundException {
        return this.getMetric(name, this.TIMER_BUILDER);
    }

    public Timer timer(String name, Level level) {
        return this.getOrCreateMetric(name, level, this.TIMER_BUILDER);
    }

    public Histogram getHistogram(String name) throws MetricNotFoundException {
        if (this.isAnnotated(name)) {
            return (Histogram)this.getOrCreateMetricCollection(name, null, this.HISTOGRAM_BUILDER);
        }
        return this.getMetric(name, this.HISTOGRAM_BUILDER);
    }

    public Histogram histogram(String name, Level ... levels) {
        if (levels.length == 1) {
            return this.getOrCreateMetric(name, levels[0], this.HISTOGRAM_BUILDER);
        }
        try {
            return (Histogram)this.getOrCreateMetricCollection(name, levels, this.HISTOGRAM_BUILDER);
        }
        catch (MetricNotFoundException ignored) {
            return null;
        }
    }

    public <T> void gauge(String name, Level level, Gauge<T> gauge) {
        this.getOrCreateMetric(name, level, new GaugeBuilder<T>(gauge));
    }

    public <T> void cachedGauge(String name, Level level, long timeout, TimeUnit timeoutUnit, Gauge<T> gauge) {
        this.getOrCreateMetric(name, level, new CachedGaugeBuilder<T>(gauge, timeout, timeoutUnit));
    }

    public int getMetricsCount() {
        return this.metricsMap.size();
    }

    private void registerJVMMetrics() {
        this.registerAll(Level.INFO, "jvm.memory", (MetricSet)new MemoryUsageGaugeSet());
        this.registerAll(Level.INFO, "jvm.os", new OperatingSystemMetricSet());
        this.registerAll(Level.INFO, "jvm.class-loading", new ClassLoadingGaugeSet());
        this.registerAll(Level.DEBUG, "jvm.gc", (MetricSet)new GarbageCollectorMetricSet());
        this.registerAll(Level.DEBUG, "jvm.threads", (MetricSet)new ThreadStatesGaugeSet());
        this.registerAll(Level.TRACE, "jvm.buffers", (MetricSet)new BufferPoolMetricSet(ManagementFactory.getPlatformMBeanServer()));
    }

    private void registerAll(Level level, String prefix, MetricSet metrics) throws IllegalArgumentException {
        for (Map.Entry entry : metrics.getMetrics().entrySet()) {
            if (entry.getValue() instanceof MetricSet) {
                this.registerAll(level, MetricRegistry.name((String)prefix, (String[])new String[]{(String)entry.getKey()}), (MetricSet)entry.getValue());
                continue;
            }
            if (!this.filterJVMMetric((String)entry.getKey())) continue;
            String name = MetricRegistry.name((String)prefix, (String[])new String[]{(String)entry.getKey()});
            com.codahale.metrics.Metric metric = (com.codahale.metrics.Metric)entry.getValue();
            if (metric instanceof com.codahale.metrics.Gauge) {
                com.codahale.metrics.Gauge gauge = (com.codahale.metrics.Gauge)metric;
                this.gauge(name, level, new JVMGaugeWrapper(gauge));
                continue;
            }
            logger.warn(String.format("Unexpected Metric found. Name: %s, Class: %s", name, metric.getClass()));
        }
    }

    private boolean filterJVMMetric(String name) {
        return !"deadlocks".equals(name);
    }

    public void report() {
        for (Reporter reporter : this.reporters) {
            if (!(reporter instanceof ScheduledReporter)) continue;
            ((ScheduledReporter)reporter).report();
        }
    }

    private void startReporters() {
        for (Reporter reporter : this.reporters) {
            try {
                reporter.start();
            }
            catch (Throwable e) {
                logger.error("Error when starting the reporter", e);
            }
        }
    }

    private void stopReporters() {
        for (Reporter reporter : this.reporters) {
            try {
                reporter.stop();
            }
            catch (Throwable e) {
                logger.error("Error when stopping the reporter", e);
            }
        }
    }

    private void restartListeningReporters() {
        for (Reporter reporter : this.reporters) {
            if (!(reporter instanceof ListeningReporter)) continue;
            ListeningReporter listeningReporter = (ListeningReporter)reporter;
            listeningReporter.stop();
            listeningReporter.start();
        }
    }

    private class EnabledMetricFilter
    implements MetricFilter {
        private EnabledMetricFilter() {
        }

        public boolean matches(String name, com.codahale.metrics.Metric metric) {
            MetricWrapper metricWrapper = (MetricWrapper)MetricServiceImpl.this.metricsMap.get(name);
            if (metricWrapper != null) {
                return MetricServiceImpl.this.isMetricEnabled(metricWrapper.name, metricWrapper.level, MetricServiceImpl.this.levelConfiguration.getLevel(name), true);
            }
            return false;
        }
    }

    private static class JVMGaugeWrapper
    implements Gauge<Object> {
        private final com.codahale.metrics.Gauge<?> gauge;

        private JVMGaugeWrapper(com.codahale.metrics.Gauge<?> gauge) {
            this.gauge = gauge;
        }

        public Object getValue() {
            return this.gauge.getValue();
        }
    }

    private class CachedGaugeBuilder<T>
    implements MetricBuilder<CachedGaugeImpl<T>> {
        private final Gauge<T> gauge;
        private final long timeout;
        private final TimeUnit timeoutUnit;

        public CachedGaugeBuilder(Gauge<T> gauge, long timeout, TimeUnit timeoutUnit) {
            this.gauge = gauge;
            this.timeout = timeout;
            this.timeoutUnit = timeoutUnit;
        }

        @Override
        public CachedGaugeImpl<T> createMetric(String name, Level level) {
            CachedGaugeImpl<T> gaugeImpl = new CachedGaugeImpl<T>(name, level, this.timeout, this.timeoutUnit, this.gauge);
            MetricServiceImpl.this.metricRegistry.register(name, gaugeImpl);
            return gaugeImpl;
        }

        @Override
        public boolean isInstance(AbstractMetric metric) {
            return CachedGaugeImpl.class.isInstance(metric);
        }
    }

    private class GaugeBuilder<T>
    implements MetricBuilder<GaugeImpl<T>> {
        private final Gauge<T> gauge;

        public GaugeBuilder(Gauge<T> gauge) {
            this.gauge = gauge;
        }

        @Override
        public GaugeImpl<T> createMetric(String name, Level level) {
            GaugeImpl<T> gaugeImpl = new GaugeImpl<T>(name, level, this.gauge);
            MetricServiceImpl.this.metricRegistry.register(name, gaugeImpl);
            return gaugeImpl;
        }

        @Override
        public boolean isInstance(AbstractMetric metric) {
            return GaugeImpl.class.isInstance(metric);
        }
    }

    private static interface MetricBuilder<T extends AbstractMetric> {
        public T createMetric(String var1, Level var2);

        public boolean isInstance(AbstractMetric var1);
    }

    public static class Builder {
        private static final String ENABLED = "Enabled";
        private boolean enabled;
        private Level rootLevel;
        private Set<ReporterBuilder<? extends Reporter>> reporterBuilders = new HashSet<ReporterBuilder<? extends Reporter>>();

        public Builder setEnabled(boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public Builder setRootLevel(Level rootLevel) {
            this.rootLevel = rootLevel;
            return this;
        }

        public Builder addReporterBuilder(ReporterBuilder<? extends Reporter> reporterBuilder) {
            this.reporterBuilders.add(reporterBuilder);
            return this;
        }

        public Builder configure(MetricsConfiguration configuration) {
            this.enabled = Boolean.valueOf(configuration.getProperty(ENABLED));
            return this;
        }

        public MetricService build(MetricsLevelConfiguration levelConfiguration) {
            return new MetricServiceImpl(this.enabled, this.rootLevel, levelConfiguration, this.reporterBuilders);
        }
    }

    private static class MetricWrapper {
        private final Level level;
        private final String name;
        private Boolean enabled;
        private AbstractMetric metric;

        private MetricWrapper(String name, Level level, Boolean enabled) {
            this.name = name;
            this.level = level;
            this.enabled = enabled;
        }
    }
}

