/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.metrics.jdbc.core.reporter.impl;

import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.MetricRegistry;
import java.util.concurrent.TimeUnit;
import javax.sql.DataSource;
import org.wso2.carbon.metrics.core.reporter.ScheduledReporter;
import org.wso2.carbon.metrics.core.reporter.impl.AbstractReporter;
import org.wso2.carbon.metrics.jdbc.core.reporter.impl.ScheduledJdbcMetricsCleanupTask;

public class JdbcReporter
extends AbstractReporter
implements ScheduledReporter {
    private final MetricRegistry metricRegistry;
    private final MetricFilter metricFilter;
    private final String source;
    private final DataSource dataSource;
    private final long pollingPeriod;
    private final boolean runCleanupTask;
    private final int daysToKeep;
    private final long cleanupPeriod;
    private org.wso2.carbon.metrics.jdbc.reporter.JdbcReporter jdbcReporter;
    private ScheduledJdbcMetricsCleanupTask scheduledJdbcMetricsCleanupTask;

    public JdbcReporter(String name, MetricRegistry metricRegistry, MetricFilter metricFilter, String source, DataSource dataSource, long pollingPeriod, boolean runCleanupTask, int daysToKeep, long cleanupPeriod) {
        super(name);
        this.metricRegistry = metricRegistry;
        this.metricFilter = metricFilter;
        this.source = source;
        this.dataSource = dataSource;
        this.pollingPeriod = pollingPeriod;
        this.runCleanupTask = runCleanupTask;
        this.daysToKeep = daysToKeep;
        this.cleanupPeriod = cleanupPeriod;
    }

    public void report() {
        if (this.jdbcReporter != null) {
            this.jdbcReporter.report();
        }
    }

    public void startReporter() {
        this.jdbcReporter = org.wso2.carbon.metrics.jdbc.reporter.JdbcReporter.forRegistry((MetricRegistry)this.metricRegistry).filter(this.metricFilter).convertRatesTo(TimeUnit.SECONDS).convertDurationsTo(TimeUnit.MILLISECONDS).convertTimestampTo(TimeUnit.MILLISECONDS).build(this.source, this.dataSource);
        this.jdbcReporter.start(this.pollingPeriod, TimeUnit.SECONDS);
        if (this.runCleanupTask) {
            this.scheduledJdbcMetricsCleanupTask = new ScheduledJdbcMetricsCleanupTask(this.dataSource, this.daysToKeep);
            this.scheduledJdbcMetricsCleanupTask.start(this.cleanupPeriod, TimeUnit.SECONDS);
        }
    }

    public void stopReporter() {
        if (this.jdbcReporter != null) {
            this.jdbcReporter.stop();
            this.jdbcReporter = null;
        }
        if (this.scheduledJdbcMetricsCleanupTask != null) {
            this.scheduledJdbcMetricsCleanupTask.stop();
        }
    }
}

