/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.metrics.jdbc.reporter;

import com.codahale.metrics.Clock;
import com.codahale.metrics.Counter;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.ScheduledReporter;
import com.codahale.metrics.Snapshot;
import com.codahale.metrics.Timer;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Map;
import java.util.SortedMap;
import java.util.concurrent.TimeUnit;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcReporter
extends ScheduledReporter {
    private static final Logger logger = LoggerFactory.getLogger(JdbcReporter.class);
    private final Clock clock;
    private final String source;
    private final DataSource dataSource;
    private final TimeUnit timestampUnit;
    private static final String INSERT_GAUGE_QUERY = "INSERT INTO METRIC_GAUGE (SOURCE, TIMESTAMP, NAME, VALUE) VALUES (?,?,?,?)";
    private static final String INSERT_COUNTER_QUERY = "INSERT INTO METRIC_COUNTER (SOURCE, TIMESTAMP, NAME, COUNT) VALUES (?,?,?,?)";
    private static final String INSERT_METER_QUERY = "INSERT INTO METRIC_METER (SOURCE,TIMESTAMP,NAME,COUNT,MEAN_RATE,M1_RATE,M5_RATE,M15_RATE,RATE_UNIT) VALUES (?,?,?,?,?,?,?,?,?)";
    private static final String INSERT_HISTOGRAM_QUERY = "INSERT INTO METRIC_HISTOGRAM (SOURCE,TIMESTAMP,NAME,COUNT,MAX,MEAN,MIN,STDDEV,P50,P75,P95,P98,P99,P999) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
    private static final String INSERT_TIMER_QUERY = "INSERT INTO METRIC_TIMER (SOURCE,TIMESTAMP,NAME,COUNT,MAX,MEAN,MIN,STDDEV,P50,P75,P95,P98,P99,P999,MEAN_RATE,M1_RATE,M5_RATE,M15_RATE,RATE_UNIT,DURATION_UNIT) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";

    public static Builder forRegistry(MetricRegistry registry) {
        return new Builder(registry);
    }

    private JdbcReporter(MetricRegistry registry, String source, DataSource dataSource, TimeUnit rateUnit, TimeUnit durationUnit, TimeUnit timestampUnit, Clock clock, MetricFilter filter) {
        super(registry, "jdbc-reporter", filter, rateUnit, durationUnit);
        this.source = source;
        this.dataSource = dataSource;
        this.timestampUnit = timestampUnit;
        this.clock = clock;
        if (source == null || source.trim().isEmpty()) {
            throw new IllegalArgumentException("Source cannot be null or empty");
        }
        if (dataSource == null) {
            throw new IllegalArgumentException("Data source cannot be null");
        }
    }

    public void report(SortedMap<String, Gauge> gauges, SortedMap<String, Counter> counters, SortedMap<String, Histogram> histograms, SortedMap<String, Meter> meters, SortedMap<String, Timer> timers) {
        long timestamp = this.timestampUnit.convert(this.clock.getTime(), TimeUnit.MILLISECONDS);
        if (!gauges.isEmpty()) {
            this.reportGauges(timestamp, gauges);
        }
        if (!counters.isEmpty()) {
            this.reportCounters(timestamp, counters);
        }
        if (!histograms.isEmpty()) {
            this.reportHistograms(timestamp, histograms);
        }
        if (!meters.isEmpty()) {
            this.reportMeters(timestamp, meters);
        }
        if (!timers.isEmpty()) {
            this.reportTimers(timestamp, timers);
        }
    }

    protected String getRateUnit() {
        return super.getRateUnit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reportGauges(long timestamp, SortedMap<String, Gauge> gauges) {
        Connection connection = null;
        PreparedStatement ps = null;
        try {
            connection = this.dataSource.getConnection();
            connection.setAutoCommit(false);
            ps = connection.prepareStatement(INSERT_GAUGE_QUERY);
            for (Map.Entry<String, Gauge> entry : gauges.entrySet()) {
                String name = entry.getKey();
                Gauge gauge = entry.getValue();
                this.reportGauge(timestamp, ps, name, gauge);
                ps.addBatch();
            }
            ps.executeBatch();
            connection.commit();
            ps.close();
            ps = null;
            connection.close();
            connection = null;
            this.closeQuietly(connection, ps);
        }
        catch (SQLException e) {
            try {
                this.rollbackTransaction(connection);
                logger.error("Error when reporting gauges", (Throwable)e);
                this.closeQuietly(connection, ps);
            }
            catch (Throwable throwable) {
                this.closeQuietly(connection, ps);
                throw throwable;
            }
        }
    }

    private void reportGauge(long timestamp, PreparedStatement ps, String name, Gauge gauge) throws SQLException {
        ps.setString(1, this.source);
        ps.setLong(2, timestamp);
        ps.setString(3, name);
        ps.setObject(4, gauge.getValue());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reportCounters(long timestamp, SortedMap<String, Counter> counters) {
        Connection connection = null;
        PreparedStatement ps = null;
        try {
            connection = this.dataSource.getConnection();
            connection.setAutoCommit(false);
            ps = connection.prepareStatement(INSERT_COUNTER_QUERY);
            for (Map.Entry<String, Counter> entry : counters.entrySet()) {
                String name = entry.getKey();
                Counter counter = entry.getValue();
                this.reportCounter(timestamp, ps, name, counter);
                ps.addBatch();
            }
            ps.executeBatch();
            connection.commit();
            ps.close();
            ps = null;
            connection.close();
            connection = null;
            this.closeQuietly(connection, ps);
        }
        catch (SQLException e) {
            try {
                this.rollbackTransaction(connection);
                logger.error("Error when reporting counters", (Throwable)e);
                this.closeQuietly(connection, ps);
            }
            catch (Throwable throwable) {
                this.closeQuietly(connection, ps);
                throw throwable;
            }
        }
    }

    private void reportCounter(long timestamp, PreparedStatement ps, String name, Counter counter) throws SQLException {
        ps.setString(1, this.source);
        ps.setLong(2, timestamp);
        ps.setString(3, name);
        ps.setLong(4, counter.getCount());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reportHistograms(long timestamp, SortedMap<String, Histogram> histograms) {
        Connection connection = null;
        PreparedStatement ps = null;
        try {
            connection = this.dataSource.getConnection();
            connection.setAutoCommit(false);
            ps = connection.prepareStatement(INSERT_HISTOGRAM_QUERY);
            for (Map.Entry<String, Histogram> entry : histograms.entrySet()) {
                String name = entry.getKey();
                Histogram histogram = entry.getValue();
                this.reportHistogram(timestamp, ps, name, histogram);
                ps.addBatch();
            }
            ps.executeBatch();
            connection.commit();
            ps.close();
            ps = null;
            connection.close();
            connection = null;
            this.closeQuietly(connection, ps);
        }
        catch (SQLException e) {
            try {
                this.rollbackTransaction(connection);
                logger.error("Error when reporting histograms", (Throwable)e);
                this.closeQuietly(connection, ps);
            }
            catch (Throwable throwable) {
                this.closeQuietly(connection, ps);
                throw throwable;
            }
        }
    }

    private void reportHistogram(long timestamp, PreparedStatement ps, String name, Histogram histogram) throws SQLException {
        Snapshot snapshot = histogram.getSnapshot();
        ps.setString(1, this.source);
        ps.setLong(2, timestamp);
        ps.setString(3, name);
        ps.setLong(4, histogram.getCount());
        ps.setDouble(5, snapshot.getMax());
        ps.setDouble(6, snapshot.getMean());
        ps.setDouble(7, snapshot.getMin());
        ps.setDouble(8, snapshot.getStdDev());
        ps.setDouble(9, snapshot.getMedian());
        ps.setDouble(10, snapshot.get75thPercentile());
        ps.setDouble(11, snapshot.get95thPercentile());
        ps.setDouble(12, snapshot.get98thPercentile());
        ps.setDouble(13, snapshot.get99thPercentile());
        ps.setDouble(14, snapshot.get999thPercentile());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reportMeters(long timestamp, SortedMap<String, Meter> meters) {
        Connection connection = null;
        PreparedStatement ps = null;
        try {
            connection = this.dataSource.getConnection();
            connection.setAutoCommit(false);
            ps = connection.prepareStatement(INSERT_METER_QUERY);
            for (Map.Entry<String, Meter> entry : meters.entrySet()) {
                String name = entry.getKey();
                Meter meter = entry.getValue();
                this.reportMeter(timestamp, ps, name, meter);
                ps.addBatch();
            }
            ps.executeBatch();
            connection.commit();
            ps.close();
            ps = null;
            connection.close();
            connection = null;
            this.closeQuietly(connection, ps);
        }
        catch (SQLException e) {
            try {
                this.rollbackTransaction(connection);
                logger.error("Error when reporting meters", (Throwable)e);
                this.closeQuietly(connection, ps);
            }
            catch (Throwable throwable) {
                this.closeQuietly(connection, ps);
                throw throwable;
            }
        }
    }

    private void reportMeter(long timestamp, PreparedStatement ps, String name, Meter meter) throws SQLException {
        ps.setString(1, this.source);
        ps.setLong(2, timestamp);
        ps.setString(3, name);
        ps.setLong(4, meter.getCount());
        ps.setDouble(5, this.convertRate(meter.getMeanRate()));
        ps.setDouble(6, this.convertRate(meter.getOneMinuteRate()));
        ps.setDouble(7, this.convertRate(meter.getFiveMinuteRate()));
        ps.setDouble(8, this.convertRate(meter.getFifteenMinuteRate()));
        ps.setString(9, String.format("events/%s", this.getRateUnit()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reportTimers(long timestamp, SortedMap<String, Timer> timers) {
        Connection connection = null;
        PreparedStatement ps = null;
        try {
            connection = this.dataSource.getConnection();
            connection.setAutoCommit(false);
            ps = connection.prepareStatement(INSERT_TIMER_QUERY);
            for (Map.Entry<String, Timer> entry : timers.entrySet()) {
                String name = entry.getKey();
                Timer timer = entry.getValue();
                this.reportTimer(timestamp, ps, name, timer);
                ps.addBatch();
            }
            ps.executeBatch();
            connection.commit();
            ps.close();
            ps = null;
            connection.close();
            connection = null;
            this.closeQuietly(connection, ps);
        }
        catch (SQLException e) {
            try {
                this.rollbackTransaction(connection);
                logger.error("Error when reporting timers", (Throwable)e);
                this.closeQuietly(connection, ps);
            }
            catch (Throwable throwable) {
                this.closeQuietly(connection, ps);
                throw throwable;
            }
        }
    }

    private void reportTimer(long timestamp, PreparedStatement ps, String name, Timer timer) throws SQLException {
        Snapshot snapshot = timer.getSnapshot();
        ps.setString(1, this.source);
        ps.setLong(2, timestamp);
        ps.setString(3, name);
        ps.setLong(4, timer.getCount());
        ps.setDouble(5, this.convertDuration(snapshot.getMax()));
        if (Double.isNaN(snapshot.getMean())) {
            logger.warn("The mean value become NaN. Hence setting it as 0.0");
            ps.setDouble(6, this.convertDuration(0.0));
        } else {
            ps.setDouble(6, this.convertDuration(snapshot.getMean()));
        }
        ps.setDouble(7, this.convertDuration(snapshot.getMin()));
        ps.setDouble(8, this.convertDuration(snapshot.getStdDev()));
        ps.setDouble(9, this.convertDuration(snapshot.getMedian()));
        ps.setDouble(10, this.convertDuration(snapshot.get75thPercentile()));
        ps.setDouble(11, this.convertDuration(snapshot.get95thPercentile()));
        ps.setDouble(12, this.convertDuration(snapshot.get98thPercentile()));
        ps.setDouble(13, this.convertDuration(snapshot.get99thPercentile()));
        ps.setDouble(14, this.convertDuration(snapshot.get999thPercentile()));
        ps.setDouble(15, this.convertRate(timer.getMeanRate()));
        ps.setDouble(16, this.convertRate(timer.getOneMinuteRate()));
        ps.setDouble(17, this.convertRate(timer.getFiveMinuteRate()));
        ps.setDouble(18, this.convertRate(timer.getFifteenMinuteRate()));
        ps.setString(19, String.format("calls/%s", this.getRateUnit()));
        ps.setString(20, this.getDurationUnit());
    }

    private void rollbackTransaction(Connection connection) {
        block3: {
            if (connection != null) {
                try {
                    connection.rollback();
                }
                catch (SQLException e) {
                    if (!logger.isWarnEnabled()) break block3;
                    logger.warn("Error when rolling back the transaction", (Throwable)e);
                }
            }
        }
    }

    private void closeQuietly(Connection connection, PreparedStatement ps) {
        if (ps != null) {
            try {
                ps.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        if (connection != null) {
            try {
                connection.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    public static class Builder {
        private final MetricRegistry registry;
        private TimeUnit rateUnit;
        private TimeUnit durationUnit;
        private Clock clock;
        private MetricFilter filter;
        private TimeUnit timestampUnit;

        private Builder(MetricRegistry registry) {
            this.registry = registry;
            this.rateUnit = TimeUnit.SECONDS;
            this.durationUnit = TimeUnit.MILLISECONDS;
            this.clock = Clock.defaultClock();
            this.filter = MetricFilter.ALL;
            this.timestampUnit = TimeUnit.SECONDS;
        }

        public Builder convertRatesTo(TimeUnit rateUnit) {
            this.rateUnit = rateUnit;
            return this;
        }

        public Builder convertDurationsTo(TimeUnit durationUnit) {
            this.durationUnit = durationUnit;
            return this;
        }

        public Builder withClock(Clock clock) {
            this.clock = clock;
            return this;
        }

        public Builder filter(MetricFilter filter) {
            this.filter = filter;
            return this;
        }

        public Builder convertTimestampTo(TimeUnit timestampUnit) {
            this.timestampUnit = timestampUnit;
            return this;
        }

        public JdbcReporter build(String source, DataSource dataSource) {
            return new JdbcReporter(this.registry, source, dataSource, this.rateUnit, this.durationUnit, this.timestampUnit, this.clock, this.filter);
        }
    }
}

