/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.metrics.manager.internal;

import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.metrics.manager.MetricManager;
import org.wso2.carbon.metrics.manager.MetricService;
import org.wso2.carbon.metrics.manager.ServiceReferenceHolder;

@Component(name="org.wso2.carbon.metrics.manager.internal.MetricManagerComponent", immediate=true)
public class MetricManagerComponent {
    private static final Logger log = LoggerFactory.getLogger(MetricManagerComponent.class);
    private ServiceReferenceHolder serviceReferenceHolder = ServiceReferenceHolder.getInstance();

    @Activate
    protected void activate(ComponentContext componentContext) {
        if (log.isDebugEnabled()) {
            log.debug("Metrics manager component activated");
        }
        MetricManager.registerMXBean();
    }

    @Deactivate
    protected void deactivate(ComponentContext componentContext) {
        if (log.isDebugEnabled()) {
            log.debug("Deactivating Metrics manager component");
        }
        MetricManager.unregisterMXBean();
    }

    @Reference(name="metric.service", service=MetricService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetMetricService")
    protected void setMetricService(MetricService metricService) {
        this.serviceReferenceHolder.setMetricService(metricService);
    }

    protected void unsetMetricService(MetricService metricService) {
        this.serviceReferenceHolder.setMetricService(null);
    }
}

