/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.metrics.sample.consumer.internal;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.metrics.core.task.ScheduledTask;
import org.wso2.carbon.metrics.sample.service.RandomNumberService;

@Component(name="org.wso2.carbon.metrics.sample.consumer.internal.ServiceComponent", immediate=true)
public class ServiceComponent {
    private static final Logger logger = LoggerFactory.getLogger(ServiceComponent.class);
    private RandomNumberService randomNumberService;
    private ExecutorService executorService;
    private ScheduledTask getRandomNumbersTask;
    private ScheduledTask setRandomNumberOriginAndBoundTask;

    @Activate
    protected void activate(BundleContext bundleContext) {
        logger.info("Service Component is activated");
        this.executorService = Executors.newCachedThreadPool();
        this.getRandomNumbersTask = new ScheduledTask("Get-Random-Numbers"){
            private Future<?> future;

            public void run() {
                if (this.future != null && !this.future.isDone() && logger.isDebugEnabled()) {
                    logger.debug("Previous task is not done");
                }
                this.future = ServiceComponent.this.executorService.submit(() -> ServiceComponent.this.randomNumberService.getRandomNumbers());
            }
        };
        this.getRandomNumbersTask.start(1L, TimeUnit.SECONDS);
        this.setRandomNumberOriginAndBoundTask = new ScheduledTask("Set-Random-Number-Origin-And-Bound"){
            private Future<?> future;

            public void run() {
                if (this.future != null && !this.future.isDone() && logger.isDebugEnabled()) {
                    logger.debug("Previous task is not done");
                }
                this.future = ServiceComponent.this.executorService.submit(() -> ServiceComponent.this.randomNumberService.setRandomNumberOriginAndBound());
            }
        };
        this.setRandomNumberOriginAndBoundTask.start(5L, TimeUnit.SECONDS);
    }

    @Deactivate
    protected void deactivate() {
        logger.info("Service Component is deactivated");
        this.getRandomNumbersTask.stop();
        this.setRandomNumberOriginAndBoundTask.stop();
        this.executorService.shutdownNow();
    }

    @Reference(name="random.number.service", service=RandomNumberService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetRandomNumberService")
    protected void setRandomNumberService(RandomNumberService randomNumberService) {
        this.randomNumberService = randomNumberService;
    }

    protected void unsetRandomNumberService(RandomNumberService randomNumberService) {
    }
}

