/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.metrics.sample.service.internal;

import java.util.Random;
import org.wso2.carbon.metrics.core.Counter;
import org.wso2.carbon.metrics.core.Histogram;
import org.wso2.carbon.metrics.core.Level;
import org.wso2.carbon.metrics.core.Meter;
import org.wso2.carbon.metrics.core.MetricService;
import org.wso2.carbon.metrics.core.Timer;
import org.wso2.carbon.metrics.sample.service.RandomNumberService;
import org.wso2.carbon.metrics.sample.service.internal.DataHolder;

public class RandomNumberServiceImpl
implements RandomNumberService {
    private final Random random = new Random();
    private final MetricService metricService;
    private final Counter counter;
    private final Meter meter;
    private final Timer timer;
    private final Histogram histogram;
    private int randomNumberOrigin;
    private int randomNumberBound;

    public RandomNumberServiceImpl() {
        this.initialize();
        this.metricService = DataHolder.getInstance().getMetricService();
        this.metricService.gauge(MetricService.name(RandomNumberService.class, (String[])new String[]{"random", "number", "origin"}), Level.INFO, () -> this.randomNumberOrigin);
        this.metricService.gauge(MetricService.name(RandomNumberService.class, (String[])new String[]{"random", "number", "bound"}), Level.INFO, () -> this.randomNumberBound);
        this.counter = this.metricService.counter(MetricService.name(RandomNumberService.class, (String[])new String[]{"sleep", "concurrent", "count"}), Level.INFO, new Level[0]);
        this.meter = this.metricService.meter(MetricService.name(RandomNumberService.class, (String[])new String[]{"sleep", "invocations"}), Level.INFO, new Level[0]);
        this.timer = this.metricService.timer(MetricService.name(RandomNumberService.class, (String[])new String[]{"random", "numbers", "generate", "time"}), Level.INFO);
        this.histogram = this.metricService.histogram(MetricService.name(RandomNumberService.class, (String[])new String[]{"random", "numbers", "size"}), Level.INFO, new Level[0]);
    }

    private void initialize() {
        this.randomNumberOrigin = this.random.nextInt(1000001);
        this.randomNumberBound = this.randomNumberOrigin + this.random.nextInt(1000001);
    }

    @Override
    public void setRandomNumberOriginAndBound() {
        this.counter.inc();
        this.meter.mark();
        try {
            this.initialize();
            Thread.sleep(this.random.nextInt(20001));
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            this.counter.dec();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int[] getRandomNumbers() {
        Timer.Context context = this.timer.start();
        try {
            int[] numbers = this.random.ints(this.random.nextInt(1000001), this.randomNumberOrigin, this.randomNumberBound).toArray();
            this.histogram.update(numbers.length);
            int[] nArray = numbers;
            return nArray;
        }
        finally {
            context.stop();
        }
    }
}

