/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.metrics.sample.service.internal;

import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.metrics.core.MetricManagementService;
import org.wso2.carbon.metrics.core.MetricService;
import org.wso2.carbon.metrics.sample.service.RandomNumberService;
import org.wso2.carbon.metrics.sample.service.internal.DataHolder;
import org.wso2.carbon.metrics.sample.service.internal.RandomNumberServiceImpl;

@Component(name="org.wso2.carbon.metrics.sample.service.internal.ServiceComponent", immediate=true)
public class ServiceComponent {
    private static final Logger logger = LoggerFactory.getLogger(ServiceComponent.class);
    private ServiceRegistration serviceRegistration;

    @Activate
    protected void activate(BundleContext bundleContext) {
        logger.info("Service Component is activated");
        this.serviceRegistration = bundleContext.registerService(RandomNumberService.class, (Object)new RandomNumberServiceImpl(), null);
    }

    @Deactivate
    protected void deactivate() {
        logger.info("Service Component is deactivated");
        this.serviceRegistration.unregister();
    }

    @Reference(name="carbon.metrics.service", service=MetricService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetMetricService")
    protected void setMetricService(MetricService metricService) {
        DataHolder.getInstance().setMetricService(metricService);
    }

    protected void unsetMetricService(MetricService metricService) {
        DataHolder.getInstance().setMetricService(null);
    }

    @Reference(name="carbon.metrics.management.service", service=MetricManagementService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetMetricManagementService")
    protected void setMetricManagementService(MetricManagementService metricManagementService) {
        DataHolder.getInstance().setMetricManagementService(metricManagementService);
    }

    protected void unsetMetricManagementService(MetricManagementService metricManagementService) {
        DataHolder.getInstance().setMetricManagementService(null);
    }
}

