/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.metrics.view.ui;

import java.rmi.RemoteException;
import org.apache.axis2.AxisFault;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ConfigurationContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.metrics.data.common.Metric;
import org.wso2.carbon.metrics.data.common.MetricList;
import org.wso2.carbon.metrics.data.service.stub.MetricsDataServiceStub;
import org.wso2.carbon.metrics.view.ui.MetricDataWrapper;
import org.wso2.carbon.metrics.view.ui.MetricHierarchyDataWrapper;

public class MetricsViewClient {
    private static final Logger logger = LoggerFactory.getLogger(MetricsViewClient.class);
    public MetricsDataServiceStub stub;

    public MetricsViewClient(String cookie, String backendServerURL, ConfigurationContext configCtx) throws AxisFault {
        if (cookie == null) {
            throw new IllegalStateException("Admin Service Cookie is not available");
        }
        String serviceURL = backendServerURL + "MetricsDataService";
        this.stub = new MetricsDataServiceStub(configCtx, serviceURL);
        ServiceClient client = this.stub._getServiceClient();
        Options option = client.getOptions();
        option.setManageSession(true);
        option.setProperty("Cookie", (Object)cookie);
    }

    public String[] getAllSources() throws RemoteException {
        try {
            return this.stub.getAllSources();
        }
        catch (RemoteException e) {
            String msg = "Error occurred while accessing Metrics Data Service. Backend service may be unavailable";
            logger.error(msg, (Throwable)e);
            throw e;
        }
    }

    public MetricHierarchyDataWrapper getHierarchy(String source, String path) throws RemoteException {
        try {
            return new MetricHierarchyDataWrapper(this.stub.getHierarchy(source, path));
        }
        catch (RemoteException e) {
            String msg = "Error occurred while accessing Metrics Data Service. Backend service may be unavailable";
            logger.error(msg, (Throwable)e);
            throw e;
        }
    }

    public MetricDataWrapper findLastMetrics(MetricList metrics, String source, String from) throws RemoteException {
        try {
            return new MetricDataWrapper(this.stub.findLastMetrics(this.convert(metrics), source, from));
        }
        catch (RemoteException e) {
            String msg = "Error occurred while accessing Metrics Data Service. Backend service may be unavailable";
            logger.error(msg, (Throwable)e);
            throw e;
        }
    }

    public MetricDataWrapper findMetricsByTimePeriod(MetricList metrics, String source, long from, long to) throws RemoteException {
        try {
            return new MetricDataWrapper(this.stub.findMetricsByTimePeriod(this.convert(metrics), source, from, to));
        }
        catch (RemoteException e) {
            String msg = "Error occurred while accessing Metrics Data Service. Backend service may be unavailable";
            logger.error(msg, (Throwable)e);
            throw e;
        }
    }

    private org.wso2.carbon.metrics.data.service.stub.MetricList convert(MetricList list) {
        org.wso2.carbon.metrics.data.service.stub.MetricList xsdMetricList = new org.wso2.carbon.metrics.data.service.stub.MetricList();
        Metric[] metrics = list.getMetric();
        org.wso2.carbon.metrics.data.service.stub.Metric[] xsdMetrics = new org.wso2.carbon.metrics.data.service.stub.Metric[metrics.length];
        xsdMetricList.setMetric(xsdMetrics);
        for (int i = 0; i < metrics.length; ++i) {
            org.wso2.carbon.metrics.data.service.stub.Metric xsdMetric;
            Metric metric = metrics[i];
            xsdMetrics[i] = xsdMetric = new org.wso2.carbon.metrics.data.service.stub.Metric();
            xsdMetric.setAttr(metric.getAttr());
            xsdMetric.setDisplayName(metric.getDisplayName());
            xsdMetric.setFormat(metric.getFormat());
            xsdMetric.setName(metric.getName());
            xsdMetric.setType(metric.getType());
        }
        return xsdMetricList;
    }
}

