/*
 * Copyright (c) 2015, WSO2 Inc. (http://www.wso2.org) All Rights Reserved.
 *
 * WSO2 Inc. licenses this file to you under the Apache License,
 * Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.wso2.carbon.ml.rest.api.model;

import java.util.List;

/**
 * Represent a Project in ML.
 */
public class MLProjectBean {

    private long id;
    private String name;
    private String datasetName;
    private long datasetId;
    private String datasetStatus;
    private String description;
    private String createdTime;
    private List<MLAnalysisBean> analyses;

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getCreatedTime() {
        return createdTime;
    }

    public void setCreatedTime(String createdTime) {
        this.createdTime = createdTime;
    }

    public long getId() {
        return id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public String getDatasetName() {
        return datasetName;
    }

    public void setDatasetName(String datasetName) {
        this.datasetName = datasetName;
    }

    public long getDatasetId() {
        return datasetId;
    }

    public void setDatasetId(long datasetId) {
        this.datasetId = datasetId;
    }

    public String getDatasetStatus() {
        return datasetStatus;
    }

    public void setDatasetStatus(String datasetStatus) {
        this.datasetStatus = datasetStatus;
    }

    public List<MLAnalysisBean> getAnalyses() {
        return analyses;
    }

    public void setAnalyses(List<MLAnalysisBean> analyses) {
        this.analyses = analyses;
    }

}
