/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.ml.siddhi.extension;

import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.ObjectUtils;
import org.wso2.carbon.ml.core.exceptions.MLInputAdapterException;
import org.wso2.carbon.ml.core.exceptions.MLModelHandlerException;
import org.wso2.carbon.ml.core.factories.AlgorithmType;
import org.wso2.carbon.ml.core.h2o.POJOPredictor;
import org.wso2.carbon.ml.siddhi.extension.ModelHandler;
import org.wso2.siddhi.core.config.ExecutionPlanContext;
import org.wso2.siddhi.core.event.ComplexEvent;
import org.wso2.siddhi.core.event.ComplexEventChunk;
import org.wso2.siddhi.core.event.stream.StreamEvent;
import org.wso2.siddhi.core.event.stream.StreamEventCloner;
import org.wso2.siddhi.core.event.stream.populater.ComplexEventPopulater;
import org.wso2.siddhi.core.exception.ExecutionPlanCreationException;
import org.wso2.siddhi.core.exception.ExecutionPlanRuntimeException;
import org.wso2.siddhi.core.executor.ConstantExpressionExecutor;
import org.wso2.siddhi.core.executor.ExpressionExecutor;
import org.wso2.siddhi.core.executor.VariableExpressionExecutor;
import org.wso2.siddhi.core.query.processor.Processor;
import org.wso2.siddhi.core.query.processor.stream.StreamProcessor;
import org.wso2.siddhi.query.api.definition.AbstractDefinition;
import org.wso2.siddhi.query.api.definition.Attribute;
import org.wso2.siddhi.query.api.exception.ExecutionPlanValidationException;

public class PredictStreamProcessor
extends StreamProcessor {
    private ModelHandler[] modelHandlers;
    private String[] modelStorageLocations;
    private String responseVariable;
    private static final String anomalyPrediction = "prediction";
    private String algorithmClass;
    private String outputType;
    private double percentileValue;
    private boolean isAnomalyDetection;
    private boolean attributeSelectionAvailable;
    private Map<Integer, int[]> attributeIndexMap;
    private POJOPredictor[] pojoPredictor;
    private boolean deeplearningWithoutH2O;

    protected void process(ComplexEventChunk<StreamEvent> streamEventChunk, Processor nextProcessor, StreamEventCloner streamEventCloner, ComplexEventPopulater complexEventPopulater) {
        while (streamEventChunk.hasNext()) {
            StreamEvent event = (StreamEvent)streamEventChunk.next();
            String[] featureValues = new String[this.attributeIndexMap.size()];
            for (Map.Entry<Integer, int[]> entry : this.attributeIndexMap.entrySet()) {
                int featureIndex = entry.getKey();
                int[] attributeIndexArray = entry.getValue();
                Object dataValue = null;
                switch (attributeIndexArray[2]) {
                    case 0: {
                        dataValue = event.getBeforeWindowData()[attributeIndexArray[3]];
                        break;
                    }
                    case 2: {
                        dataValue = event.getOutputData()[attributeIndexArray[3]];
                    }
                }
                featureValues[featureIndex] = String.valueOf(dataValue);
            }
            if (featureValues == null) continue;
            try {
                int i;
                Object[] predictionResults = new Object[this.modelHandlers.length];
                Object predictionResult = null;
                if (AlgorithmType.CLASSIFICATION.getValue().equals(this.algorithmClass)) {
                    for (i = 0; i < this.modelHandlers.length; ++i) {
                        predictionResults[i] = this.modelHandlers[i].predict(featureValues, this.outputType);
                    }
                    predictionResult = ObjectUtils.mode((Object[])predictionResults);
                } else if (AlgorithmType.NUMERICAL_PREDICTION.getValue().equals(this.algorithmClass)) {
                    double sum = 0.0;
                    for (int i2 = 0; i2 < this.modelHandlers.length; ++i2) {
                        sum += Double.parseDouble(this.modelHandlers[i2].predict(featureValues, this.outputType).toString());
                    }
                    predictionResult = sum / (double)this.modelHandlers.length;
                } else if (AlgorithmType.ANOMALY_DETECTION.getValue().equals(this.algorithmClass)) {
                    for (i = 0; i < this.modelHandlers.length; ++i) {
                        predictionResults[i] = this.modelHandlers[i].predict(featureValues, this.outputType, this.percentileValue);
                    }
                    predictionResult = ObjectUtils.mode((Object[])predictionResults);
                } else if (AlgorithmType.DEEPLEARNING.getValue().equals(this.algorithmClass)) {
                    if (this.deeplearningWithoutH2O) {
                        for (i = 0; i < this.modelHandlers.length; ++i) {
                            predictionResults[i] = this.modelHandlers[i].predict(featureValues, this.outputType, this.pojoPredictor[i]);
                        }
                        predictionResult = ObjectUtils.mode((Object[])predictionResults);
                    } else {
                        for (i = 0; i < this.modelHandlers.length; ++i) {
                            predictionResults[i] = this.modelHandlers[i].predict(featureValues, this.outputType);
                        }
                        predictionResult = ObjectUtils.mode((Object[])predictionResults);
                    }
                } else {
                    String msg = String.format("Error while predicting. Prediction is not supported for the algorithm class %s. ", this.algorithmClass);
                    throw new ExecutionPlanRuntimeException(msg);
                }
                Object[] output = new Object[]{predictionResult};
                complexEventPopulater.populateComplexEvent((ComplexEvent)event, output);
            }
            catch (Exception e) {
                log.error((Object)"Error while predicting", (Throwable)e);
                throw new ExecutionPlanRuntimeException("Error while predicting", (Throwable)e);
            }
        }
        nextProcessor.process(streamEventChunk);
    }

    protected List<Attribute> init(AbstractDefinition inputDefinition, ExpressionExecutor[] attributeExpressionExecutors, ExecutionPlanContext executionPlanContext) {
        if (attributeExpressionExecutors.length < 2) {
            throw new ExecutionPlanValidationException("ML model storage locations and response variable type have not been defined as the first two parameters");
        }
        this.attributeSelectionAvailable = attributeExpressionExecutors.length != 2;
        if (!(attributeExpressionExecutors[0] instanceof ConstantExpressionExecutor)) {
            throw new ExecutionPlanValidationException("ML model storage-location has not been defined as the first parameter");
        }
        Object constantObj = ((ConstantExpressionExecutor)attributeExpressionExecutors[0]).getValue();
        String allPaths = (String)constantObj;
        this.modelStorageLocations = allPaths.split(",");
        if (!(attributeExpressionExecutors[1] instanceof ConstantExpressionExecutor)) {
            throw new ExecutionPlanValidationException("Response variable type has not been defined as the second parameter");
        }
        Object constantObj2 = ((ConstantExpressionExecutor)attributeExpressionExecutors[1]).getValue();
        this.outputType = (String)constantObj2;
        Attribute.Type outputDatatype = this.getOutputAttributeType(this.outputType);
        this.modelHandlers = new ModelHandler[this.modelStorageLocations.length];
        for (int i = 0; i < this.modelStorageLocations.length; ++i) {
            try {
                this.modelHandlers[i] = new ModelHandler(this.modelStorageLocations[i]);
                continue;
            }
            catch (ClassNotFoundException e) {
                this.logError(i, e);
                continue;
            }
            catch (URISyntaxException e) {
                this.logError(i, e);
                continue;
            }
            catch (MLInputAdapterException e) {
                this.logError(i, (Exception)((Object)e));
                continue;
            }
            catch (IOException e) {
                this.logError(i, e);
            }
        }
        HashSet<String> algorithmClasses = new HashSet<String>();
        for (int i = 0; i < this.modelHandlers.length; ++i) {
            algorithmClasses.add(this.modelHandlers[i].getAlgorithmClass());
        }
        if (algorithmClasses.size() > 1) {
            throw new ExecutionPlanRuntimeException("Algorithm classes are not equal");
        }
        this.algorithmClass = this.modelHandlers[0].getAlgorithmClass();
        HashSet<Map<String, Integer>> features = new HashSet<Map<String, Integer>>();
        for (int i = 0; i < this.modelHandlers.length; ++i) {
            features.add(this.modelHandlers[i].getFeatures());
        }
        if (features.size() > 1) {
            throw new ExecutionPlanRuntimeException("Features in models are not equal");
        }
        if (AlgorithmType.ANOMALY_DETECTION.getValue().equals(this.algorithmClass)) {
            this.isAnomalyDetection = true;
        }
        if (!this.isAnomalyDetection) {
            HashSet<String> responseVariables = new HashSet<String>();
            for (int i = 0; i < this.modelStorageLocations.length; ++i) {
                responseVariables.add(this.modelHandlers[i].getResponseVariable());
            }
            if (responseVariables.size() > 1) {
                throw new ExecutionPlanCreationException("Response variables of models are not equal");
            }
        } else {
            this.attributeSelectionAvailable = attributeExpressionExecutors.length != 3;
            if (!(attributeExpressionExecutors[2] instanceof ConstantExpressionExecutor)) {
                throw new ExecutionPlanValidationException("percentile value has not been defined as the third parameter");
            }
            Object constantObj3 = ((ConstantExpressionExecutor)attributeExpressionExecutors[2]).getValue();
            this.percentileValue = (Double)constantObj3;
            return Arrays.asList(new Attribute(anomalyPrediction, outputDatatype));
        }
        this.responseVariable = this.modelHandlers[0].getResponseVariable();
        if (AlgorithmType.DEEPLEARNING.getValue().equals(this.algorithmClass)) {
            if (this.modelHandlers[0].getMlModel().getModel() != null) {
                this.deeplearningWithoutH2O = false;
            } else {
                this.deeplearningWithoutH2O = true;
                this.pojoPredictor = new POJOPredictor[this.modelHandlers.length];
                for (int i = 0; i < this.modelHandlers.length; ++i) {
                    try {
                        this.pojoPredictor[i] = new POJOPredictor(this.modelHandlers[i].getMlModel(), this.modelStorageLocations[i]);
                        continue;
                    }
                    catch (MLModelHandlerException e) {
                        throw new ExecutionPlanRuntimeException("Failed to initialize the POJO predictor of the model " + this.modelStorageLocations[i], (Throwable)e);
                    }
                }
            }
        }
        return Arrays.asList(new Attribute(this.responseVariable, outputDatatype));
    }

    public void start() {
        try {
            this.populateFeatureAttributeMapping();
        }
        catch (ExecutionPlanCreationException e) {
            log.error((Object)"Error while retrieving ML-models", (Throwable)e);
            throw new ExecutionPlanCreationException("Error while retrieving ML-models\n" + e.getMessage());
        }
    }

    private void populateFeatureAttributeMapping() {
        this.attributeIndexMap = new HashMap<Integer, int[]>();
        Map<String, Integer> featureIndexMap = this.modelHandlers[0].getFeatures();
        List<Integer> newToOldIndicesList = this.modelHandlers[0].getNewToOldIndicesList();
        if (this.attributeSelectionAvailable) {
            for (ExpressionExecutor expressionExecutor : this.attributeExpressionExecutors) {
                if (!(expressionExecutor instanceof VariableExpressionExecutor)) continue;
                VariableExpressionExecutor variable = (VariableExpressionExecutor)expressionExecutor;
                String variableName = variable.getAttribute().getName();
                if (featureIndexMap.get(variableName) != null) {
                    int featureIndex = featureIndexMap.get(variableName);
                    int newFeatureIndex = newToOldIndicesList.indexOf(featureIndex);
                    this.attributeIndexMap.put(newFeatureIndex, variable.getPosition());
                    continue;
                }
                throw new ExecutionPlanCreationException("No matching feature name found in the models for the attribute : " + variableName);
            }
        } else {
            String[] attributeNames;
            for (String attributeName : attributeNames = this.inputDefinition.getAttributeNameArray()) {
                if (featureIndexMap.get(attributeName) == null) {
                    throw new ExecutionPlanCreationException("No matching feature name found in the models for the attribute : " + attributeName);
                }
                int featureIndex = featureIndexMap.get(attributeName);
                int newFeatureIndex = newToOldIndicesList.indexOf(featureIndex);
                int[] attributeIndexArray = new int[4];
                attributeIndexArray[2] = 2;
                attributeIndexArray[3] = this.inputDefinition.getAttributePosition(attributeName);
                this.attributeIndexMap.put(newFeatureIndex, attributeIndexArray);
            }
        }
    }

    private Attribute.Type getOutputAttributeType(String dataType) {
        if (dataType.equalsIgnoreCase("double")) {
            return Attribute.Type.DOUBLE;
        }
        if (dataType.equalsIgnoreCase("float")) {
            return Attribute.Type.FLOAT;
        }
        if (dataType.equalsIgnoreCase("integer") || dataType.equalsIgnoreCase("int")) {
            return Attribute.Type.INT;
        }
        if (dataType.equalsIgnoreCase("long")) {
            return Attribute.Type.LONG;
        }
        if (dataType.equalsIgnoreCase("string")) {
            return Attribute.Type.STRING;
        }
        if (dataType.equalsIgnoreCase("boolean") || dataType.equalsIgnoreCase("bool")) {
            return Attribute.Type.BOOL;
        }
        throw new ExecutionPlanValidationException("Invalid data-type defined for response variable.");
    }

    private void logError(int modelId, Exception e) {
        log.error((Object)("Error while retrieving ML-model : " + this.modelStorageLocations[modelId]), (Throwable)e);
        throw new ExecutionPlanCreationException("Error while retrieving ML-model : " + this.modelStorageLocations[modelId] + "\n" + e.getMessage());
    }

    public void stop() {
    }

    public Object[] currentState() {
        return new Object[0];
    }

    public void restoreState(Object[] state) {
    }
}

