/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.usage.agent.persist;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.core.transports.metering.MeteredServletRequest;
import org.wso2.carbon.core.transports.metering.MeteredServletResponse;
import org.wso2.carbon.core.transports.metering.RequestDataPersister;
import org.wso2.carbon.usage.agent.beans.BandwidthUsage;
import org.wso2.carbon.usage.agent.util.Util;

public class ServiceDataPersistor
implements RequestDataPersister {
    private static final Log log = LogFactory.getLog(ServiceDataPersistor.class);

    public void persist(MeteredServletRequest wrappedRequest, MeteredServletResponse wrappedResponse) {
        BandwidthUsage usage;
        if ("true".equals(wrappedRequest.getAttribute("meteringServiceName"))) {
            return;
        }
        Integer tenantId = (Integer)wrappedRequest.getAttribute("tenantId");
        if (tenantId == null || tenantId == -1234) {
            return;
        }
        long inDataSize = wrappedRequest.getReadSize();
        long outDataSize = wrappedResponse.getWrittenSize();
        if (log.isTraceEnabled()) {
            log.trace((Object)("Persisting service bandwidth usage for tenant " + tenantId + " in size: " + inDataSize + " out size: " + outDataSize));
        }
        if (inDataSize > 0L) {
            usage = new BandwidthUsage(tenantId, "ServiceBandwidth-In", inDataSize);
            Util.addToPersistingControllerQueue(usage);
        }
        if (outDataSize > 0L) {
            usage = new BandwidthUsage(tenantId, "ServiceBandwidth-Out", outDataSize);
            Util.addToPersistingControllerQueue(usage);
        }
    }
}

