/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.usage.agent.persist;

import java.util.Queue;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.usage.agent.beans.BandwidthUsage;
import org.wso2.carbon.usage.agent.config.UsageAgentConfiguration;
import org.wso2.carbon.usage.agent.persist.BandwidthUsageDataRetrievalTask;
import org.wso2.carbon.usage.agent.persist.UsageDataPersistenceTask;

public class UsageDataPersistenceManager {
    private static final Log log = LogFactory.getLog(UsageDataPersistenceManager.class);
    private Queue<BandwidthUsage> persistenceJobs = new LinkedBlockingQueue<BandwidthUsage>();
    private final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(2, new UsageDataPersistenceThreadFactory());
    private UsageAgentConfiguration configuration;

    public UsageDataPersistenceManager(UsageAgentConfiguration configuration) {
        this.configuration = configuration;
    }

    public void addToQueue(BandwidthUsage usage) {
        this.persistenceJobs.add(usage);
    }

    public void scheduleUsageDataPersistenceTask() {
        if (this.configuration.getUsageTasksExecutionIntervalInMilliSeconds() > 0) {
            this.scheduler.scheduleWithFixedDelay(new UsageDataPersistenceTask(this.persistenceJobs, this.configuration), this.configuration.getUsageTasksStartupDelayInMilliSeconds(), this.configuration.getUsageTasksExecutionIntervalInMilliSeconds(), TimeUnit.MILLISECONDS);
            log.debug((Object)"Usage data persistence task was scheduled");
        } else {
            log.debug((Object)"Usage data persistence task is disabled");
        }
    }

    public void scheduleBandwidthUsageDataRetrievalTask() {
        if (this.configuration.getUsageTasksExecutionIntervalInMilliSeconds() > 0) {
            this.scheduler.scheduleWithFixedDelay(new BandwidthUsageDataRetrievalTask(this.configuration), this.configuration.getUsageTasksStartupDelayInMilliSeconds(), this.configuration.getUsageTasksExecutionIntervalInMilliSeconds(), TimeUnit.MILLISECONDS);
            log.debug((Object)"Bandwidth Usage data retrieval task was scheduled");
        } else {
            log.debug((Object)"Bandwidth Usage data retrieval task was disabled");
        }
    }

    class UsageDataPersistenceThreadFactory
    implements ThreadFactory {
        private int counter = 0;

        UsageDataPersistenceThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable r) {
            return new Thread(r, "UsageDataPersistenceThread-" + this.counter++);
        }
    }
}

