/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.common.services;

import javax.servlet.http.HttpSession;
import org.apache.axis2.context.MessageContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.core.AbstractAdmin;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.service.RegistryService;

public abstract class RegistryAbstractAdmin
extends AbstractAdmin {
    private static final Log log = LogFactory.getLog(RegistryAbstractAdmin.class);
    public static final String SERVELT_SESSION = "comp.mgt.servlet.session";

    public Registry getRootRegistry() {
        if (this.getHttpSession() != null) {
            Registry registry = (Registry)this.getHttpSession().getAttribute("WSO2RegistryRoot");
            if (registry != null) {
                return registry;
            }
            log.error((Object)"Unable to find root registry instance in http session");
        }
        return null;
    }

    public Registry getRootRegistry(RegistryService registryService) {
        Registry registry = this.getRootRegistry();
        if (registry != null) {
            return registry;
        }
        HttpSession httpSession = (HttpSession)MessageContext.getCurrentMessageContext().getProperty(SERVELT_SESSION);
        if (httpSession != null) {
            registry = (Registry)httpSession.getAttribute("WSO2RegistryRoot");
            if (registry != null) {
                return registry;
            }
            if (registryService != null) {
                PrivilegedCarbonContext carbonContext = PrivilegedCarbonContext.getThreadLocalCarbonContext();
                int tenantId = carbonContext.getTenantId();
                String username = carbonContext.getUsername();
                try {
                    registry = registryService.getRegistry(username, tenantId);
                    httpSession.setAttribute("WSO2RegistryRoot", (Object)registry);
                    return registry;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return null;
    }
}

