/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.common.utils;

import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.session.UserRegistry;
import org.wso2.carbon.user.core.UserRealm;
import org.wso2.carbon.user.core.UserStoreException;

public class UserUtil {
    public static boolean isPutAllowed(String userName, String resourcePath, UserRegistry userRegistry) throws RegistryException {
        boolean putAllowed = false;
        UserRealm userRealm = userRegistry.getUserRealm();
        try {
            if (userRealm.getAuthorizationManager().isUserAuthorized(userName, resourcePath, "http://www.wso2.org/projects/registry/actions/add")) {
                putAllowed = true;
            }
        }
        catch (UserStoreException e) {
            String msg = "Could not the permission details for the user: " + userName + " for the resource: " + resourcePath + ". Caused by: " + e.getMessage();
            throw new RegistryException(msg);
        }
        return putAllowed;
    }

    public static boolean isDeleteAllowed(String userName, String resourcePath, UserRegistry userRegistry) throws RegistryException {
        boolean putAllowed = false;
        UserRealm userRealm = userRegistry.getUserRealm();
        try {
            if (userRealm.getAuthorizationManager().isUserAuthorized(userName, resourcePath, "http://www.wso2.org/projects/registry/actions/delete")) {
                putAllowed = true;
            }
        }
        catch (UserStoreException e) {
            String msg = "Could not the permission details for the user: " + userName + " for the resource: " + resourcePath + ". Caused by: " + e.getMessage();
            throw new RegistryException(msg);
        }
        return putAllowed;
    }

    public static boolean isGetAllowed(String userName, String resourcePath, UserRegistry userRegistry) throws RegistryException {
        boolean putAllowed = false;
        UserRealm userRealm = userRegistry.getUserRealm();
        try {
            if (userRealm.getAuthorizationManager().isUserAuthorized(userName, resourcePath, "http://www.wso2.org/projects/registry/actions/get")) {
                putAllowed = true;
            }
        }
        catch (UserStoreException e) {
            String msg = "Could not the permission details for the user: " + userName + " for the resource: " + resourcePath + ". Caused by: " + e.getMessage();
            throw new RegistryException(msg);
        }
        return putAllowed;
    }

    public static boolean isAuthorizeAllowed(String userName, String resourcePath, UserRegistry userRegistry) throws RegistryException {
        boolean putAllowed = false;
        UserRealm userRealm = userRegistry.getUserRealm();
        try {
            if (userRealm.getAuthorizationManager().isUserAuthorized(userName, resourcePath, "authorize")) {
                putAllowed = true;
            }
        }
        catch (UserStoreException e) {
            String msg = "Could not the permission details for the user: " + userName + " for the resource: " + resourcePath + ". Caused by: " + e.getMessage();
            throw new RegistryException(msg);
        }
        return putAllowed;
    }
}

