/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.common.utils.artifact.manager;

import java.util.HashMap;
import java.util.Map;
import org.wso2.carbon.context.CarbonContext;
import org.wso2.carbon.registry.common.utils.artifact.manager.ArtifactRepository;

public class ArtifactManager {
    private static Map<Integer, ArtifactRepository> repositories;
    private static ArtifactManager thisInstance;

    public static ArtifactManager getArtifactManager() {
        return thisInstance;
    }

    private ArtifactManager() {
        repositories = new HashMap<Integer, ArtifactRepository>();
    }

    public ArtifactRepository getTenantArtifactRepository() {
        int tid = CarbonContext.getThreadLocalCarbonContext().getTenantId();
        return this.getTenantArtifactRepository(tid);
    }

    private synchronized ArtifactRepository getTenantArtifactRepository(int tenantId) {
        ArtifactRepository repository = repositories.get(tenantId);
        if (repository == null) {
            repository = new ArtifactRepository();
            repositories.put(tenantId, repository);
        }
        return repository;
    }

    static {
        thisInstance = new ArtifactManager();
    }
}

