/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.common.utils.artifact.manager;

import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class ArtifactRepository {
    private final Set<String> artifacts = new HashSet<String>();
    private ReadWriteLock lock = new ReentrantReadWriteLock();

    public void addArtifact(String path) {
        this.lock.writeLock().lock();
        try {
            this.artifacts.add(path);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public void removeArtifact(String path) {
        this.lock.writeLock().lock();
        try {
            this.artifacts.remove(path);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public Set<String> getArtifacts() {
        this.lock.readLock().lock();
        try {
            Set<String> set = this.artifacts;
            return set;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }
}

