/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.info.services.utils;

import java.net.MalformedURLException;
import java.net.SocketException;
import java.net.URL;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.info.internal.InfoDataHolder;
import org.wso2.carbon.registry.info.services.InfoService;
import org.wso2.carbon.utils.CarbonUtils;
import org.wso2.carbon.utils.NetworkUtils;

public class ResourceUtil {
    private static final Log log = LogFactory.getLog(InfoService.class);

    public static boolean isLocalMount(String realPath) throws RegistryException {
        try {
            URL realPathUrl = new URL(realPath);
            log.debug((Object)("Real path URL: " + realPathUrl.toString()));
            String host = ResourceUtil.findServerHost();
            int port = ResourceUtil.findTransportPort(realPathUrl.getProtocol());
            return realPathUrl.getHost().equals(host) && realPathUrl.getPort() == port;
        }
        catch (MalformedURLException e) {
            throw new RegistryException(String.format("Malformed real path URL found: %s", realPath), (Throwable)e);
        }
    }

    private static String findServerHost() throws RegistryException {
        String host;
        try {
            host = NetworkUtils.getLocalHostname();
        }
        catch (SocketException e) {
            host = null;
            log.warn((Object)"An error occured while determining server host", (Throwable)e);
        }
        if (host == null) {
            host = System.getProperty("carbon.local.ip");
            log.warn((Object)"Unable to obtain server host, using the carbon.local.ip system property to determine the ip address");
        }
        if (host == null) {
            throw new RegistryException("Unable to find server host");
        }
        log.debug((Object)("Found server host: " + host));
        return host;
    }

    private static int findTransportPort(String protocol) throws RegistryException {
        String port = null;
        try {
            port = Integer.toString(CarbonUtils.getTransportPort((ConfigurationContext)InfoDataHolder.getInstance().getConfigurationContext(), (String)protocol));
        }
        catch (Exception e) {
            port = null;
            log.warn((Object)String.format("Unable to get %s port from server Axis configuration, using carbon.%s.port to determine the %s port", protocol, protocol, protocol));
        }
        if (port == null) {
            port = System.getProperty(String.format("carbon.%s.port", protocol));
        }
        if (port == null) {
            throw new RegistryException(String.format("Unable to find %s port", protocol));
        }
        log.debug((Object)String.format("Found %s port: %s", protocol, port));
        return Integer.parseInt(port);
    }
}

