/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.info.internal;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.registry.admin.api.jmx.ISubscriptionsService;
import org.wso2.carbon.registry.common.beans.SubscriptionBean;
import org.wso2.carbon.registry.core.config.RegistryContext;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.service.RegistryService;
import org.wso2.carbon.registry.core.session.UserRegistry;
import org.wso2.carbon.registry.core.utils.RegistryUtils;
import org.wso2.carbon.registry.event.core.exception.EventBrokerException;
import org.wso2.carbon.registry.event.core.subscription.Subscription;
import org.wso2.carbon.registry.eventing.services.EventingService;
import org.wso2.carbon.registry.eventing.services.SubscriptionEmailVerficationService;
import org.wso2.carbon.registry.extensions.jmx.Subscriptions;
import org.wso2.carbon.registry.info.internal.InfoDataHolder;
import org.wso2.carbon.registry.info.services.utils.SubscriptionBeanPopulator;
import org.wso2.carbon.utils.ConfigurationContextService;

@Component(name="org.wso2.carbon.registry.info", immediate=true)
public class RegistryMgtUIInfoServiceComponent {
    private static Log log = LogFactory.getLog(RegistryMgtUIInfoServiceComponent.class);
    private InfoDataHolder dataHolder = InfoDataHolder.getInstance();
    private ServiceRegistration infoServiceRegistration = null;

    @Activate
    protected void activate(ComponentContext context) {
        log.debug((Object)"******* Registry Info Management bundle is activated ******* ");
    }

    @Deactivate
    protected void deactivate(ComponentContext context) {
        if (this.infoServiceRegistration != null) {
            this.infoServiceRegistration.unregister();
            this.infoServiceRegistration = null;
        }
        log.debug((Object)"******* Registry Info UI Management bundle is deactivated ******* ");
    }

    @Reference(name="registry.service", service=RegistryService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetRegistryService")
    protected void setRegistryService(RegistryService registryService) {
        this.dataHolder.setRegistryService(registryService);
    }

    protected void unsetRegistryService(RegistryService registryService) {
        this.dataHolder.setRegistryService(null);
    }

    @Reference(name="registry.subscriptions.jmx.service", service=Subscriptions.class, cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC, unbind="unsetSubscriptions")
    protected void setSubscriptions(Subscriptions eventing) {
        eventing.setImplBean(new ISubscriptionsService(){
            private String[] eventNames = null;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public String subscribe(String endpoint, boolean isRestEndpoint, String path, String eventName) {
                PrivilegedCarbonContext.startTenantFlow();
                try {
                    PrivilegedCarbonContext.getThreadLocalCarbonContext().setTenantId(-1234);
                    PrivilegedCarbonContext.getThreadLocalCarbonContext().setUsername("carbon.super");
                    UserRegistry registry = RegistryMgtUIInfoServiceComponent.this.dataHolder.getRegistryService().getRegistry("wso2.system.user");
                    if (RegistryUtils.isRegistryReadOnly((RegistryContext)registry.getRegistryContext())) {
                        String string = null;
                        return string;
                    }
                    SubscriptionBean subscriptionBean = SubscriptionBeanPopulator.subscribeAndPopulate(registry, path, endpoint, eventName, isRestEndpoint);
                    if (subscriptionBean != null && subscriptionBean.getSubscriptionInstances() != null && subscriptionBean.getSubscriptionInstances().length > 0) {
                        String string = subscriptionBean.getSubscriptionInstances()[0].getId();
                        return string;
                    }
                }
                catch (RegistryException e) {
                    log.error((Object)"An error occurred while subscribing", (Throwable)e);
                }
                finally {
                    PrivilegedCarbonContext.endTenantFlow();
                }
                return "";
            }

            public void unsubscribe(String id) {
                PrivilegedCarbonContext.startTenantFlow();
                try {
                    PrivilegedCarbonContext.getThreadLocalCarbonContext().setTenantId(-1234);
                    PrivilegedCarbonContext.getThreadLocalCarbonContext().setUsername("carbon.super");
                    RegistryMgtUIInfoServiceComponent.this.dataHolder.getRegistryEventingService().unsubscribe(id);
                }
                finally {
                    PrivilegedCarbonContext.endTenantFlow();
                }
            }

            public String[] getEventNames() {
                if (this.eventNames != null) {
                    return this.eventNames;
                }
                TreeSet<String> output = new TreeSet<String>();
                Collection values = RegistryMgtUIInfoServiceComponent.this.dataHolder.getRegistryEventingService().getEventTypes().values();
                for (Object value : values) {
                    String[] types = (String[])value;
                    if (types[0] != null) {
                        output.add(types[0]);
                    }
                    if (types[1] == null) continue;
                    output.add(types[1]);
                }
                this.eventNames = output.toArray(new String[output.size()]);
                return this.eventNames;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public String[] getList() {
                LinkedList<String> output = new LinkedList<String>();
                PrivilegedCarbonContext.startTenantFlow();
                try {
                    PrivilegedCarbonContext.getThreadLocalCarbonContext().setTenantId(-1234);
                    PrivilegedCarbonContext.getThreadLocalCarbonContext().setUsername("carbon.super");
                    List subscriptions = RegistryMgtUIInfoServiceComponent.this.dataHolder.getRegistryEventingService().getAllSubscriptions();
                    for (Subscription subscription : subscriptions) {
                        output.add(subscription.getId() + ":" + subscription.getTopicName() + ":" + subscription.getEventSinkURL());
                    }
                }
                catch (EventBrokerException e) {
                    log.error((Object)"Unable to retrieve subscriptions", (Throwable)e);
                }
                finally {
                    PrivilegedCarbonContext.endTenantFlow();
                }
                return output.toArray(new String[output.size()]);
            }
        });
    }

    protected void unsetSubscriptions(Subscriptions eventing) {
        eventing.setImplBean(null);
    }

    @Reference(name="registry.eventing.service", service=EventingService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetRegistryEventingService")
    protected void setRegistryEventingService(EventingService eventingService) {
        this.dataHolder.setRegistryEventingService(eventingService);
        log.debug((Object)"Successfully set registry eventing service");
    }

    protected void unsetRegistryEventingService(EventingService eventingService) {
        this.dataHolder.setRegistryEventingService(null);
    }

    @Reference(name="registry.subscription.email.verification.service", service=SubscriptionEmailVerficationService.class, cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC, unbind="unsetSubscriptionEmailVerficationService")
    protected void setSubscriptionEmailVerficationService(SubscriptionEmailVerficationService subscriptionEmailVerficationService) {
        this.dataHolder.setSubscriptionEmailVerficationService(subscriptionEmailVerficationService);
        log.debug((Object)"Successfully set subscription e-mail verification service");
    }

    protected void unsetSubscriptionEmailVerficationService(SubscriptionEmailVerficationService subscriptionEmailVerficationService) {
        this.dataHolder.setSubscriptionEmailVerficationService(null);
    }

    @Reference(name="configuration.context.service", service=ConfigurationContextService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetConfigurationContextService")
    protected void setConfigurationContextService(ConfigurationContextService configurationContextService) {
        log.debug((Object)"The Configuration Context Service was set");
        if (configurationContextService != null) {
            this.dataHolder.setConfigurationContext(configurationContextService.getServerConfigContext());
        }
    }

    protected void unsetConfigurationContextService(ConfigurationContextService configurationContextService) {
        this.dataHolder.setConfigurationContext(null);
    }
}

