/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.info.services.utils;

import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.apache.axis2.context.MessageContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.registry.common.beans.SubscriptionBean;
import org.wso2.carbon.registry.common.beans.utils.SubscriptionInstance;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.ResourcePath;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.pagination.PaginationContext;
import org.wso2.carbon.registry.core.pagination.PaginationUtils;
import org.wso2.carbon.registry.core.session.UserRegistry;
import org.wso2.carbon.registry.event.core.exception.EventBrokerException;
import org.wso2.carbon.registry.event.core.subscription.Subscription;
import org.wso2.carbon.registry.event.ws.internal.builders.exceptions.InvalidMessageException;
import org.wso2.carbon.registry.event.ws.internal.builders.utils.BuilderUtils;
import org.wso2.carbon.registry.info.internal.InfoDataHolder;
import org.wso2.carbon.registry.info.services.utils.ResourceUtil;
import org.wso2.carbon.user.core.UserRealm;
import org.wso2.carbon.user.core.UserStoreException;

public class SubscriptionBeanPopulator {
    private static final Log log = LogFactory.getLog(SubscriptionBeanPopulator.class);
    private InfoDataHolder dataHolder = InfoDataHolder.getInstance();
    public static final String RECURSE = "-R";

    private static SubscriptionInstance populate(String path, Subscription subscription) {
        String delimiter = null;
        if (subscription.getTopicName().contains("#") || subscription.getTopicName().contains("*")) {
            delimiter = subscription.getTopicName().substring(subscription.getTopicName().lastIndexOf("/") + 1);
        }
        return SubscriptionBeanPopulator.populate(path, subscription, delimiter);
    }

    private static SubscriptionInstance populate(String path, Subscription subscription, String delimiter) {
        SubscriptionInstance subscriptionInstance = new SubscriptionInstance();
        if (subscription != null) {
            if (subscription.getId() == null || subscription.getTopicName() == null) {
                log.error((Object)"Failed getting ID or Filter Value");
                return null;
            }
            String[] temp = subscription.getTopicName().split("/");
            String eventName = "";
            eventName = subscription.getEventDispatcherName() != null && subscription.getEventDispatcherName().startsWith("/registry") ? (temp[0].equals("") ? temp[3] : temp[2]) : (temp[0].equals("") ? temp[temp.length - 1] : temp[0]);
            String tempTopic = "/registry/notifications/" + eventName + path;
            if (delimiter != null && (delimiter.equals("#") || delimiter.equals("*"))) {
                tempTopic = tempTopic.endsWith("/") ? tempTopic + delimiter : tempTopic + "/" + delimiter;
            }
            if (!subscription.getTopicName().equals(tempTopic)) {
                log.debug((Object)("Filter name is: " + subscription.getTopicName() + ". Expected: " + "/registry/notifications" + eventName + "/" + path + "."));
                return null;
            }
            subscriptionInstance.setId(subscription.getId());
            subscriptionInstance.setAddress(subscription.getEventSinkURL());
            subscriptionInstance.setTopic(subscription.getTopicName());
            subscriptionInstance.setEventName(eventName);
            String address = subscriptionInstance.getAddress();
            if (address.startsWith("digest://")) {
                subscriptionInstance.setDigestType(address.substring(9, 10));
                address = address.substring(11);
            } else {
                subscriptionInstance.setDigestType("");
            }
            if (address.startsWith("mailto:")) {
                subscriptionInstance.setNotificationMethod("email");
            } else if (address.startsWith("user://")) {
                subscriptionInstance.setNotificationMethod("username");
            } else if (address.startsWith("role://")) {
                subscriptionInstance.setNotificationMethod("role");
            } else if (address.startsWith("jmx://")) {
                subscriptionInstance.setNotificationMethod("jmx");
            } else if (address.startsWith("work://")) {
                subscriptionInstance.setNotificationMethod("work");
            } else if (subscription.getProperties() != null && subscription.getProperties().get("doRest") != null && ((String)subscription.getProperties().get("doRest")).equals(Boolean.toString(Boolean.TRUE))) {
                subscriptionInstance.setNotificationMethod("html.plain.text");
            } else {
                subscriptionInstance.setNotificationMethod("soap");
            }
        } else {
            throw new IllegalStateException("A valid subscription was not present");
        }
        log.debug((Object)"Found subscription instance");
        return subscriptionInstance;
    }

    public static SubscriptionBean populate(UserRegistry userRegistry, String path) {
        Resource resource = null;
        boolean recurse = false;
        String url = null;
        String userName = null;
        if (!path.startsWith(RECURSE)) {
            try {
                resource = userRegistry.get(path);
            }
            catch (Exception e) {
                log.warn((Object)("Unable to fetch Resource at path: " + path));
                resource = null;
            }
        } else {
            path = path.substring(RECURSE.length());
            recurse = true;
        }
        if (resource != null) {
            String isLink = resource.getProperty("registry.link");
            String mountPoint = resource.getProperty("registry.mountpoint");
            String targetPoint = resource.getProperty("registry.targetpoint");
            String realPath = resource.getProperty("registry.realpath");
            String actualPath = resource.getProperty("registry.actualpath");
            userName = resource.getProperty("registry.user");
            if (isLink != null && mountPoint != null && targetPoint != null) {
                path = actualPath;
            } else if (isLink != null && realPath != null && userName != null) {
                log.debug((Object)("Found mounted resource at: " + realPath));
                if (!realPath.contains("/registry/resourceContent?")) {
                    path = realPath;
                } else {
                    boolean isLocalMount = false;
                    try {
                        isLocalMount = ResourceUtil.isLocalMount(realPath);
                    }
                    catch (RegistryException e) {
                        log.error((Object)"Unable to check whether resource is locally mounted", (Throwable)e);
                    }
                    if (!isLocalMount) {
                        url = realPath.substring(0, realPath.indexOf("/resourceContent?path="));
                    }
                }
            }
        }
        SubscriptionBean subscriptionBean = new SubscriptionBean();
        ResourcePath resourcePath = new ResourcePath(path);
        try {
            if (url == null || userName == null) {
                if (InfoDataHolder.getInstance().getRegistryEventingService() == null) {
                    throw new IllegalStateException("Subscription Manager not found");
                }
            } else if (InfoDataHolder.getInstance().getRegistryEventingService() == null) {
                throw new IllegalStateException("Remote Subscription Manager not found at: " + url);
            }
            List subscriptions = null;
            if (url == null || userName == null) {
                subscriptions = InfoDataHolder.getInstance().getRegistryEventingService().getAllSubscriptions();
            } else {
                try {
                    subscriptions = InfoDataHolder.getInstance().getRegistryEventingService().getAllSubscriptions(userName, url);
                }
                catch (UnsupportedOperationException ex) {
                    log.debug((Object)"Since getAllSubscriptions(userName, url) method is unsupported getAllSubscriptions() will be called");
                    subscriptions = InfoDataHolder.getInstance().getRegistryEventingService().getAllSubscriptions();
                }
            }
            log.debug((Object)("Found " + subscriptions.size() + " subscriptions"));
            String currentUser = userRegistry.getUserName();
            LinkedList<SubscriptionInstance> subscriptionInstances = new LinkedList<SubscriptionInstance>();
            for (Subscription subscription : subscriptions) {
                SubscriptionInstance subscriptionInstance;
                String testPath;
                if (!recurse) {
                    testPath = path;
                } else {
                    String tempTestPath;
                    testPath = subscription.getTopicName();
                    if (testPath == null || testPath.lastIndexOf("/") <= 0 || !testPath.contains(path)) {
                        log.debug((Object)("path (invalid): " + testPath));
                        continue;
                    }
                    testPath = testPath.contains("#") || testPath.contains("*") ? ((tempTestPath = testPath.substring("/registry/notifications".length() + 1, testPath.lastIndexOf("/"))).contains("/") ? tempTestPath.split("/", 2)[1] : "/") : testPath.substring("/registry/notifications".length() + 1, testPath.length()).split("/", 2)[1];
                    if (!testPath.startsWith("/")) {
                        testPath = "/" + testPath;
                    }
                }
                log.debug((Object)("path: " + testPath));
                String username = null;
                if (subscription.getProperties() != null) {
                    if (subscription.getTenantId() != userRegistry.getCallerTenantId()) {
                        log.debug((Object)"TenantId for subscription doesn't match with the logged-in tenant");
                        continue;
                    }
                    username = subscription.getOwner();
                    if (username.indexOf("@") > 0) {
                        username = username.split("@")[0];
                    }
                    log.debug((Object)("Current User is: " + userRegistry.getUserName() + ". Owner of subscription is: " + username + "."));
                    if (username == null || !username.equals(userRegistry.getUserName())) {
                        if (!SubscriptionBeanPopulator.isAuthorized(userRegistry, testPath, "authorize")) {
                            log.debug((Object)"User does not have AUTHORIZE priviledge to see this subscription");
                            continue;
                        }
                    } else if (!SubscriptionBeanPopulator.isAuthorized(userRegistry, testPath, "http://www.wso2.org/projects/registry/actions/get")) {
                        log.debug((Object)"User does not have GET priviledge to see this subscription");
                        continue;
                    }
                }
                if (currentUser == null || !currentUser.equals(username) || (subscriptionInstance = SubscriptionBeanPopulator.populate(testPath, subscription)) == null) continue;
                subscriptionInstance.setOwner(username);
                subscriptionInstances.add(subscriptionInstance);
            }
            subscriptionBean.setSubscriptionInstances(subscriptionInstances.toArray(new SubscriptionInstance[0]));
            log.debug((Object)("Returning " + subscriptionInstances.size() + " subscriptions"));
            subscriptionBean.setPathWithVersion(resourcePath.getPathWithVersion());
            subscriptionBean.setVersionView(!resourcePath.isCurrentVersion());
            subscriptionBean.setLoggedIn(!"wso2.anonymous.user".equals(userRegistry.getUserName()));
            subscriptionBean.setUserName(userRegistry.getUserName());
            subscriptionBean.setRoles(SubscriptionBeanPopulator.getRolesOfUser(userRegistry, userRegistry.getUserName()));
            if (SubscriptionBeanPopulator.isAuthorized(userRegistry, path, "authorize")) {
                subscriptionBean.setUserAccessLevel(3);
            } else if (SubscriptionBeanPopulator.isAuthorized(userRegistry, path, "http://www.wso2.org/projects/registry/actions/delete")) {
                subscriptionBean.setUserAccessLevel(2);
            } else if (SubscriptionBeanPopulator.isAuthorized(userRegistry, path, "http://www.wso2.org/projects/registry/actions/get")) {
                subscriptionBean.setUserAccessLevel(1);
            } else {
                subscriptionBean.setUserAccessLevel(0);
            }
            if (SubscriptionBeanPopulator.isAdmin(userRegistry, SubscriptionBeanPopulator.getRolesOfUser(userRegistry, userRegistry.getUserName()))) {
                subscriptionBean.setRoleAccessLevel(1);
            } else {
                subscriptionBean.setRoleAccessLevel(0);
            }
        }
        catch (EventBrokerException e) {
            String msg = "Failed to get subscriptions information of the resource " + resourcePath + ". " + e.getMessage();
            log.error((Object)("Failed to get subscriptions information of the resource " + resourcePath + "."), (Throwable)e);
            subscriptionBean.setErrorMessage(msg);
        }
        return SubscriptionBeanPopulator.getPaginatedResult(subscriptionBean);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static SubscriptionBean getPaginatedResult(SubscriptionBean subscriptionBean) {
        MessageContext messageContext = MessageContext.getCurrentMessageContext();
        if (messageContext != null && PaginationUtils.isPaginationHeadersExist((MessageContext)messageContext)) {
            int rowCount = subscriptionBean.getSubscriptionInstances().length;
            try {
                SubscriptionInstance[] paginatedResult;
                PaginationUtils.setRowCount((MessageContext)messageContext, (String)Integer.toString(rowCount));
                PaginationContext paginationContext = PaginationUtils.initPaginationContext((MessageContext)messageContext);
                int start = paginationContext.getStart();
                int count = paginationContext.getCount();
                int startIndex = start == 1 ? 0 : start;
                if (rowCount < start + count) {
                    paginatedResult = new SubscriptionInstance[rowCount - startIndex];
                    System.arraycopy(subscriptionBean.getSubscriptionInstances(), startIndex, paginatedResult, 0, rowCount - startIndex);
                } else {
                    paginatedResult = new SubscriptionInstance[count];
                    System.arraycopy(subscriptionBean.getSubscriptionInstances(), startIndex, paginatedResult, 0, count);
                }
                subscriptionBean.setSubscriptionInstances(paginatedResult);
                SubscriptionBean subscriptionBean2 = subscriptionBean;
                return subscriptionBean2;
            }
            finally {
                PaginationContext.destroy();
            }
        }
        return subscriptionBean;
    }

    public static SubscriptionBean subscribeAndPopulate(UserRegistry userRegistry, String path, String endpoint, String eventName) {
        return SubscriptionBeanPopulator.subscribeAndPopulate(userRegistry, path, endpoint, eventName, false);
    }

    public static boolean isAuthorized(UserRegistry userRegistry, String path, String action) {
        try {
            UserRealm realm = userRegistry.getUserRealm();
            if (realm.getAuthorizationManager() != null) {
                return realm.getAuthorizationManager().isUserAuthorized(userRegistry.getUserName(), path, action);
            }
            return false;
        }
        catch (UserStoreException e) {
            return false;
        }
    }

    public static String[] getRolesOfUser(UserRegistry userRegistry, String username) {
        try {
            UserRealm realm = userRegistry.getUserRealm();
            if (realm.getUserStoreManager() != null) {
                return realm.getUserStoreManager().getRoleListOfUser(username);
            }
            return new String[0];
        }
        catch (UserStoreException e) {
            return new String[0];
        }
    }

    public static boolean isAdmin(UserRegistry userRegistry, String[] rolesOfUser) {
        try {
            UserRealm realm = userRegistry.getUserRealm();
            if (realm.getRealmConfiguration() != null) {
                String adminRole = realm.getRealmConfiguration().getAdminRoleName();
                return Arrays.asList(rolesOfUser).contains(adminRole);
            }
            return false;
        }
        catch (UserStoreException e) {
            return false;
        }
    }

    private static boolean hasPermissionToSubscribeViaEmail(UserRegistry userRegistry, String path, String endpoint) {
        if (endpoint != null) {
            String address = endpoint;
            if (address.toLowerCase().startsWith("digest://")) {
                address = address.substring(11);
            }
            if (address.toLowerCase().startsWith("role://")) {
                String roleToSubscribe = address.substring(7).trim();
                String[] rolesOfUser = SubscriptionBeanPopulator.getRolesOfUser(userRegistry, userRegistry.getUserName());
                return Arrays.asList(rolesOfUser).contains(roleToSubscribe) || SubscriptionBeanPopulator.isAdmin(userRegistry, rolesOfUser);
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SubscriptionBean subscribeAndPopulate(UserRegistry userRegistry, String path, String endpoint, String eventName, boolean doRest) {
        String msg;
        SubscriptionBean subscriptionBean = new SubscriptionBean();
        Resource resource = null;
        String url = null;
        String userName = null;
        String delimiter = "";
        String[] temp = path.split("/");
        if (path.lastIndexOf("/") != 0) {
            path = path.substring(0, path.lastIndexOf("/"));
            if (temp != null && temp.length != 0) {
                if (temp[temp.length - 1].equals("#") || temp[temp.length - 1].equals("*")) {
                    delimiter = temp[temp.length - 1];
                } else if (!path.endsWith("/")) {
                    path = path + "/" + temp[temp.length - 1];
                }
            }
        } else if (path.contains("*") || path.contains("#")) {
            path = path.substring(0, path.length() - 1);
            if (temp != null && temp.length != 0 && (temp[temp.length - 1].equals("#") || temp[temp.length - 1].equals("*"))) {
                delimiter = temp[temp.length - 1];
            }
        }
        try {
            resource = userRegistry.get(path);
        }
        catch (Exception e) {
            log.warn((Object)("Unable to fetch Resource at path: " + path));
            resource = null;
        }
        if (resource != null) {
            String isLink = resource.getProperty("registry.link");
            String mountPoint = resource.getProperty("registry.mountpoint");
            String targetPoint = resource.getProperty("registry.targetpoint");
            String realPath = resource.getProperty("registry.realpath");
            String actualPath = resource.getProperty("registry.actualpath");
            userName = resource.getProperty("registry.user");
            if (isLink != null && mountPoint != null && targetPoint != null) {
                path = actualPath;
            } else if (isLink != null && realPath != null && userName != null) {
                log.debug((Object)("Found mounted resource at: " + realPath));
                if (!realPath.contains("/registry/resourceContent?")) {
                    path = realPath;
                } else {
                    boolean isLocalMount = false;
                    try {
                        isLocalMount = ResourceUtil.isLocalMount(realPath);
                    }
                    catch (RegistryException e) {
                        log.error((Object)"Unable to check whether resource is locally mounted", (Throwable)e);
                    }
                    if (!isLocalMount) {
                        url = realPath.substring(0, realPath.indexOf("/resourceContent?path="));
                    }
                }
            }
        }
        ResourcePath resourcePath = new ResourcePath(path);
        try {
            subscriptionBean.setLoggedIn(!"wso2.anonymous.user".equals(userRegistry.getUserName()));
            LinkedList<SubscriptionInstance> subscriptionInstances = new LinkedList<SubscriptionInstance>();
            if (!subscriptionBean.getLoggedIn()) {
                throw new SecurityException("User is not logged in");
            }
            if (!SubscriptionBeanPopulator.isAuthorized(userRegistry, path, "http://www.wso2.org/projects/registry/actions/get")) {
                throw new SecurityException("User does not have enough priviledges to subscribe");
            }
            if (!SubscriptionBeanPopulator.hasPermissionToSubscribeViaEmail(userRegistry, path, endpoint)) {
                throw new SecurityException("User does not have enough priviledges to subscribe another user");
            }
            if (InfoDataHolder.getInstance().getRegistryEventingService() == null) {
                throw new IllegalStateException("Registry Eventing Service Not Found");
            }
            String topic = "/registry/notifications/" + eventName + path;
            if (delimiter.equals("#") || delimiter.equals("*")) {
                topic = topic.endsWith("/") ? topic + delimiter : topic + "/" + delimiter;
            }
            Subscription subscription = BuilderUtils.createSubscription((String)endpoint, (String)"http://wso2.org/registry/eventing/dialect/topicFilter", (String)topic);
            subscription.setEventDispatcherName("/registry/notifications");
            int callerTenantId = userRegistry.getCallerTenantId();
            subscription.setTenantId(callerTenantId);
            String name = userRegistry.getUserName();
            if (callerTenantId != -1234 && callerTenantId > -1) {
                try {
                    PrivilegedCarbonContext.startTenantFlow();
                    PrivilegedCarbonContext currentContext = PrivilegedCarbonContext.getThreadLocalCarbonContext();
                    currentContext.setTenantId(callerTenantId, true);
                    String tenantDomain = currentContext.getTenantDomain();
                    if (tenantDomain != null && !tenantDomain.equals("carbon.super")) {
                        name = name + "@" + tenantDomain;
                    }
                }
                finally {
                    PrivilegedCarbonContext.endTenantFlow();
                }
            }
            subscription.setOwner(name);
            HashMap<String, String> data = new HashMap<String, String>();
            if (doRest) {
                data.put("doRest", Boolean.toString(Boolean.TRUE));
            }
            subscription.setProperties(data);
            if (url != null && userName != null) {
                throw new UnsupportedOperationException("You cannot directly subscribe to a Remote Resource. Use the Registry Browser User Interface to add a Remote Subscription.");
            }
            String subscriptionId = InfoDataHolder.getInstance().getRegistryEventingService().subscribe(subscription);
            if (subscriptionId == null) {
                throw new IllegalStateException("Subscription Id invalid");
            }
            subscription.setId(subscriptionId);
            SubscriptionInstance subscriptionInstance = SubscriptionBeanPopulator.populate(path, subscription, delimiter);
            if (subscriptionInstance != null) {
                subscriptionInstance.setOwner(userRegistry.getUserName());
                subscriptionInstances.add(subscriptionInstance);
            }
            subscriptionBean.setSubscriptionInstances(subscriptionInstances.toArray(new SubscriptionInstance[0]));
            subscriptionBean.setPathWithVersion(resourcePath.getPathWithVersion());
            subscriptionBean.setVersionView(!resourcePath.isCurrentVersion());
            subscriptionBean.setUserName(userRegistry.getUserName());
            subscriptionBean.setRoles(SubscriptionBeanPopulator.getRolesOfUser(userRegistry, userRegistry.getUserName()));
            if (SubscriptionBeanPopulator.isAuthorized(userRegistry, path, "authorize")) {
                subscriptionBean.setUserAccessLevel(3);
            } else if (SubscriptionBeanPopulator.isAuthorized(userRegistry, path, "http://www.wso2.org/projects/registry/actions/delete")) {
                subscriptionBean.setUserAccessLevel(2);
            } else if (SubscriptionBeanPopulator.isAuthorized(userRegistry, path, "http://www.wso2.org/projects/registry/actions/get")) {
                subscriptionBean.setUserAccessLevel(1);
            } else {
                subscriptionBean.setUserAccessLevel(0);
            }
            if (SubscriptionBeanPopulator.isAdmin(userRegistry, SubscriptionBeanPopulator.getRolesOfUser(userRegistry, userRegistry.getUserName()))) {
                subscriptionBean.setRoleAccessLevel(1);
            } else {
                subscriptionBean.setRoleAccessLevel(0);
            }
        }
        catch (RuntimeException e) {
            msg = "Failed to subscribe to information of the resource " + resourcePath + ". " + e.getMessage();
            log.error((Object)("Failed to subscribe to information of the resource " + resourcePath + "."), (Throwable)e);
            subscriptionBean.setErrorMessage(msg);
        }
        catch (InvalidMessageException e) {
            msg = "Failed to subscribe to information of the resource " + resourcePath + ". " + e.getMessage();
            log.error((Object)("Failed to subscribe to information of the resource " + resourcePath + "."), (Throwable)e);
            subscriptionBean.setErrorMessage(msg);
        }
        return subscriptionBean;
    }
}

