/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.info.services.utils;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.config.RegistryContext;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.session.UserRegistry;
import org.wso2.carbon.registry.core.utils.RegistryUtils;
import org.wso2.carbon.registry.event.core.subscription.Subscription;
import org.wso2.carbon.registry.info.internal.InfoDataHolder;
import org.wso2.carbon.registry.info.services.utils.ResourceUtil;
import org.wso2.carbon.registry.info.services.utils.SubscriptionBeanPopulator;

public class InfoUtil {
    private static final Log log = LogFactory.getLog(InfoUtil.class);

    public static boolean unsubscribe(UserRegistry registry, String path, String id, String sessionId) throws RegistryException {
        Resource resource;
        if (RegistryUtils.isRegistryReadOnly((RegistryContext)registry.getRegistryContext())) {
            return false;
        }
        String url = null;
        String userName = null;
        if (registry.resourceExists(path) && (resource = registry.get(path)) != null) {
            String isLink = resource.getProperty("registry.link");
            String mountPoint = resource.getProperty("registry.mountpoint");
            String targetPoint = resource.getProperty("registry.targetpoint");
            String realPath = resource.getProperty("registry.realpath");
            String actualPath = resource.getProperty("registry.actualpath");
            userName = resource.getProperty("registry.user");
            if (isLink != null && mountPoint != null && targetPoint != null) {
                path = actualPath;
            } else if (isLink != null && realPath != null && userName != null) {
                log.debug((Object)("Found mounted resource at: " + realPath));
                if (!realPath.contains("/registry/resourceContent?")) {
                    path = realPath;
                } else {
                    boolean isLocalMount = false;
                    try {
                        isLocalMount = ResourceUtil.isLocalMount(realPath);
                    }
                    catch (RegistryException e) {
                        log.error((Object)"Unable to check whether resource is locally mounted", (Throwable)e);
                    }
                    if (!isLocalMount) {
                        url = realPath.substring(0, realPath.indexOf("/resourceContent?path="));
                    }
                }
            }
        }
        log.debug((Object)("got path: " + path));
        if ("wso2.anonymous.user".equals(registry.getUserName())) {
            log.warn((Object)"User is anonymous, can't unsubscribe");
            return false;
        }
        if (InfoDataHolder.getInstance().getRegistryEventingService() == null) {
            log.warn((Object)"No event source found, can't unsubscribe");
            return false;
        }
        try {
            Subscription subscription = null;
            subscription = url == null || userName == null ? InfoDataHolder.getInstance().getRegistryEventingService().getSubscription(id) : InfoDataHolder.getInstance().getRegistryEventingService().getSubscription(id, userName, url);
            if (subscription == null) {
                log.warn((Object)"Subscription not found, can't unsubscribe");
                return false;
            }
            if (subscription.getTenantId() != registry.getCallerTenantId()) {
                log.warn((Object)"TenantId for subscription doesn't match with the logged-in tenant");
                return false;
            }
            String username = subscription.getOwner();
            if (username.indexOf("@") > 0) {
                username = username.split("@")[0];
            }
            if (username == null || !username.equals(registry.getUserName())) {
                if (!SubscriptionBeanPopulator.isAuthorized(registry, path, "authorize")) {
                    log.warn((Object)"User doesn't have AUTHORIZE priviledges, can't unsubscribe");
                    return false;
                }
            } else if (!SubscriptionBeanPopulator.isAuthorized(registry, path, "http://www.wso2.org/projects/registry/actions/get")) {
                return false;
            }
            if (url == null || userName == null) {
                return InfoDataHolder.getInstance().getRegistryEventingService().unsubscribe(id);
            }
            return InfoDataHolder.getInstance().getRegistryEventingService().unsubscribe(id, userName, url);
        }
        catch (Exception e) {
            return false;
        }
    }
}

