/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.info.services.utils;

import java.util.List;
import org.wso2.carbon.registry.common.beans.TagBean;
import org.wso2.carbon.registry.common.utils.UserUtil;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.ResourcePath;
import org.wso2.carbon.registry.core.Tag;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.session.UserRegistry;

public class TagBeanPopulator {
    public static TagBean populate(UserRegistry userRegistry, String path) {
        TagBean tagBean = new TagBean();
        try {
            Resource resource = userRegistry.get(path);
            Tag[] t = userRegistry.getTags(path);
            org.wso2.carbon.registry.common.beans.utils.Tag[] tags = new org.wso2.carbon.registry.common.beans.utils.Tag[t.length];
            for (int i = 0; i < t.length; ++i) {
                org.wso2.carbon.registry.common.beans.utils.Tag tag = new org.wso2.carbon.registry.common.beans.utils.Tag();
                tag.setCategory(t[i].getCategory());
                tag.setTagCount(t[i].getTagCount());
                tag.setTagName(t[i].getTagName());
                tags[i] = tag;
            }
            tagBean.setTags(tags);
            ResourcePath resourcePath = new ResourcePath(path);
            tagBean.setPathWithVersion(resourcePath.getPathWithVersion());
            tagBean.setVersionView(!resourcePath.isCurrentVersion());
            List mountPoints = resource.getPropertyValues("registry.mountpoint");
            List targetPoints = resource.getPropertyValues("registry.targetpoint");
            List actualPaths = resource.getPropertyValues("registry.actualpath");
            String user = resource.getProperty("registry.user");
            if (resource.getProperty("registry.link") != null) {
                if (mountPoints != null && targetPoints != null) {
                    String tempPath = (String)actualPaths.get(0);
                    tagBean.setPutAllowed(UserUtil.isPutAllowed((String)userRegistry.getUserName(), (String)tempPath, (UserRegistry)userRegistry));
                } else if (user != null) {
                    if (userRegistry.getUserName().equals(user)) {
                        tagBean.setPutAllowed(true);
                    } else {
                        tagBean.setPutAllowed(UserUtil.isPutAllowed((String)userRegistry.getUserName(), (String)path, (UserRegistry)userRegistry));
                    }
                }
            } else {
                tagBean.setPutAllowed(UserUtil.isPutAllowed((String)userRegistry.getUserName(), (String)path, (UserRegistry)userRegistry));
            }
            tagBean.setLoggedIn(!"wso2.anonymous.user".equals(userRegistry.getUserName()));
        }
        catch (RegistryException e) {
            String msg = "Failed to get tagging information of resource . " + e.getMessage();
            tagBean.setErrorMessage(msg);
        }
        return tagBean;
    }
}

