/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.info.services.utils;

import java.util.Calendar;
import java.util.List;
import org.wso2.carbon.registry.common.beans.CommentBean;
import org.wso2.carbon.registry.common.beans.utils.Comment;
import org.wso2.carbon.registry.common.utils.UserUtil;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.ResourcePath;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.session.UserRegistry;

public class CommentBeanPopulator {
    public static CommentBean populate(UserRegistry userRegistry, String path) {
        CommentBean commentBean = new CommentBean();
        try {
            Resource resource = userRegistry.get(path);
            org.wso2.carbon.registry.core.Comment[] c = userRegistry.getComments(path);
            Comment[] comments = new Comment[c.length];
            for (int i = 0; i < c.length; ++i) {
                Comment comment = new Comment();
                comment.setAuthorUserName(c[i].getAuthorUserName());
                comment.setCommentPath(c[i].getCommentPath());
                comment.setContent(c[i].getContent());
                Calendar createdDate = Calendar.getInstance();
                createdDate.setTime(c[i].getCreatedTime());
                comment.setCreatedTime(createdDate);
                comment.setDescription(c[i].getDescription());
                Calendar lastModifiedDate = Calendar.getInstance();
                lastModifiedDate.setTime(c[i].getCreatedTime());
                comment.setLastModified(lastModifiedDate);
                comment.setMediaType(c[i].getMediaType());
                comment.setResourcePath(c[i].getResourcePath());
                comment.setText(c[i].getText());
                Calendar calendarTime = Calendar.getInstance();
                calendarTime.setTime(c[i].getTime());
                comment.setTime(calendarTime);
                comment.setUser(c[i].getUser());
                comments[i] = comment;
            }
            commentBean.setComments(comments);
            ResourcePath resourcePath = new ResourcePath(path);
            commentBean.setPathWithVersion(resourcePath.getPathWithVersion());
            commentBean.setVersionView(!resourcePath.isCurrentVersion());
            List mountPoints = resource.getPropertyValues("registry.mountpoint");
            List targetPoints = resource.getPropertyValues("registry.targetpoint");
            List actualPaths = resource.getPropertyValues("registry.actualpath");
            String user = resource.getProperty("registry.user");
            if (resource.getProperty("registry.link") != null) {
                if (mountPoints != null && targetPoints != null) {
                    String tempPath = (String)actualPaths.get(0);
                    commentBean.setPutAllowed(UserUtil.isPutAllowed((String)userRegistry.getUserName(), (String)tempPath, (UserRegistry)userRegistry));
                } else if (user != null) {
                    if (userRegistry.getUserName().equals(user)) {
                        commentBean.setPutAllowed(true);
                    } else {
                        commentBean.setPutAllowed(UserUtil.isPutAllowed((String)userRegistry.getUserName(), (String)path, (UserRegistry)userRegistry));
                    }
                }
            } else {
                commentBean.setPutAllowed(UserUtil.isPutAllowed((String)userRegistry.getUserName(), (String)path, (UserRegistry)userRegistry));
            }
            commentBean.setLoggedIn(!"wso2.anonymous.user".equals(userRegistry.getUserName()));
        }
        catch (RegistryException e) {
            String msg = "Failed to get comment information of the resource. " + e.getMessage();
            commentBean.setErrorMessage(msg);
        }
        return commentBean;
    }
}

