/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.info.services.utils;

import java.util.Map;
import java.util.Set;
import org.wso2.carbon.registry.common.beans.EventTypeBean;
import org.wso2.carbon.registry.common.beans.utils.EventType;
import org.wso2.carbon.registry.core.ResourcePath;
import org.wso2.carbon.registry.core.session.UserRegistry;
import org.wso2.carbon.registry.info.internal.InfoDataHolder;

public class EventTypeBeanPopulator {
    public static EventTypeBean populate(UserRegistry userRegistry, String path) {
        EventTypeBean eventTypeBean = new EventTypeBean();
        ResourcePath resourcePath = new ResourcePath(path);
        try {
            if (InfoDataHolder.getInstance().getRegistryEventingService() == null || InfoDataHolder.getInstance().getRegistryEventingService().getEventTypes() == null) {
                throw new IllegalStateException("No Event Types defined");
            }
            Map eventTypeMap = InfoDataHolder.getInstance().getRegistryEventingService().getEventTypes();
            EventType[] eventTypes = new EventType[eventTypeMap.size()];
            Set entrySet = eventTypeMap.entrySet();
            if (eventTypeMap.size() > 0) {
                int count = 0;
                for (Map.Entry e : entrySet) {
                    if (InfoDataHolder.getInstance().getRegistryEventingService().isEventTypeExclusionRegistered((String)e.getKey(), path)) continue;
                    EventType eventType = new EventType();
                    eventType.setId((String)e.getKey());
                    eventType.setResourceEvent(((String[])e.getValue())[0]);
                    eventType.setCollectionEvent(((String[])e.getValue())[1]);
                    eventTypes[count++] = eventType;
                }
            }
            eventTypeBean.setEventTypes(eventTypes);
        }
        catch (Exception e) {
            String msg = "Failed to get Event Types available for the resource " + resourcePath + ". " + e.getMessage();
            eventTypeBean.setErrorMessage(msg);
        }
        return eventTypeBean;
    }
}

