/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.jcr;

import java.io.InputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Pattern;
import javax.jcr.AccessDeniedException;
import javax.jcr.Binary;
import javax.jcr.InvalidItemStateException;
import javax.jcr.InvalidLifecycleTransitionException;
import javax.jcr.Item;
import javax.jcr.ItemExistsException;
import javax.jcr.ItemNotFoundException;
import javax.jcr.ItemVisitor;
import javax.jcr.MergeException;
import javax.jcr.NoSuchWorkspaceException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.ReferentialIntegrityException;
import javax.jcr.RepositoryException;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.Value;
import javax.jcr.ValueFormatException;
import javax.jcr.lock.Lock;
import javax.jcr.lock.LockException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import javax.jcr.nodetype.NodeDefinition;
import javax.jcr.nodetype.NodeType;
import javax.jcr.version.ActivityViolationException;
import javax.jcr.version.Version;
import javax.jcr.version.VersionException;
import javax.jcr.version.VersionHistory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.registry.core.CollectionImpl;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.ResourceImpl;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.utils.RegistryUtils;
import org.wso2.carbon.registry.jcr.RegistryNodeIterator;
import org.wso2.carbon.registry.jcr.RegistryProperty;
import org.wso2.carbon.registry.jcr.RegistryPropertyIterator;
import org.wso2.carbon.registry.jcr.RegistrySession;
import org.wso2.carbon.registry.jcr.RegistryValue;
import org.wso2.carbon.registry.jcr.lock.RegistryLockManager;
import org.wso2.carbon.registry.jcr.nodetype.RegistryNodeDefinition;
import org.wso2.carbon.registry.jcr.nodetype.RegistryNodeType;
import org.wso2.carbon.registry.jcr.util.RegistryJCRItemOperationUtil;
import org.wso2.carbon.registry.jcr.util.RegistryJCRSpecificStandardLoderUtil;

public class RegistryNode
implements Node {
    public String nodePath = "";
    public CollectionImpl resource = null;
    private RegistrySession registrySession;
    private Property property;
    private boolean isModified = false;
    public RegistryNodeType nodeType = null;
    private static Log log = LogFactory.getLog(RegistryNode.class);
    private boolean isRemoved = false;

    public RegistryNode(String s, RegistrySession registrySession) {
        this.nodePath = s;
        this.registrySession = registrySession;
        this.initColl(s);
    }

    private NodeType getNodetype() throws RepositoryException {
        NodeType ntType = null;
        if (this.resource.getDescription() != null) {
            ntType = this.registrySession.getWorkspace().getNodeTypeManager().getNodeType(this.resource.getDescription());
        } else {
            try {
                String parPath = "";
                parPath = this.resource.getParentPath();
                String ntName = this.registrySession.getUserRegistry().get(parPath).getDescription();
                ntType = this.registrySession.getWorkspace().getNodeTypeManager().getNodeType(ntName);
            }
            catch (RegistryException e) {
                log.error((Object)"Error occurred while getting node type");
            }
        }
        return ntType;
    }

    public void initColl(String np) {
        try {
            this.resource = (CollectionImpl)this.registrySession.getUserRegistry().newCollection();
            this.resource.setPath(np);
        }
        catch (RegistryException e) {
            e.printStackTrace();
        }
    }

    public void setCollection(String s) throws RegistryException {
        try {
            if (s != null && this.registrySession.getUserRegistry().get(s) instanceof CollectionImpl) {
                this.resource = (CollectionImpl)this.registrySession.getUserRegistry().get(s);
            }
        }
        catch (RegistryException e) {
            String msg = "Exception occurred in registry collection creation " + this;
            log.debug((Object)msg);
            throw new RegistryException(msg, (Throwable)e);
        }
    }

    public Node addNode(String s) throws ItemExistsException, PathNotFoundException, VersionException, ConstraintViolationException, LockException, RepositoryException {
        RegistryJCRItemOperationUtil.checkRetentionPolicy(this.registrySession, this.getPath());
        RegistryJCRItemOperationUtil.checkRetentionHold(this.registrySession, this.getPath());
        String absPath = "";
        String ntName = "";
        if (this.hasNode(s)) {
            throw new ItemExistsException("Node " + s + " already exists");
        }
        if (this.validateNodePathRefersToAPropertyPath(s)) {
            throw new ConstraintViolationException("Relative path cannot be a property " + s);
        }
        if (!this.validateIntermediateNodeExistance(s)) {
            throw new PathNotFoundException("Intermediate nodes doesn't exists under " + s);
        }
        absPath = this.nodePath + "/" + s;
        RegistryNode subNode = new RegistryNode(absPath, this.registrySession);
        ntName = !this.nodePath.equals(this.registrySession.getWorkspaceRootPath()) && this.getNodetype() != null ? this.getNodetype().getName() : "nt:base";
        CollectionImpl subCollection = null;
        try {
            subCollection = (CollectionImpl)this.registrySession.getUserRegistry().newCollection();
            subCollection.setDescription(ntName);
            subCollection.setProperty("jcr:uuid", absPath);
            if (ntName.equals("mix:simpleVersionable") || ntName.equals("mix:versionable")) {
                subCollection.setProperty("jcr:checkedOut", "true");
                subCollection.setProperty("jcr:isCheckedOut", "true");
                subCollection.setProperty("jcr:frozenPrimaryType", ntName);
            }
            this.registrySession.getUserRegistry().put(absPath, (Resource)subCollection);
            subNode.setCollection(absPath);
            subNode.setPrimaryType(ntName);
            subNode.nodeType = (RegistryNodeType)this.registrySession.getWorkspace().getNodeTypeManager().getNodeType(ntName);
        }
        catch (RegistryException e) {
            String msg = "failed to resolve the path of the given node " + this;
            log.debug((Object)msg);
            throw new PathNotFoundException(msg, (Throwable)e);
        }
        this.isModified = true;
        return subNode;
    }

    private boolean validateIntermediateNodeExistance(String s) {
        boolean validPath;
        if (s.contains("/")) {
            String[] tmp = s.split("/");
            String interm_path = s.substring(0, s.length() - tmp[tmp.length - 1].length() - 1);
            try {
                String abspath = "";
                abspath = !this.nodePath.equals(this.registrySession.getWorkspaceRootPath()) ? this.nodePath + "/" + interm_path : this.nodePath + interm_path;
                validPath = this.registrySession.getUserRegistry().resourceExists(abspath);
            }
            catch (RegistryException e) {
                validPath = false;
            }
        } else {
            validPath = true;
        }
        return validPath;
    }

    private boolean validateNodePathRefersToAPropertyPath(String s) throws RepositoryException, PathNotFoundException {
        boolean isAPropertyPath = false;
        String abspath = "";
        try {
            if (s.contains("/")) {
                String[] tmp = s.split("/");
                String interm_path = s.substring(0, s.length() - tmp[tmp.length - 1].length() - 1);
                abspath = !this.nodePath.equals(this.registrySession.getWorkspaceRootPath()) ? this.nodePath + "/" + interm_path : this.nodePath + interm_path;
                if (this.registrySession.getItem(abspath) instanceof Property) {
                    isAPropertyPath = true;
                }
            } else if (this.hasProperty(s)) {
                isAPropertyPath = true;
            }
        }
        catch (PathNotFoundException e) {
            throw new PathNotFoundException("No such path exists to add the Item to " + abspath);
        }
        catch (RepositoryException e) {
            throw new RepositoryException("Error occurred while adding the Item to the " + abspath);
        }
        return isAPropertyPath;
    }

    public Node addNode(String s, String s1) throws ItemExistsException, PathNotFoundException, NoSuchNodeTypeException, LockException, VersionException, ConstraintViolationException, RepositoryException {
        this.registrySession.getWorkspace().getNodeTypeManager().getNodeType(s1);
        if (this.hasNode(s)) {
            throw new ItemExistsException("Node " + s + " already exists");
        }
        if (this.validateNodePathRefersToAPropertyPath(s)) {
            throw new ConstraintViolationException("Relative path cannot be a property " + s);
        }
        if (!this.validateIntermediateNodeExistance(s)) {
            throw new PathNotFoundException("Intermediate nodes doesn't exists under " + s);
        }
        String absPath = "";
        String ntName = "";
        absPath = this.nodePath != null && this.nodePath.equals(this.registrySession.getWorkspaceRootPath()) ? this.nodePath + s : this.nodePath + "/" + s;
        RegistryNode subNode = new RegistryNode(absPath, this.registrySession);
        ntName = s1;
        CollectionImpl subCollection = null;
        try {
            subCollection = (CollectionImpl)this.registrySession.getUserRegistry().newCollection();
            subCollection.setDescription(ntName);
            subCollection.setProperty("jcr:uuid", absPath);
            if (ntName.equals("mix:simpleVersionable") || ntName.equals("mix:versionable")) {
                subCollection.setProperty("jcr:checkedOut", "true");
                subCollection.setProperty("jcr:isCheckedOut", "true");
                subCollection.setProperty("jcr:frozenPrimaryType", ntName);
            }
            if (ntName.startsWith("mix")) {
                this.addMixin(s1);
            }
            this.registrySession.getUserRegistry().put(absPath, (Resource)subCollection);
            subNode.setCollection(absPath);
        }
        catch (RegistryException e) {
            String msg = "failed to resolve the path of the given node " + this;
            log.debug((Object)msg);
            throw new PathNotFoundException(msg, (Throwable)e);
        }
        subNode.setPrimaryType(s1);
        subNode.nodeType = (RegistryNodeType)this.registrySession.getWorkspace().getNodeTypeManager().getNodeType(s1);
        this.isModified = true;
        return subNode;
    }

    public void orderBefore(String s, String s1) throws UnsupportedRepositoryOperationException, VersionException, ConstraintViolationException, ItemNotFoundException, LockException, RepositoryException {
    }

    public Property setProperty(String s, Value value) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        RegistryJCRItemOperationUtil.checkRetentionPolicy(this.registrySession, this.getPath());
        RegistryJCRItemOperationUtil.checkRetentionHold(this.registrySession, this.getPath());
        this.registrySession.sessionPending();
        this.validatePropertyModifyPrivilege(s);
        Resource res = null;
        if (this.resource != null && value != null) {
            if (value.getType() == 1) {
                try {
                    res = this.registrySession.getUserRegistry().newResource();
                    res.setContent((Object)value.getString());
                    res.setProperty("registry.jcr.property.type", "value_type");
                    this.registrySession.getUserRegistry().put(this.nodePath + "/" + s, res);
                    this.property = new RegistryProperty(this.nodePath + "/" + s, this.registrySession, s, value);
                }
                catch (RegistryException e) {
                    String msg = "failed to resolve the path of the given node " + this;
                    log.debug((Object)msg);
                    throw new RepositoryException(msg, (Throwable)e);
                }
            }
            this.isModified = true;
            return this.property;
        }
        if (value == null) {
            try {
                Resource resource = this.registrySession.getUserRegistry().get(this.nodePath);
                resource.removeProperty(s);
                this.registrySession.getUserRegistry().put(this.nodePath, resource);
                this.isModified = true;
            }
            catch (RegistryException e) {
                String msg = "failed to resolve the path of the given node or violation of repository syntax " + this;
                log.debug((Object)msg);
                throw new RepositoryException(msg, (Throwable)e);
            }
            return null;
        }
        return null;
    }

    public Property setProperty(String s, Value value, int i) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        RegistryJCRItemOperationUtil.checkRetentionPolicy(this.registrySession, this.getPath());
        RegistryJCRItemOperationUtil.checkRetentionHold(this.registrySession, this.getPath());
        this.validatePropertyModifyPrivilege(s);
        this.isModified = true;
        return this.setProperty(s, value);
    }

    public Property setProperty(String s, Value[] values) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        RegistryJCRItemOperationUtil.checkRetentionPolicy(this.registrySession, this.getPath());
        RegistryJCRItemOperationUtil.checkRetentionHold(this.registrySession, this.getPath());
        this.registrySession.sessionPending();
        this.validatePropertyModifyPrivilege(s);
        ArrayList<String> properties = new ArrayList<String>();
        if (values != null) {
            for (Value val : values) {
                if (val == null) continue;
                properties.add(val.getString());
            }
            Resource res = null;
            try {
                res = this.registrySession.getUserRegistry().newResource();
                res.setProperty(s, properties);
                res.setProperty("registry.jcr.property.type", "values_type");
                this.registrySession.getUserRegistry().put(this.nodePath + "/" + s, res);
                this.property = new RegistryProperty(this.nodePath + "/" + s, this.registrySession, s, values);
            }
            catch (RegistryException e) {
                String msg = "failed to resolve the path of the given node or violation of repository syntax " + this;
                log.debug((Object)msg);
                throw new RepositoryException(msg, (Throwable)e);
            }
            this.isModified = true;
            return this.property;
        }
        return null;
    }

    public Property setProperty(String s, Value[] values, int i) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        RegistryJCRItemOperationUtil.checkRetentionPolicy(this.registrySession, this.getPath());
        RegistryJCRItemOperationUtil.checkRetentionHold(this.registrySession, this.getPath());
        this.validatePropertyModifyPrivilege(s);
        this.isModified = true;
        return this.setProperty(s, values);
    }

    private Property setPropertyToNode(String s, String[] strings) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        RegistryJCRItemOperationUtil.checkRetentionPolicy(this.registrySession, this.getPath());
        RegistryJCRItemOperationUtil.checkRetentionHold(this.registrySession, this.getPath());
        this.isModified = true;
        return RegistryJCRItemOperationUtil.persistStringPropertyValues(this.registrySession, this.nodePath, s, strings);
    }

    public Property setProperty(String s, String[] strings) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        RegistryJCRItemOperationUtil.checkRetentionPolicy(this.registrySession, this.getPath());
        RegistryJCRItemOperationUtil.checkRetentionHold(this.registrySession, this.getPath());
        this.registrySession.sessionPending();
        this.validatePropertyModifyPrivilege(s);
        if (this.hasProperty(s) && !this.getProperty(s).isMultiple()) {
            throw new ValueFormatException("Cannot overrride the initial value format " + s);
        }
        this.isModified = true;
        return this.setPropertyToNode(s, strings);
    }

    public Property setProperty(String s, String[] strings, int i) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        RegistryJCRItemOperationUtil.checkRetentionPolicy(this.registrySession, this.getPath());
        RegistryJCRItemOperationUtil.checkRetentionHold(this.registrySession, this.getPath());
        this.validatePropertyModifyPrivilege(s);
        this.isModified = true;
        return this.setProperty(s, strings);
    }

    public Property setProperty(String s, String s1) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        RegistryJCRItemOperationUtil.checkRetentionPolicy(this.registrySession, this.getPath());
        RegistryJCRItemOperationUtil.checkRetentionHold(this.registrySession, this.getPath());
        this.registrySession.sessionPending();
        this.validatePropertyModifyPrivilege(s);
        if (s1 != null && s1.contains("{")) {
            s1 = RegistryJCRItemOperationUtil.replaceNameSpacePrefixURIS(s1);
        }
        if (s != null && (s.equals("jcr:primaryType") || s.equals("jcr:mixinTypes"))) {
            throw new ConstraintViolationException("Cannot mannually set jcr:primaryType/jcr:mixinTypes node types");
        }
        try {
            this.resource = (CollectionImpl)this.registrySession.getUserRegistry().get(this.nodePath);
            if (s1 != null) {
                ArrayList<String> lis = new ArrayList<String>();
                lis.add(s1);
                this.resource.setProperty(s, lis);
                this.registrySession.getUserRegistry().put(this.nodePath, (Resource)this.resource);
            } else {
                this.resource.removeProperty(s);
                this.registrySession.getUserRegistry().put(this.nodePath, (Resource)this.resource);
            }
        }
        catch (RegistryException e) {
            String msg = "failed to resolve the path of the given node or violation of repository syntax " + this;
            log.debug((Object)msg);
            throw new RepositoryException(msg, (Throwable)e);
        }
        this.property = new RegistryProperty(this.resource.getPath(), this.registrySession, s, s1);
        this.isModified = true;
        return this.property;
    }

    public Property setProperty(String s, String s1, int i) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        RegistryJCRItemOperationUtil.checkRetentionPolicy(this.registrySession, this.getPath());
        RegistryJCRItemOperationUtil.checkRetentionHold(this.registrySession, this.getPath());
        this.validatePropertyModifyPrivilege(s);
        this.isModified = true;
        return this.setProperty(s, s1);
    }

    public Property setProperty(String s, InputStream inputStream) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        RegistryJCRItemOperationUtil.checkRetentionPolicy(this.registrySession, this.getPath());
        RegistryJCRItemOperationUtil.checkRetentionHold(this.registrySession, this.getPath());
        this.registrySession.sessionPending();
        this.validatePropertyModifyPrivilege(s);
        Resource res = null;
        try {
            res = this.registrySession.getUserRegistry().newResource();
            if (inputStream != null) {
                res.setContentStream(inputStream);
                res.setProperty("registry.jcr.property.type", "input_stream");
                this.registrySession.getUserRegistry().put(this.nodePath + "/" + s, res);
                this.property = new RegistryProperty(this.nodePath + "/" + s, this.registrySession, s, inputStream);
            }
        }
        catch (RegistryException e) {
            String msg = "failed to resolve the path of the given node or violation of repository syntax " + this;
            log.debug((Object)msg);
            throw new RepositoryException(msg, (Throwable)e);
        }
        this.isModified = true;
        return this.property;
    }

    public Property setProperty(String s, Binary binary) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        RegistryJCRItemOperationUtil.checkRetentionPolicy(this.registrySession, this.getPath());
        RegistryJCRItemOperationUtil.checkRetentionHold(this.registrySession, this.getPath());
        this.registrySession.sessionPending();
        this.validatePropertyModifyPrivilege(s);
        this.property = new RegistryProperty(this.resource.getPath(), this.registrySession, s, binary);
        this.isModified = true;
        return this.property;
    }

    public Property setProperty(String s, boolean b) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        RegistryJCRItemOperationUtil.checkRetentionPolicy(this.registrySession, this.getPath());
        RegistryJCRItemOperationUtil.checkRetentionHold(this.registrySession, this.getPath());
        this.registrySession.sessionPending();
        this.validatePropertyModifyPrivilege(s);
        Resource res = null;
        try {
            res = this.registrySession.getUserRegistry().newResource();
            res.setContent((Object)String.valueOf(b));
            res.setProperty("registry.jcr.property.type", "boolean");
            this.registrySession.getUserRegistry().put(this.nodePath + "/" + s, res);
            this.property = new RegistryProperty(this.nodePath + "/" + s, this.registrySession, s, b);
        }
        catch (RegistryException e) {
            String msg = "failed to resolve the path of the given node or violation of repository syntax " + this;
            log.debug((Object)msg);
            throw new RepositoryException(msg, (Throwable)e);
        }
        this.isModified = true;
        return this.property;
    }

    public Property setProperty(String s, double v) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        RegistryJCRItemOperationUtil.checkRetentionPolicy(this.registrySession, this.getPath());
        RegistryJCRItemOperationUtil.checkRetentionHold(this.registrySession, this.getPath());
        this.registrySession.sessionPending();
        this.validatePropertyModifyPrivilege(s);
        Resource res = null;
        try {
            res = this.registrySession.getUserRegistry().newResource();
            res.setContent((Object)String.valueOf(v));
            res.setProperty("registry.jcr.property.type", "double");
            this.registrySession.getUserRegistry().put(this.nodePath + "/" + s, res);
            this.property = new RegistryProperty(this.nodePath + "/" + s, this.registrySession, s, v);
        }
        catch (RegistryException e) {
            String msg = "failed to resolve the path of the given node or violation of repository syntax " + this;
            log.debug((Object)msg);
            throw new RepositoryException(msg, (Throwable)e);
        }
        this.isModified = true;
        return this.property;
    }

    public Property setProperty(String s, BigDecimal bigDecimal) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        RegistryJCRItemOperationUtil.checkRetentionPolicy(this.registrySession, this.getPath());
        RegistryJCRItemOperationUtil.checkRetentionHold(this.registrySession, this.getPath());
        this.registrySession.sessionPending();
        this.validatePropertyModifyPrivilege(s);
        if (bigDecimal != null) {
            Resource res = null;
            try {
                res = this.registrySession.getUserRegistry().newResource();
                res.setContent((Object)bigDecimal.toString());
                res.setProperty("registry.jcr.property.type", "big_decimal");
                this.registrySession.getUserRegistry().put(this.nodePath + "/" + s, res);
                this.property = new RegistryProperty(this.nodePath + "/" + s, this.registrySession, s, bigDecimal);
            }
            catch (RegistryException e) {
                String msg = "failed to resolve the path of the given node or violation of repository syntax " + this;
                log.debug((Object)msg);
                throw new RepositoryException(msg, (Throwable)e);
            }
            this.isModified = true;
            return this.property;
        }
        this.isModified = true;
        return null;
    }

    private void validatePropertyModifyPrivilege(String name) throws RepositoryException {
        if (RegistryJCRSpecificStandardLoderUtil.isSessionReadOnly(this.registrySession.getUserID()) && this.hasProperty(name)) {
            throw new AccessDeniedException("A read only session must not be allowed to modify a property value");
        }
    }

    public Property setProperty(String s, long l) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        RegistryJCRItemOperationUtil.checkRetentionPolicy(this.registrySession, this.getPath());
        RegistryJCRItemOperationUtil.checkRetentionHold(this.registrySession, this.getPath());
        this.registrySession.sessionPending();
        this.validatePropertyModifyPrivilege(s);
        Resource res = null;
        try {
            res = this.registrySession.getUserRegistry().newResource();
            res.setContent((Object)String.valueOf(l));
            res.setProperty("registry.jcr.property.type", "long");
            this.registrySession.getUserRegistry().put(this.nodePath + "/" + s, res);
            this.property = new RegistryProperty(this.nodePath + "/" + s, this.registrySession, s, l);
        }
        catch (RegistryException e) {
            String msg = "failed to resolve the path of the given node or violation of repository syntax " + this;
            log.debug((Object)msg);
            throw new RepositoryException(msg, (Throwable)e);
        }
        this.isModified = true;
        return this.property;
    }

    public Property setProperty(String s, Calendar calendar) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        RegistryJCRItemOperationUtil.checkRetentionPolicy(this.registrySession, this.getPath());
        RegistryJCRItemOperationUtil.checkRetentionHold(this.registrySession, this.getPath());
        this.registrySession.sessionPending();
        this.validatePropertyModifyPrivilege(s);
        String _propertyPath = this.nodePath + "/" + s;
        try {
            if (calendar != null) {
                Resource res = null;
                res = this.registrySession.getUserRegistry().newResource();
                res.setContent((Object)String.valueOf(calendar.getTimeInMillis()));
                res.setProperty("registry.jcr.property.type", "calendar");
                this.registrySession.getUserRegistry().put(_propertyPath, res);
                RegistryProperty _property = new RegistryProperty(_propertyPath, this.registrySession, s, calendar);
                this.isModified = true;
                return _property;
            }
            this.isModified = true;
            this.registrySession.getUserRegistry().delete(_propertyPath);
            return null;
        }
        catch (RegistryException e) {
            String msg = "failed to resolve the path of the given node or violation of repository syntax " + this;
            log.debug((Object)msg);
            throw new RepositoryException(msg, (Throwable)e);
        }
    }

    public Property setProperty(String s, Node node) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        RegistryJCRItemOperationUtil.checkRetentionPolicy(this.registrySession, this.getPath());
        RegistryJCRItemOperationUtil.checkRetentionHold(this.registrySession, this.getPath());
        this.registrySession.sessionPending();
        this.validatePropertyModifyPrivilege(s);
        if (node != null) {
            this.property = new RegistryProperty(this.resource.getPath(), this.registrySession, s, node);
        }
        this.isModified = true;
        return this.property;
    }

    public Node getNode(String s) throws PathNotFoundException, RepositoryException {
        String abs = "";
        abs = !this.nodePath.endsWith("/") && !s.startsWith("/") ? this.nodePath + "/" + s : this.nodePath + s;
        RegistryNode subNode = null;
        try {
            if (!this.registrySession.getUserRegistry().resourceExists(abs)) {
                throw new PathNotFoundException("failed to resolve the path of the given node");
            }
            subNode = new RegistryNode(abs, this.registrySession);
            subNode.resource = (CollectionImpl)this.registrySession.getUserRegistry().get(abs);
            subNode.nodeType = (RegistryNodeType)this.registrySession.getWorkspace().getNodeTypeManager().getNodeType(subNode.resource.getDescription());
        }
        catch (RegistryException e) {
            String msg = "failed to resolve the path of the given node or violation of repository syntax " + this;
            log.debug((Object)msg);
            throw new RepositoryException(msg, (Throwable)e);
        }
        return subNode;
    }

    public NodeIterator getNodes() throws RepositoryException {
        ArrayList<Node> nodes = new ArrayList<Node>();
        CollectionImpl tempCollection = null;
        try {
            if (this.registrySession.getUserRegistry().get(this.nodePath) instanceof CollectionImpl) {
                tempCollection = (CollectionImpl)this.registrySession.getUserRegistry().get(this.nodePath);
                String[] children = tempCollection.getChildren();
                for (int i = 0; i < children.length; ++i) {
                    if (!this.isARegistryCollection(children[i]) || RegistryJCRItemOperationUtil.isSystemConfigNode(children[i])) continue;
                    nodes.add(this.registrySession.getNode(children[i]));
                }
            }
        }
        catch (RegistryException e) {
            String msg = "failed to resolve the path of the given node or violation of repository syntax " + this;
            log.debug((Object)msg);
            throw new RepositoryException(msg, (Throwable)e);
        }
        RegistryNodeIterator nodeIterator = new RegistryNodeIterator(nodes);
        return nodeIterator;
    }

    private boolean isARegistryCollection(String path) throws RegistryException {
        return this.registrySession.getUserRegistry().get(path) instanceof CollectionImpl;
    }

    public NodeIterator getNodes(String s) throws RepositoryException {
        ArrayList<Node> nodes = new ArrayList<Node>();
        try {
            CollectionImpl coll = (CollectionImpl)this.registrySession.getUserRegistry().get(this.nodePath);
            String[] childpaths = coll.getChildren();
            for (int i = 0; i < childpaths.length; ++i) {
                if (RegistryJCRItemOperationUtil.isSystemConfigNode(childpaths[i])) continue;
                RegistryNode node = new RegistryNode(childpaths[i], this.registrySession);
                nodes.add(node);
            }
        }
        catch (RegistryException e) {
            String msg = "failed to resolve the path of the given node or violation of repository syntax " + this;
            log.debug((Object)msg);
            throw new RepositoryException(msg, (Throwable)e);
        }
        return new RegistryNodeIterator(nodes);
    }

    public NodeIterator getNodes(String[] strings) throws RepositoryException {
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Property getProperty(String s) throws PathNotFoundException, RepositoryException {
        String absPath;
        String tempPath = absPath = this.nodePath + "/" + s;
        String[] tempArr = tempPath.split("/");
        tempPath = tempPath.substring(0, tempPath.length() - tempArr[tempArr.length - 1].length() - 1);
        RegistryProperty regProp = null;
        String prop = "";
        List propList = null;
        String propName = tempArr[tempArr.length - 1];
        ResourceImpl res = null;
        boolean resFlag = false;
        String propQName = tempArr[tempArr.length - 1];
        try {
            CollectionImpl collecImpl = (CollectionImpl)this.registrySession.getUserRegistry().get(tempPath);
            if (this.registrySession.getUserRegistry().resourceExists(absPath) && this.registrySession.getUserRegistry().get(absPath) != null) {
                res = (ResourceImpl)this.registrySession.getUserRegistry().get(absPath);
                resFlag = true;
            }
            if (!resFlag && this.registrySession.getUserRegistry().resourceExists(tempPath) && this.registrySession.getUserRegistry().get(tempPath) != null) {
                propList = this.registrySession.getUserRegistry().get(tempPath).getPropertyValues(propName);
                if (propList != null && propList.size() == 1 && !this.isSystemMultiValuedProperty(propName)) {
                    prop = (String)propList.get(0);
                    return new RegistryProperty(collecImpl.getPath(), this.registrySession, propQName, prop);
                }
                if (propList == null) throw new PathNotFoundException("No such property exists at given path " + absPath);
                String[] arr = new String[propList.size()];
                int i = 0;
                Iterator iterator = propList.iterator();
                while (iterator.hasNext()) {
                    Object ob = iterator.next();
                    arr[i] = ob.toString();
                    ++i;
                }
                return new RegistryProperty(collecImpl.getPath(), this.registrySession, propQName, arr);
            }
            if (res == null) return regProp;
            if (res.getProperty("registry.jcr.property.type") != null && res.getProperty("registry.jcr.property.type").equals("input_stream")) {
                regProp = new RegistryProperty(res.getPath(), this.registrySession, propQName, res.getContentStream());
                return RegistryJCRItemOperationUtil.getRegistryProperty(res.getProperty("registry.jcr.property.type"), prop, res, propQName, this.registrySession);
            } else if (res.getProperty("registry.jcr.property.type") != null && res.getProperty("registry.jcr.property.type").equals("values_type")) {
                List valuesProp = res.getPropertyValues(propName);
                if (valuesProp == null) return RegistryJCRItemOperationUtil.getRegistryProperty(res.getProperty("registry.jcr.property.type"), prop, res, propQName, this.registrySession);
                boolean i = false;
                Value[] values = new RegistryValue[valuesProp.size()];
                for (int j = 0; j < values.length; ++j) {
                    values[j] = new RegistryValue(valuesProp.get(j));
                }
                regProp = new RegistryProperty(res.getPath(), this.registrySession, propQName, values);
                return RegistryJCRItemOperationUtil.getRegistryProperty(res.getProperty("registry.jcr.property.type"), prop, res, propQName, this.registrySession);
            } else if (res.getContent() instanceof String) {
                prop = res.getContent().toString();
                return RegistryJCRItemOperationUtil.getRegistryProperty(res.getProperty("registry.jcr.property.type"), prop, res, propQName, this.registrySession);
            } else if (res.getContent() instanceof byte[]) {
                prop = RegistryUtils.decodeBytes((byte[])((byte[])res.getContent()));
                return RegistryJCRItemOperationUtil.getRegistryProperty(res.getProperty("registry.jcr.property.type"), prop, res, propQName, this.registrySession);
            } else {
                if (!prop.equals("")) return RegistryJCRItemOperationUtil.getRegistryProperty(res.getProperty("registry.jcr.property.type"), prop, res, propQName, this.registrySession);
                throw new PathNotFoundException();
            }
        }
        catch (RegistryException e) {
            String msg = "failed to resolve the path of the given node or violation of repository syntax " + this;
            log.debug((Object)msg);
            throw new RepositoryException(msg, (Throwable)e);
        }
    }

    private boolean isSystemMultiValuedProperty(String name) {
        return name.equals("jcr:mixinTypes");
    }

    public PropertyIterator getProperties() throws RepositoryException {
        HashSet<String> propNamesList = new HashSet<String>();
        HashSet<Property> properties = new HashSet<Property>();
        Resource resource = null;
        try {
            resource = this.registrySession.getUserRegistry().get(this.nodePath);
            if (resource instanceof org.wso2.carbon.registry.core.Collection) {
                String[] childPaths = ((org.wso2.carbon.registry.core.Collection)resource).getChildren();
                for (int i = 0; i < childPaths.length; ++i) {
                    Resource res = this.registrySession.getUserRegistry().get(childPaths[i]);
                    if (!(res instanceof ResourceImpl) || res.getProperty("registry.jcr.property.type") == null) continue;
                    String[] temp = childPaths[i].split("/");
                    propNamesList.add(temp[temp.length - 1]);
                }
            }
            Properties propyList = resource.getProperties();
            Enumeration<?> en = propyList.propertyNames();
            while (en.hasMoreElements()) {
                String pName = en.nextElement().toString();
                if (pName == null || this.isImplicitProperty(pName)) continue;
                propNamesList.add(pName);
            }
            Iterator it = propNamesList.iterator();
            while (it.hasNext()) {
                properties.add(this.getProperty(it.next().toString()));
            }
        }
        catch (Exception e) {
            String msg = "failed to resolve the path of the given node or violation of repository syntax " + this;
            log.debug((Object)msg);
            throw new RepositoryException(msg, (Throwable)e);
        }
        RegistryPropertyIterator propertyIterator = new RegistryPropertyIterator(properties, this);
        return propertyIterator;
    }

    public PropertyIterator getProperties(String s) throws RepositoryException {
        boolean isMatch = false;
        Properties propyList = this.resource.getProperties();
        Iterator nameIt = this.getCollectionProperties(propyList).iterator();
        HashSet<String> propValList = new HashSet<String>();
        String regex = s + "*";
        String input = "";
        while (nameIt.hasNext()) {
            input = nameIt.next().toString();
            isMatch = Pattern.matches(regex, input);
            propValList.add(this.resource.getProperty(input));
        }
        RegistryPropertyIterator propertyIterator = new RegistryPropertyIterator(propValList, this);
        return propertyIterator;
    }

    public PropertyIterator getProperties(String[] strings) throws RepositoryException {
        boolean isMatch = false;
        Properties propyList = this.resource.getProperties();
        Set propNames = this.getCollectionProperties(propyList);
        Iterator nameIt = propNames.iterator();
        HashSet<String> propValList = new HashSet<String>();
        String[] regex = new String[strings.length];
        String input = "";
        String reg = "";
        while (nameIt.hasNext()) {
            input = nameIt.next().toString();
            for (int i = 0; i < regex.length && !(isMatch = Pattern.matches(reg = regex[i] + "*", input)); ++i) {
            }
            propValList.add(this.resource.getProperty(input));
        }
        RegistryPropertyIterator propertyIterator = new RegistryPropertyIterator(propValList, this);
        return propertyIterator;
    }

    public Item getPrimaryItem() throws ItemNotFoundException, RepositoryException {
        Node item;
        if (this.nodeType.getPrimaryItemName() != null) {
            String name = this.nodeType.getPrimaryItemName();
            try {
                item = this.getNode(name);
            }
            catch (PathNotFoundException e) {
                item = this.addNode(name, this.nodeType.getName());
            }
        } else {
            throw new ItemNotFoundException("Primary item not found ");
        }
        return item;
    }

    public String getUUID() throws UnsupportedRepositoryOperationException, RepositoryException {
        List list = this.resource.getPropertyValues("jcr:mixinTypes");
        if (list != null && list.contains("mix:referenceable")) {
            return this.resource.getProperty("jcr:uuid");
        }
        throw new UnsupportedRepositoryOperationException("To acquire the uuid, the nodetype must have mix:referenceable mixin ");
    }

    public String getIdentifier() throws RepositoryException {
        return this.nodePath;
    }

    public int getIndex() throws RepositoryException {
        return 0;
    }

    public PropertyIterator getReferences() throws RepositoryException {
        return this.getProperties();
    }

    public PropertyIterator getReferences(String s) throws RepositoryException {
        return this.getProperties(s);
    }

    public PropertyIterator getWeakReferences() throws RepositoryException {
        return this.getProperties();
    }

    public PropertyIterator getWeakReferences(String s) throws RepositoryException {
        return this.getProperties(s);
    }

    public boolean hasNode(String s) throws RepositoryException {
        String subnodepath = this.nodePath + s;
        boolean hasNode = false;
        subnodepath = this.nodePath.equals(this.registrySession.getWorkspaceRootPath()) ? this.nodePath + s : this.nodePath + "/" + s;
        try {
            if (this.registrySession.getUserRegistry().resourceExists(subnodepath) && this.registrySession.getUserRegistry().get(subnodepath) instanceof CollectionImpl) {
                hasNode = true;
            }
        }
        catch (RegistryException e) {
            String msg = "failed to resolve the path of the given node or violation of repository syntax " + this;
            log.error((Object)msg, (Throwable)e);
            e.printStackTrace();
            throw new RepositoryException(msg, (Throwable)e);
        }
        return hasNode;
    }

    public boolean hasProperty(String s) throws RepositoryException {
        String absPath;
        boolean hasProperty = false;
        String tempPath = absPath = this.nodePath + "/" + s;
        String[] tempArr = tempPath.split("/");
        tempPath = tempPath.substring(0, tempPath.length() - tempArr[tempArr.length - 1].length() - 1);
        String propName = tempArr[tempArr.length - 1];
        try {
            Resource resource;
            if (this.registrySession.getUserRegistry().resourceExists(tempPath) && (resource = this.registrySession.getUserRegistry().get(tempPath)).getProperty(propName) != null) {
                hasProperty = true;
            }
            if (this.registrySession.getUserRegistry().resourceExists(absPath) && !(this.registrySession.getUserRegistry().get(absPath) instanceof CollectionImpl)) {
                hasProperty = true;
            }
        }
        catch (RegistryException e) {
            String msg = "failed to resolve the path of the given node or violation of repository syntax " + this;
            log.debug((Object)msg);
            throw new RepositoryException(msg, (Throwable)e);
        }
        return hasProperty;
    }

    public boolean hasNodes() throws RepositoryException {
        boolean hasNodes = true;
        CollectionImpl collec = null;
        try {
            String[] children;
            if (this.registrySession.getUserRegistry().resourceExists(this.nodePath) && this.registrySession.getUserRegistry().get(this.nodePath) instanceof CollectionImpl) {
                collec = (CollectionImpl)this.registrySession.getUserRegistry().get(this.nodePath);
            }
            if (collec != null && (children = collec.getChildren()) != null && children.length == 0) {
                hasNodes = false;
            }
        }
        catch (RegistryException e) {
            e.printStackTrace();
        }
        return hasNodes;
    }

    public boolean hasProperties() throws RepositoryException {
        boolean hasProperties = true;
        Resource resource = null;
        try {
            resource = this.registrySession.getUserRegistry().get(this.nodePath);
        }
        catch (RegistryException e) {
            String msg = "failed to resolve the path of the given node or violation of repository syntax " + this;
            log.debug((Object)msg);
            throw new RepositoryException(msg, (Throwable)e);
        }
        Properties propyList = resource.getProperties();
        Set propNames = this.getCollectionProperties(propyList);
        if (propNames.size() == 0) {
            hasProperties = false;
        }
        return hasProperties;
    }

    public NodeType getPrimaryNodeType() throws RepositoryException {
        return this.getNodetype();
    }

    public NodeType[] getMixinNodeTypes() throws RepositoryException {
        ArrayList<NodeType> nodeTypeList = new ArrayList<NodeType>();
        try {
            Resource resource = this.registrySession.getUserRegistry().get(this.nodePath);
            List mixNames = resource.getPropertyValues("jcr:mixinTypes");
            if (mixNames != null) {
                for (String name : mixNames) {
                    NodeType nt = this.registrySession.getWorkspace().getNodeTypeManager().getNodeType(name);
                    nodeTypeList.add(nt);
                }
            }
        }
        catch (RegistryException e) {
            throw new RepositoryException("Error while getting  mix node types from registry " + e.getMessage());
        }
        if (nodeTypeList.size() == 0) {
            return new NodeType[0];
        }
        return nodeTypeList.toArray(new NodeType[0]);
    }

    public boolean isNodeType(String s) throws RepositoryException {
        boolean isNodeType = false;
        if (this.getNodetype().isNodeType(s)) {
            return true;
        }
        return this.resource.getPropertyValues("jcr:mixinTypes") != null && this.resource.getPropertyValues("jcr:mixinTypes").contains(s);
    }

    public void setPrimaryType(String s) throws NoSuchNodeTypeException, VersionException, ConstraintViolationException, LockException, RepositoryException {
        this.registrySession.getWorkspace().getNodeTypeManager().getNodeType(s);
        try {
            Resource resource = this.registrySession.getUserRegistry().get(this.nodePath);
            resource.setProperty("jcr:primaryType", s);
            this.registrySession.getUserRegistry().put(this.nodePath, resource);
        }
        catch (RegistryException e) {
            String msg = "failed to resolve the path of the given node or violation of repository syntax " + this;
            log.debug((Object)msg);
            throw new RepositoryException(msg, (Throwable)e);
        }
    }

    public void addMixin(String s) throws NoSuchNodeTypeException, VersionException, ConstraintViolationException, LockException, RepositoryException {
        try {
            this.registrySession.getWorkspace().getNodeTypeManager().getNodeType(s);
            if (this.resource.getPropertyValues("jcr:mixinTypes") == null) {
                ArrayList<String> list = new ArrayList<String>();
                list.add(s);
                this.resource.setProperty("jcr:mixinTypes", list);
            } else {
                this.resource.getPropertyValues("jcr:mixinTypes").add(s);
            }
            if (s.equals("mix:simpleVersionable") || s.equals("mix:versionable")) {
                this.resource.setProperty("jcr:checkedOut", "true");
                this.resource.setProperty("jcr:isCheckedOut", "true");
            }
            if (s.equals("mix:referenceable")) {
                this.resource.setProperty("jcr:frozenUuid", this.nodePath);
            }
            this.registrySession.getUserRegistry().put(this.nodePath, (Resource)this.resource);
        }
        catch (NoSuchNodeTypeException e) {
            String msg = "No such node type exists " + this;
            log.debug((Object)msg);
            throw new NoSuchNodeTypeException(msg, (Throwable)e);
        }
        catch (RegistryException e) {
            String msg = "failed to resolve the path of the given node or violation of repository syntax " + this;
            log.debug((Object)msg);
            throw new RepositoryException(msg, (Throwable)e);
        }
        this.isModified = true;
    }

    private void validateNTPropertyDefs(String nPath, String nodeType) throws RepositoryException {
    }

    public void removeMixin(String s) throws NoSuchNodeTypeException, VersionException, ConstraintViolationException, LockException, RepositoryException {
        RegistryJCRItemOperationUtil.checkRetentionHold(this.registrySession, this.getPath());
        try {
            Resource resource = this.registrySession.getUserRegistry().get(this.nodePath);
            if (!resource.getPropertyValues("jcr:mixinTypes").contains(s)) {
                throw new NoSuchNodeTypeException("No such mix node type to remove");
            }
            resource.getPropertyValues("jcr:mixinTypes").remove(s);
            this.registrySession.getUserRegistry().put(this.nodePath, resource);
        }
        catch (RegistryException e) {
            String msg = "failed to resolve the path of the given node or violation of repository syntax " + this;
            log.debug((Object)msg);
            throw new RepositoryException(msg, (Throwable)e);
        }
        this.isModified = true;
    }

    public boolean canAddMixin(String s) throws NoSuchNodeTypeException, RepositoryException {
        try {
            this.registrySession.getWorkspace().getNodeTypeManager().getNodeType(s);
        }
        catch (NoSuchNodeTypeException e) {
            throw new NoSuchNodeTypeException("No such mix node type exists " + e.getMessage());
        }
        return true;
    }

    public NodeDefinition getDefinition() throws RepositoryException {
        return new RegistryNodeDefinition();
    }

    public Version checkin() throws VersionException, UnsupportedRepositoryOperationException, InvalidItemStateException, LockException, RepositoryException {
        return this.registrySession.getWorkspace().getVersionManager().checkin(this.nodePath);
    }

    public void checkout() throws UnsupportedRepositoryOperationException, LockException, ActivityViolationException, RepositoryException {
        this.registrySession.getWorkspace().getVersionManager().checkout(this.nodePath);
    }

    public void doneMerge(Version version) throws VersionException, InvalidItemStateException, UnsupportedRepositoryOperationException, RepositoryException {
    }

    public void cancelMerge(Version version) throws VersionException, InvalidItemStateException, UnsupportedRepositoryOperationException, RepositoryException {
    }

    public void update(String s) throws NoSuchWorkspaceException, AccessDeniedException, LockException, InvalidItemStateException, RepositoryException {
        if (!RegistryJCRItemOperationUtil.isWorkspaceExists(this.registrySession, s)) {
            throw new NoSuchWorkspaceException("No such workspace named " + s);
        }
    }

    public NodeIterator merge(String s, boolean b) throws NoSuchWorkspaceException, AccessDeniedException, MergeException, LockException, InvalidItemStateException, RepositoryException {
        return null;
    }

    public String getCorrespondingNodePath(String s) throws ItemNotFoundException, NoSuchWorkspaceException, AccessDeniedException, RepositoryException {
        String npath = null;
        Set sessions = this.registrySession.getRepository().getWorkspaces();
        boolean matchFound = false;
        try {
            for (Object _s : sessions) {
                RegistrySession session = (RegistrySession)_s;
                if (session.getWorkspaceName() == null || !session.getWorkspaceName().equals(s)) continue;
                npath = session.getUserRegistry().get(this.nodePath).getPath();
                matchFound = true;
            }
            if (!matchFound) {
                throw new NoSuchWorkspaceException("There is no such workspace named " + s);
            }
        }
        catch (RegistryException e) {
            throw new RepositoryException("Registry level exception occurred while get corresponding Node Path for " + s);
        }
        return npath;
    }

    public NodeIterator getSharedSet() throws RepositoryException {
        return null;
    }

    public void removeSharedSet() throws VersionException, LockException, ConstraintViolationException, RepositoryException {
    }

    public void removeShare() throws VersionException, LockException, ConstraintViolationException, RepositoryException {
    }

    public boolean isCheckedOut() throws RepositoryException {
        return this.registrySession.getWorkspace().getVersionManager().isCheckedOut(this.nodePath);
    }

    public void restore(String s, boolean b) throws VersionException, ItemExistsException, UnsupportedRepositoryOperationException, LockException, InvalidItemStateException, RepositoryException {
        try {
            this.registrySession.getWorkspace().getVersionManager().restore(this.nodePath, s, true);
        }
        catch (VersionException e) {
            throw new VersionException("No such version in node's version history" + s);
        }
        catch (UnsupportedRepositoryOperationException e) {
            throw new UnsupportedRepositoryOperationException("Node type not Versionable : " + s);
        }
        catch (InvalidItemStateException e) {
            throw new InvalidItemStateException("Invalid Item state: operations are still unsaved");
        }
        catch (RepositoryException e) {
            throw new RepositoryException("Excepion occurred in registry level while restoring");
        }
    }

    public void restore(Version version, boolean b) throws VersionException, ItemExistsException, InvalidItemStateException, UnsupportedRepositoryOperationException, LockException, RepositoryException {
        try {
            this.registrySession.getWorkspace().getVersionManager().restore(this.nodePath, version.getName(), true);
        }
        catch (VersionException e) {
            throw new VersionException("No such version in node's version history");
        }
        catch (UnsupportedRepositoryOperationException e) {
            throw new UnsupportedRepositoryOperationException("Node type not Versionable  ");
        }
        catch (InvalidItemStateException e) {
            throw new InvalidItemStateException("Invalid Item state: operations are still unsaved");
        }
        catch (RepositoryException e) {
            throw new RepositoryException("Excepion occurred in registry level while restoring");
        }
    }

    public void restore(Version version, String s, boolean b) throws PathNotFoundException, ItemExistsException, VersionException, ConstraintViolationException, UnsupportedRepositoryOperationException, LockException, InvalidItemStateException, RepositoryException {
        try {
            this.registrySession.getWorkspace().getVersionManager().restore(this.getNode(s).getPath(), version.getName(), true);
        }
        catch (VersionException e) {
            throw new VersionException("No such version in node's version history" + s);
        }
        catch (UnsupportedRepositoryOperationException e) {
            throw new UnsupportedRepositoryOperationException("Node type not Versionable : " + s);
        }
        catch (InvalidItemStateException e) {
            throw new InvalidItemStateException("Invalid Item state: operations are still unsaved");
        }
        catch (RepositoryException e) {
            throw new RepositoryException("Excepion occurred in registry level while restoring");
        }
    }

    public void restoreByLabel(String s, boolean b) throws VersionException, ItemExistsException, UnsupportedRepositoryOperationException, LockException, InvalidItemStateException, RepositoryException {
        this.registrySession.getWorkspace().getVersionManager().restoreByLabel(this.nodePath, s, true);
    }

    public VersionHistory getVersionHistory() throws UnsupportedRepositoryOperationException, RepositoryException {
        return this.registrySession.getWorkspace().getVersionManager().getVersionHistory(this.nodePath);
    }

    public Version getBaseVersion() throws UnsupportedRepositoryOperationException, RepositoryException {
        return this.registrySession.getWorkspace().getVersionManager().getBaseVersion(this.nodePath);
    }

    public Lock lock(boolean b, boolean b1) throws UnsupportedRepositoryOperationException, LockException, AccessDeniedException, InvalidItemStateException, RepositoryException {
        return this.registrySession.getWorkspace().getLockManager().lock(this.nodePath, b, b1, 10L, this.getName());
    }

    public Lock getLock() throws UnsupportedRepositoryOperationException, LockException, AccessDeniedException, RepositoryException {
        return this.registrySession.getWorkspace().getLockManager().getLock(this.nodePath);
    }

    public void unlock() throws UnsupportedRepositoryOperationException, LockException, AccessDeniedException, InvalidItemStateException, RepositoryException {
        new RegistryLockManager(this.registrySession).unlock(this.nodePath);
    }

    public boolean holdsLock() throws RepositoryException {
        return this.registrySession.getWorkspace().getLockManager().holdsLock(this.nodePath);
    }

    public boolean isLocked() throws RepositoryException {
        return this.registrySession.getWorkspace().getLockManager().isLocked(this.nodePath);
    }

    public void followLifecycleTransition(String s) throws UnsupportedRepositoryOperationException, InvalidLifecycleTransitionException, RepositoryException {
    }

    public String[] getAllowedLifecycleTransistions() throws UnsupportedRepositoryOperationException, RepositoryException {
        return new String[0];
    }

    public String getPath() throws RepositoryException {
        return this.nodePath;
    }

    public String getName() throws RepositoryException {
        String[] nodeName = this.nodePath.split("/");
        int nameIndex = nodeName.length - 1;
        return nodeName[nameIndex];
    }

    public Item getAncestor(int i) throws ItemNotFoundException, AccessDeniedException, RepositoryException {
        return this.registrySession.getItem(RegistryJCRItemOperationUtil.getAncestorPathAtGivenDepth(this.registrySession, this.getPath(), i));
    }

    public Node getParent() throws ItemNotFoundException, AccessDeniedException, RepositoryException {
        Node par = null;
        String parent = "";
        try {
            if (this.isNodeRoot()) {
                throw new ItemNotFoundException("Node is already root: " + this.nodePath);
            }
            if (!this.registrySession.getUserRegistry().resourceExists(this.nodePath)) {
                throw new InvalidItemStateException();
            }
            parent = ((CollectionImpl)this.registrySession.getUserRegistry().get(this.nodePath)).getParentPath();
            par = (Node)this.registrySession.getItem(parent);
        }
        catch (RegistryException e) {
            e.printStackTrace();
        }
        catch (InvalidItemStateException e) {
            throw new InvalidItemStateException();
        }
        return par;
    }

    private boolean isNodeRoot() throws RegistryException {
        String tmp = this.nodePath;
        if (!tmp.endsWith("/")) {
            tmp = tmp + "/";
        }
        return tmp.equals(this.registrySession.getWorkspaceRootPath());
    }

    public int getDepth() throws RepositoryException {
        if (this.nodePath.equals(this.registrySession.getWorkspaceRootPath())) {
            return 0;
        }
        return this.nodePath.split("/").length - 4;
    }

    public RegistrySession getSession() throws RepositoryException {
        return this.registrySession;
    }

    public boolean isNode() {
        return true;
    }

    public boolean isNew() {
        boolean isNew = false;
        try {
            if (this.resource != null) {
                isNew = !(this.resource instanceof Collection) || this.resource.getChildren() != null && this.resource.getChildren().length == 0;
            }
        }
        catch (Exception e) {
            isNew = true;
        }
        return isNew;
    }

    public boolean isModified() {
        return this.isModified;
    }

    public boolean isSame(Item item) throws RepositoryException {
        return this.nodePath.equals(item.getPath());
    }

    public void accept(ItemVisitor itemVisitor) throws RepositoryException {
    }

    public void save() throws AccessDeniedException, ItemExistsException, ConstraintViolationException, InvalidItemStateException, ReferentialIntegrityException, VersionException, LockException, NoSuchNodeTypeException, RepositoryException {
        try {
            if (!this.registrySession.getUserRegistry().resourceExists(this.nodePath)) {
                throw new InvalidItemStateException("Unable to save the node at" + this.nodePath);
            }
        }
        catch (RegistryException e) {
            e.printStackTrace();
        }
    }

    public void refresh(boolean b) throws InvalidItemStateException, RepositoryException {
        try {
            if (!this.registrySession.getUserRegistry().resourceExists(this.nodePath)) {
                throw new InvalidItemStateException("Cannot refresh on non existing nodes ..!! ");
            }
        }
        catch (RegistryException e) {
            throw new RepositoryException("Problem occurred while refresh on node " + this.nodePath);
        }
    }

    public void remove() throws VersionException, LockException, ConstraintViolationException, AccessDeniedException, RepositoryException {
        RegistryJCRItemOperationUtil.validateReadOnlyItemOpr(this.registrySession);
        try {
            RegistryJCRItemOperationUtil.checkRetentionPolicyWithParent(this.registrySession, this.getPath());
            RegistryJCRItemOperationUtil.checkRetentionHoldWithParent(this.registrySession, this.getPath());
            if (!this.registrySession.getUserRegistry().resourceExists(this.nodePath)) {
                throw new InvalidItemStateException("Node " + this.nodePath + " has already removed from another session");
            }
            this.registrySession.removeItem(this.nodePath);
        }
        catch (RegistryException e) {
            log.error((Object)("Error occured while removing the node at" + this.nodePath));
        }
        this.isRemoved = true;
    }

    private boolean isImplicitProperty(String s) {
        return s != null && RegistryJCRSpecificStandardLoderUtil.getimplicitPropertiyNames().contains(s);
    }

    private Set getCollectionProperties(Properties propyList) {
        HashSet<String> propNamesList = new HashSet<String>();
        Enumeration<?> en = propyList.propertyNames();
        while (en.hasMoreElements()) {
            String pName = en.nextElement().toString();
            if (pName == null || this.isImplicitProperty(pName)) continue;
            propNamesList.add(pName);
        }
        return propNamesList;
    }
}

