/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.jcr;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import javax.jcr.AccessDeniedException;
import javax.jcr.Binary;
import javax.jcr.InvalidItemStateException;
import javax.jcr.Item;
import javax.jcr.ItemExistsException;
import javax.jcr.ItemNotFoundException;
import javax.jcr.ItemVisitor;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.ReferentialIntegrityException;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.ValueFormatException;
import javax.jcr.lock.LockException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import javax.jcr.nodetype.PropertyDefinition;
import javax.jcr.version.VersionException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.registry.core.CollectionImpl;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.jcr.RegistryNode;
import org.wso2.carbon.registry.jcr.RegistrySession;
import org.wso2.carbon.registry.jcr.RegistryValue;
import org.wso2.carbon.registry.jcr.nodetype.RegistryPropertyDefinition;
import org.wso2.carbon.registry.jcr.util.RegistryJCRItemOperationUtil;
import org.wso2.carbon.registry.jcr.util.RegistryJCRSpecificStandardLoderUtil;

public class RegistryProperty
implements Property {
    RegistryValue value;
    Value[] values;
    String[] stringMultipleVals;
    private String name;
    private RegistrySession session;
    private boolean isResource = false;
    private static Log log = LogFactory.getLog(RegistryNode.class);
    private String path = "";

    public RegistryProperty(RegistryNode node, String name) {
        this.name = name;
    }

    public RegistryProperty(String path, RegistrySession session, String name, String value) {
        this.path = path;
        this.session = session;
        this.name = name;
        this.setQValue(value);
    }

    public RegistryProperty(String path, RegistrySession session, String name, String[] values) {
        this.path = path;
        this.session = session;
        this.name = name;
        this.setQValue(values);
    }

    public RegistryProperty(String path, RegistrySession session, String name, Node node) {
        this.path = path;
        this.session = session;
        this.name = name;
        this.setQValue(node);
    }

    public RegistryProperty(String path, RegistrySession session, String name, Binary binary) {
        this.path = path;
        this.session = session;
        this.name = name;
        this.setQValue(binary);
    }

    public RegistryProperty(String path, RegistrySession session, String name, BigDecimal bg) {
        this.isResource = true;
        this.path = path;
        this.session = session;
        this.name = name;
        this.setQValue(bg);
    }

    public RegistryProperty(String path, RegistrySession session, String name, Calendar calendar) {
        this.isResource = true;
        this.path = path;
        this.session = session;
        this.name = name;
        this.setQValue(calendar);
    }

    public RegistryProperty(String path, RegistrySession session, String name, InputStream inputStream) {
        this.isResource = true;
        this.path = path;
        this.session = session;
        this.name = name;
        this.setQValue(inputStream);
    }

    public RegistryProperty(String path, RegistrySession session, String name, Value val) {
        this.isResource = true;
        this.path = path;
        this.session = session;
        this.name = name;
        this.setQValue(val);
    }

    public RegistryProperty(String path, RegistrySession session, String name, Value[] vals) {
        this.isResource = true;
        this.path = path;
        this.session = session;
        this.name = name;
        this.setQValue(vals);
    }

    public RegistryProperty(String path, RegistrySession session, String name, boolean val) {
        this.isResource = true;
        this.path = path;
        this.session = session;
        this.name = name;
        this.setQValue(val);
    }

    public RegistryProperty(String path, RegistrySession session, String name, double val) {
        this.isResource = true;
        this.path = path;
        this.session = session;
        this.name = name;
        this.setQValue(val);
    }

    public RegistryProperty(String path, RegistrySession session, String name, long val) {
        this.isResource = true;
        this.path = path;
        this.session = session;
        this.name = name;
        this.setQValue(val);
    }

    private void validatePropertyModifyPrivilege() throws RepositoryException {
        if (RegistryJCRSpecificStandardLoderUtil.isSessionReadOnly(this.session.getUserID())) {
            throw new AccessDeniedException("A read only session must not be allowed to modify a property value");
        }
    }

    public void setValue(Value value) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        RegistryJCRItemOperationUtil.checkRetentionPolicy(this.session, this.getPath());
        this.validatePropertyModifyPrivilege();
        if (value != null) {
            this.value = (RegistryValue)value;
            this.persistNewPropertyValue("value", value);
        } else {
            this.remove();
        }
    }

    public void setQValue(Value value) {
        if (value != null) {
            this.value = (RegistryValue)value;
        } else {
            try {
                this.remove();
            }
            catch (RepositoryException e) {
                log.error((Object)"Error occur while removing the value ");
            }
        }
    }

    public void setValue(Value[] values) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        RegistryJCRItemOperationUtil.checkRetentionPolicy(this.session, this.getNodePath());
        RegistryJCRItemOperationUtil.checkRetentionHold(this.session, this.getNodePath());
        this.validatePropertyModifyPrivilege();
        if (values != null) {
            this.values = Arrays.copyOf(values, values.length);
            this.setValuesToProperty(values);
        } else {
            this.remove();
        }
    }

    public void setQValue(Value[] values) {
        if (values != null) {
            this.values = Arrays.copyOf(values, values.length);
        } else {
            try {
                this.remove();
            }
            catch (RepositoryException e) {
                log.error((Object)"Error occur while removing the value ");
            }
        }
    }

    public void setValue(String s) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        RegistryJCRItemOperationUtil.checkRetentionPolicy(this.session, this.getNodePath());
        RegistryJCRItemOperationUtil.checkRetentionHold(this.session, this.getNodePath());
        this.validatePropertyModifyPrivilege();
        this.value = new RegistryValue(s);
        this.persistNewPropertyValue("string", s);
    }

    private void setQValue(String s) {
        this.value = new RegistryValue(s);
    }

    public void setValue(String[] strings) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        RegistryJCRItemOperationUtil.checkRetentionPolicy(this.session, this.getNodePath());
        this.validatePropertyModifyPrivilege();
        this.stringMultipleVals = (String[])strings.clone();
        this.values = new RegistryValue[strings.length];
        int i = 0;
        for (String s : strings) {
            this.values[i] = new RegistryValue(s);
            ++i;
        }
        RegistryJCRItemOperationUtil.persistStringPropertyValues(this.session, this.path, this.name, strings);
    }

    private void setQValue(String[] strings) {
        this.stringMultipleVals = (String[])strings.clone();
        this.values = new RegistryValue[strings.length];
        int i = 0;
        for (String s : strings) {
            this.values[i] = new RegistryValue(s);
            ++i;
        }
    }

    public void setValue(InputStream inputStream) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        RegistryJCRItemOperationUtil.checkRetentionPolicy(this.session, this.getNodePath());
        RegistryJCRItemOperationUtil.checkRetentionHold(this.session, this.getNodePath());
        this.validatePropertyModifyPrivilege();
        this.value = new RegistryValue(inputStream);
        this.persistNewPropertyValue("is", inputStream);
    }

    private void setQValue(InputStream inputStream) {
        this.value = new RegistryValue(inputStream);
    }

    public void setValue(Binary binary) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        RegistryJCRItemOperationUtil.checkRetentionPolicy(this.session, this.getNodePath());
        RegistryJCRItemOperationUtil.checkRetentionHold(this.session, this.getNodePath());
        this.validatePropertyModifyPrivilege();
        this.value = new RegistryValue(binary);
    }

    private void setQValue(Binary binary) {
        this.value = new RegistryValue(binary);
    }

    public void setValue(long l) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        RegistryJCRItemOperationUtil.checkRetentionPolicy(this.session, this.getNodePath());
        RegistryJCRItemOperationUtil.checkRetentionHold(this.session, this.getNodePath());
        this.validatePropertyModifyPrivilege();
        this.value = new RegistryValue(l);
        this.persistNewPropertyValue("long", new Long(l));
    }

    private void setQValue(long l) {
        this.value = new RegistryValue(l);
    }

    public void setValue(double v) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        RegistryJCRItemOperationUtil.checkRetentionPolicy(this.session, this.getNodePath());
        RegistryJCRItemOperationUtil.checkRetentionHold(this.session, this.getNodePath());
        this.validatePropertyModifyPrivilege();
        this.value = new RegistryValue(v);
        this.persistNewPropertyValue("double", new Double(v));
    }

    private void setQValue(double v) {
        this.value = new RegistryValue(v);
    }

    public void setValue(BigDecimal bigDecimal) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        RegistryJCRItemOperationUtil.checkRetentionPolicy(this.session, this.getNodePath());
        RegistryJCRItemOperationUtil.checkRetentionHold(this.session, this.getNodePath());
        this.validatePropertyModifyPrivilege();
        this.value = new RegistryValue(bigDecimal);
        this.persistNewPropertyValue("big_d", bigDecimal);
    }

    private void setQValue(BigDecimal bigDecimal) {
        this.value = new RegistryValue(bigDecimal);
    }

    public void setValue(Calendar calendar) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        RegistryJCRItemOperationUtil.checkRetentionPolicy(this.session, this.getNodePath());
        RegistryJCRItemOperationUtil.checkRetentionHold(this.session, this.getNodePath());
        this.validatePropertyModifyPrivilege();
        if (calendar != null) {
            this.value = new RegistryValue(calendar);
        }
        this.persistNewPropertyValue("calendar", calendar);
    }

    private void setQValue(Calendar calendar) {
        if (calendar != null) {
            this.value = new RegistryValue(calendar);
        }
    }

    public void setValue(boolean b) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        RegistryJCRItemOperationUtil.checkRetentionPolicy(this.session, this.getNodePath());
        RegistryJCRItemOperationUtil.checkRetentionHold(this.session, this.getNodePath());
        this.validatePropertyModifyPrivilege();
        this.value = new RegistryValue(b);
        this.persistNewPropertyValue("boolean", String.valueOf(b));
    }

    private void setQValue(boolean b) {
        this.value = new RegistryValue(b);
    }

    public void setValue(Node node) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        RegistryJCRItemOperationUtil.checkRetentionPolicy(this.session, this.getNodePath());
        RegistryJCRItemOperationUtil.checkRetentionHold(this.session, this.getNodePath());
        this.validatePropertyModifyPrivilege();
        this.value = new RegistryValue(node);
    }

    private void setQValue(Node node) {
        this.value = new RegistryValue(node);
    }

    public Value getValue() throws ValueFormatException, RepositoryException {
        return this.value;
    }

    public Value[] getValues() throws ValueFormatException, RepositoryException {
        if (this.values != null) {
            return Arrays.copyOf(this.values, this.values.length);
        }
        throw new ValueFormatException("Invalid operation getValues for a single valued property");
    }

    public String getString() throws ValueFormatException, RepositoryException {
        if (this.value != null) {
            return this.value.getString();
        }
        return "";
    }

    public InputStream getStream() throws ValueFormatException, RepositoryException {
        if (this.value != null) {
            return this.value.getStream();
        }
        return new ByteArrayInputStream(new byte[]{12, 12, 22});
    }

    public Binary getBinary() throws ValueFormatException, RepositoryException {
        if (this.value != null) {
            return this.value.getBinary();
        }
        return null;
    }

    public long getLong() throws ValueFormatException, RepositoryException {
        if (this.value != null) {
            return this.value.getLong();
        }
        return 0L;
    }

    public double getDouble() throws ValueFormatException, RepositoryException {
        if (this.value != null) {
            return this.value.getDouble();
        }
        return 0.0;
    }

    public BigDecimal getDecimal() throws ValueFormatException, RepositoryException {
        if (this.value != null) {
            return this.value.getDecimal();
        }
        return new BigDecimal(0);
    }

    public Calendar getDate() throws ValueFormatException, RepositoryException {
        if (this.value != null) {
            return this.value.getDate();
        }
        return null;
    }

    public boolean getBoolean() throws ValueFormatException, RepositoryException {
        if (this.value != null) {
            return this.value.getBoolean();
        }
        return false;
    }

    public Node getNode() throws ItemNotFoundException, ValueFormatException, RepositoryException {
        if (this.value != null) {
            return this.value.getNode();
        }
        return null;
    }

    public Property getProperty() throws ItemNotFoundException, ValueFormatException, RepositoryException {
        return this;
    }

    public long getLength() throws ValueFormatException, RepositoryException {
        long length = 0L;
        if (this.value != null) {
            length = this.value.toString().length();
        }
        return length;
    }

    public long[] getLengths() throws ValueFormatException, RepositoryException {
        long[] lengths = new long[this.values.length];
        for (int i = 0; i < this.values.length; ++i) {
            lengths[i] = this.values[i].toString().length();
        }
        return lengths;
    }

    public PropertyDefinition getDefinition() throws RepositoryException {
        return new RegistryPropertyDefinition();
    }

    public int getType() throws RepositoryException {
        if (this.value != null) {
            return this.value.getType();
        }
        if (this.values != null) {
            return this.values[0].getType();
        }
        throw new RepositoryException("No such type for the property at " + this.path);
    }

    public boolean isMultiple() throws RepositoryException {
        boolean isMul = false;
        if (this.value != null) {
            isMul = false;
        } else if (this.values != null) {
            isMul = true;
        }
        return isMul;
    }

    public String getPath() throws RepositoryException {
        return this.path;
    }

    public String getName() throws RepositoryException {
        return this.name;
    }

    public Item getAncestor(int i) throws ItemNotFoundException, AccessDeniedException, RepositoryException {
        return this.session.getItem(RegistryJCRItemOperationUtil.getAncestorPathAtGivenDepth(this.session, this.getPath(), i));
    }

    public Node getParent() throws ItemNotFoundException, AccessDeniedException, RepositoryException {
        String parent = "";
        if (this.isResource) {
            try {
                parent = this.session.getUserRegistry().get(this.path).getParentPath();
            }
            catch (RegistryException e) {
                log.error((Object)("Registry Exception occurred while obtaining " + this.path));
            }
        } else {
            parent = this.path;
        }
        return (Node)this.session.getItem(parent);
    }

    public int getDepth() throws RepositoryException {
        if (this.getPath().equals("/")) {
            return 0;
        }
        return this.getPath().split("/").length - 4;
    }

    public RegistrySession getSession() throws RepositoryException {
        return this.session;
    }

    public boolean isNode() {
        Object propType;
        boolean isNode = false;
        if (this.value != null && (propType = this.value.getKey()) instanceof Node) {
            isNode = true;
        }
        return isNode;
    }

    public boolean isNew() {
        boolean isNew = false;
        if (this.value != null && this.stringMultipleVals != null && this.values == null) {
            isNew = true;
        }
        return isNew;
    }

    public boolean isModified() {
        return this.isPropertyResourceModified();
    }

    private boolean isPropertyResourceModified() {
        boolean isModified = true;
        try {
            Resource resource = this.session.getUserRegistry().get(this.path);
            if (!this.isResource) {
                isModified = ((CollectionImpl)resource).isPropertiesModified();
            }
        }
        catch (RegistryException e) {
            log.error((Object)("Registry exception occurred while checking content modification " + (Object)((Object)e)));
        }
        return isModified;
    }

    public boolean isSame(Item item) throws RepositoryException {
        boolean isSame = false;
        if (this.name.equals(item.getName())) {
            isSame = true;
        }
        return isSame;
    }

    public void accept(ItemVisitor itemVisitor) throws RepositoryException {
    }

    public void save() throws AccessDeniedException, ItemExistsException, ConstraintViolationException, InvalidItemStateException, ReferentialIntegrityException, VersionException, LockException, NoSuchNodeTypeException, RepositoryException {
    }

    public void refresh(boolean b) throws InvalidItemStateException, RepositoryException {
    }

    public void remove() throws VersionException, LockException, ConstraintViolationException, AccessDeniedException, RepositoryException {
        RegistryJCRItemOperationUtil.validateReadOnlyItemOpr(this.session);
        RegistryJCRItemOperationUtil.checkRetentionPolicy(this.session, this.getNodePath());
        RegistryJCRItemOperationUtil.checkRetentionHold(this.session, this.getNodePath());
        try {
            if (this.isResource) {
                this.session.getUserRegistry().delete(this.path);
            } else {
                Resource node = this.session.getUserRegistry().get(this.path);
                node.removeProperty(this.name);
                this.session.getUserRegistry().put(this.path, node);
            }
        }
        catch (RegistryException e) {
            String msg = "failed to remove the property " + this;
            log.debug((Object)msg);
            throw new RepositoryException(msg, (Throwable)e);
        }
    }

    private String getNodePath() throws RepositoryException {
        if (this.isResource) {
            try {
                return this.session.getUserRegistry().get(this.path).getParentPath();
            }
            catch (RegistryException e) {
                throw new RepositoryException("Registry level Exception occurred, cannot obtain parent path of " + this.path);
            }
        }
        return this.path;
    }

    private void persistNewPropertyValue(String type, Object value) throws RepositoryException {
        try {
            Resource property = this.isResource ? this.session.getUserRegistry().get(this.path) : this.session.getUserRegistry().get(this.path);
            if (type.equals("value")) {
                property.setContent((Object)((Value)value).getString());
            } else if (type.equals("string")) {
                property.setProperty(this.name, value.toString());
            } else if (type.equals("is")) {
                property.setContentStream((InputStream)value);
            } else if (type.equals("long")) {
                property.setContent((Object)String.valueOf((Long)value));
            } else if (type.equals("double")) {
                property.setContent((Object)String.valueOf((Double)value));
            } else if (type.equals("big_d")) {
                property.setContent((Object)((BigDecimal)value).toString());
            } else if (type.equals("calendar")) {
                property.setContent((Object)String.valueOf(((Calendar)value).getTimeInMillis()));
            } else if (type.equals("boolean")) {
                property.setContent((Object)String.valueOf(value.toString()));
            }
            this.session.getUserRegistry().put(this.path, property);
        }
        catch (RegistryException e) {
            throw new RepositoryException("Registry level exception occurred while setting value for " + this.path + e.getMessage());
        }
        catch (ValueFormatException e) {
            throw new ValueFormatException(e.getMessage());
        }
        catch (RepositoryException e) {
            throw new RepositoryException(e.getMessage());
        }
    }

    private void setValuesToProperty(Value[] values) throws RepositoryException {
        Resource resource = null;
        try {
            resource = this.session.getUserRegistry().get(this.path);
            ArrayList<String> properties = new ArrayList<String>();
            if (values != null) {
                for (Value val : values) {
                    if (val == null) continue;
                    properties.add(val.getString());
                }
                resource.setProperty(this.name, properties);
            }
            this.session.getUserRegistry().put(this.path, resource);
        }
        catch (RegistryException e) {
            throw new RepositoryException("Registry level exception occurred while setting values[] for " + this.path);
        }
    }
}

