/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.jcr;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.AccessControlException;
import java.util.Collection;
import javax.jcr.AccessDeniedException;
import javax.jcr.Credentials;
import javax.jcr.InvalidItemStateException;
import javax.jcr.InvalidSerializedDataException;
import javax.jcr.Item;
import javax.jcr.ItemExistsException;
import javax.jcr.ItemNotFoundException;
import javax.jcr.LoginException;
import javax.jcr.NamespaceException;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.ReferentialIntegrityException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.ValueFactory;
import javax.jcr.lock.LockException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import javax.jcr.retention.RetentionManager;
import javax.jcr.retention.RetentionPolicy;
import javax.jcr.security.AccessControlManager;
import javax.jcr.version.VersionException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.registry.core.CollectionImpl;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.ResourceImpl;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.session.UserRegistry;
import org.wso2.carbon.registry.jcr.RegistryNode;
import org.wso2.carbon.registry.jcr.RegistryRepository;
import org.wso2.carbon.registry.jcr.RegistrySimpleCredentials;
import org.wso2.carbon.registry.jcr.RegistryValueFactory;
import org.wso2.carbon.registry.jcr.RegistryWorkspace;
import org.wso2.carbon.registry.jcr.nodetype.RegistryNodeType;
import org.wso2.carbon.registry.jcr.retention.RegistryRetentionManager;
import org.wso2.carbon.registry.jcr.retention.RegistryRetentionPolicy;
import org.wso2.carbon.registry.jcr.security.RegistryAccessControlManager;
import org.wso2.carbon.registry.jcr.util.RegistryJCRItemOperationUtil;
import org.wso2.carbon.registry.jcr.util.RegistryJCRSpecificStandardLoderUtil;
import org.wso2.carbon.registry.jcr.util.security.PrivilegeRegistry;
import org.wso2.carbon.registry.jcr.util.test.data.TCKTestDataLoader;
import org.wso2.carbon.user.core.UserStoreException;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class RegistrySession
implements Session {
    public UserRegistry userRegistry;
    private RegistrySimpleCredentials registrySimpleCredentials;
    private String workspaceName = "";
    private RegistryWorkspace registryWorkspace;
    private AccessControlManager regAccControlMngr;
    private RetentionManager regRetentionMngr;
    private RegistryRepository registryRepository;
    private String WORKSPACE_ROOT = "";
    private static Log log = LogFactory.getLog(RegistrySession.class);
    private String USER_ID = "";
    private boolean SESSION_SAVED = true;

    public void sessionPending() {
        this.SESSION_SAVED = false;
    }

    public void sessionSaved() {
        this.SESSION_SAVED = true;
    }

    public boolean isSessionSaved() {
        return this.SESSION_SAVED;
    }

    public RegistrySession(RegistryRepository registryRepository, String workspaceName, RegistrySimpleCredentials registrySimpleCredentials, UserRegistry userReg, String userID) throws RepositoryException {
        this.workspaceName = workspaceName;
        this.USER_ID = userID;
        this.WORKSPACE_ROOT = RegistryJCRSpecificStandardLoderUtil.getJCRRegistryWorkspaceRoot() + "/" + this.workspaceName + "/";
        this.registryRepository = registryRepository;
        this.userRegistry = userReg;
        this.createRootNode();
        this.loadJCRSystemConfiguration(this.userRegistry, this.WORKSPACE_ROOT);
        this.registrySimpleCredentials = registrySimpleCredentials;
        this.registryWorkspace = new RegistryWorkspace(registrySimpleCredentials.getUserID(), this);
        this.regAccControlMngr = new RegistryAccessControlManager(this);
        this.regRetentionMngr = new RegistryRetentionManager(this);
    }

    public RegistrySession(RegistryRepository registryRepository, String workspaceName, UserRegistry userReg, String userID) throws RepositoryException {
        this.workspaceName = workspaceName;
        this.USER_ID = userID;
        this.WORKSPACE_ROOT = RegistryJCRSpecificStandardLoderUtil.getJCRRegistryWorkspaceRoot() + "/" + this.workspaceName + "/";
        this.registryRepository = registryRepository;
        this.userRegistry = userReg;
        this.createRootNode();
        this.loadJCRSystemConfiguration(this.userRegistry, this.WORKSPACE_ROOT);
        this.registryWorkspace = new RegistryWorkspace(this);
        this.regAccControlMngr = new RegistryAccessControlManager(this);
        this.regRetentionMngr = new RegistryRetentionManager(this);
    }

    public RegistrySession(RegistryRepository registryRepository, UserRegistry userReg, String userID) throws RepositoryException {
        this.USER_ID = userID;
        this.WORKSPACE_ROOT = RegistryJCRSpecificStandardLoderUtil.getJCRRegistryWorkspaceRoot() + "/" + this.workspaceName + "/";
        this.registryRepository = registryRepository;
        this.userRegistry = userReg;
        this.createRootNode();
        this.loadJCRSystemConfiguration(this.userRegistry, this.WORKSPACE_ROOT);
        this.registryWorkspace = new RegistryWorkspace(this);
        this.regAccControlMngr = new RegistryAccessControlManager(this);
        this.regRetentionMngr = new RegistryRetentionManager(this);
    }

    public String getWorkspaceRootPath() {
        return this.WORKSPACE_ROOT;
    }

    private void loadJCRSystemConfiguration(UserRegistry userReg, String workspaceRoot) throws RepositoryException {
        try {
            RegistryJCRSpecificStandardLoderUtil.loadJCRSystemConfigs(userReg, workspaceRoot);
        }
        catch (RegistryException e) {
            e.printStackTrace();
        }
    }

    private void createRootNode() throws RepositoryException {
        try {
            CollectionImpl resource;
            if (!this.userRegistry.resourceExists(RegistryJCRSpecificStandardLoderUtil.getJCRRegistryWorkspaceRoot())) {
                resource = (CollectionImpl)this.userRegistry.newCollection();
                this.userRegistry.put(RegistryJCRSpecificStandardLoderUtil.getJCRRegistryWorkspaceRoot(), (Resource)resource);
            }
            if (!this.userRegistry.resourceExists(this.WORKSPACE_ROOT)) {
                resource = (CollectionImpl)this.userRegistry.newCollection();
                resource.setDescription("nt:base");
                resource.setProperty("jcr:primaryType", "nt:base");
                this.userRegistry.put(this.WORKSPACE_ROOT, (Resource)resource);
            }
        }
        catch (RegistryException e) {
            throw new RepositoryException("Registry Exception occurred while creating root node " + e.getMessage());
        }
    }

    private void addLoggedinWorkSpace(RegistryWorkspace registryWorkspace) {
    }

    public UserRegistry getUserRegistry() {
        return this.userRegistry;
    }

    public String getWorkspaceName() {
        return this.workspaceName;
    }

    public RegistryRepository getRepository() {
        return this.registryRepository;
    }

    public String getUserID() {
        return this.USER_ID;
    }

    public String[] getAttributeNames() {
        return this.registrySimpleCredentials.getAttributeNames();
    }

    public Object getAttribute(String s) {
        return this.registrySimpleCredentials.getAttribute(s);
    }

    public RegistryWorkspace getWorkspace() {
        return this.registryWorkspace;
    }

    public Node getRootNode() throws RepositoryException {
        return this.getNode(this.WORKSPACE_ROOT);
    }

    public Session impersonate(Credentials credentials) throws LoginException, RepositoryException {
        return this.registryRepository.login(credentials);
    }

    public Node getNodeByUUID(String s) throws ItemNotFoundException, RepositoryException {
        return null;
    }

    public Node getNodeByIdentifier(String s) throws ItemNotFoundException, RepositoryException {
        return this.getNode(s);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Item getItem(String s) throws PathNotFoundException, RepositoryException {
        if (!s.contains(this.getWorkspaceRootPath())) {
            s = this.getWorkspaceRootPath().substring(0, this.getWorkspaceRootPath().length() - 1) + s;
        }
        Node anItem = null;
        Object collection = null;
        String[] tempArr = null;
        String tempPath = s;
        if (tempPath.contains("[")) {
            tempPath = tempPath.substring(1, tempPath.length() - 1);
        }
        if (s.contains("[")) {
            s = s.substring(1, s.length() - 1);
        }
        if (tempPath == null) throw new PathNotFoundException("Item does not exists at path " + s);
        if (!tempPath.contains("/")) throw new PathNotFoundException("Item does not exists at path " + s);
        tempArr = tempPath.split("/");
        tempPath = tempPath.substring(0, tempPath.length() - tempArr[tempArr.length - 1].length() - 1);
        try {
            if (this.userRegistry.resourceExists(s)) {
                if (this.userRegistry.get(s) instanceof CollectionImpl) {
                    return this.getNode(s);
                }
                if (!(this.userRegistry.get(s) instanceof ResourceImpl)) return anItem;
                return this.getNode(tempPath).getProperty(tempArr[tempArr.length - 1]);
            }
            if (!this.userRegistry.resourceExists(tempPath)) throw new PathNotFoundException("Item does not exists at path " + s);
            return this.getNode(tempPath).getProperty(tempArr[tempArr.length - 1]);
        }
        catch (RegistryException e) {
            String msg = "failed to resolve the path of the given item " + this;
            log.debug((Object)msg);
            throw new PathNotFoundException(msg, (Throwable)e);
        }
    }

    public Node getNode(String s) throws PathNotFoundException, RepositoryException {
        RegistryNode subNode = null;
        try {
            if (!this.getUserRegistry().resourceExists(s)) {
                throw new PathNotFoundException("failed to resolve the path of the given node");
            }
            subNode = new RegistryNode(s, this);
            subNode.setCollection(s);
            subNode.nodeType = (RegistryNodeType)this.getWorkspace().getNodeTypeManager().getNodeType(subNode.resource.getDescription());
        }
        catch (RegistryException e) {
            String msg = "failed to resolve the path of the given node or violation of repository syntax " + this;
            log.debug((Object)msg);
            throw new RepositoryException(msg, (Throwable)e);
        }
        return subNode;
    }

    public Property getProperty(String s) throws PathNotFoundException, RepositoryException {
        String tempPath = s;
        String[] tempArr = tempPath.split("/");
        tempPath = tempPath.substring(0, tempPath.length() - tempArr[tempArr.length - 1].length() - 1);
        String propName = tempArr[tempArr.length - 1];
        Item item = this.getItem(tempPath);
        return ((Node)item).getProperty(propName);
    }

    public boolean itemExists(String s) throws RepositoryException {
        boolean itemEx = true;
        try {
            itemEx = this.userRegistry.resourceExists(s);
        }
        catch (RegistryException e) {
            e.printStackTrace();
        }
        return itemEx;
    }

    public boolean nodeExists(String s) throws RepositoryException {
        boolean nodeEx = false;
        try {
            if (this.userRegistry != null && this.userRegistry.resourceExists(s)) {
                nodeEx = true;
            }
        }
        catch (RegistryException e) {
            String msg = "failed to resolve the path of the given node " + this;
            log.debug((Object)msg);
            throw new RepositoryException(msg, (Throwable)e);
        }
        return nodeEx;
    }

    public boolean propertyExists(String s) throws RepositoryException {
        return this.itemExists(s);
    }

    public void move(String s, String s1) throws ItemExistsException, PathNotFoundException, VersionException, ConstraintViolationException, LockException, RepositoryException {
        RegistryJCRItemOperationUtil.validateReadOnlyItemOpr(this);
        try {
            String[] temps = s.split("/");
            String[] temps1 = s1.split("/");
            if (!this.userRegistry.resourceExists(s)) {
                throw new PathNotFoundException();
            }
            if (this.userRegistry.resourceExists(s1) && temps[temps.length - 1].equals(temps1[temps1.length - 1])) {
                throw new ItemExistsException();
            }
            this.userRegistry.move(s, s1);
        }
        catch (Exception e) {
            String msg = "failed to resolve the path " + this;
            log.debug((Object)msg);
            throw new PathNotFoundException(msg, (Throwable)e);
        }
    }

    public void removeItem(String s) throws VersionException, LockException, ConstraintViolationException, AccessDeniedException, RepositoryException {
        try {
            if (!this.userRegistry.resourceExists(s)) {
                throw new PathNotFoundException("No such path exists" + s);
            }
            this.userRegistry.delete(s);
        }
        catch (RegistryException e) {
            e.printStackTrace();
        }
    }

    public void save() throws AccessDeniedException, ItemExistsException, ReferentialIntegrityException, ConstraintViolationException, InvalidItemStateException, VersionException, LockException, NoSuchNodeTypeException, RepositoryException {
        RegistryJCRItemOperationUtil.persistPendingChanges(this);
        this.sessionSaved();
    }

    public void refresh(boolean b) throws RepositoryException {
        if (!b) {
            this.removePendingChanges();
        }
    }

    private void removePendingChanges() throws RepositoryException {
        ((RegistryRetentionManager)this.getRetentionManager()).getPendingRetentionPolicies().clear();
        for (String s : ((RegistryRetentionManager)this.getRetentionManager()).getPendingPolicyRemoveList()) {
            this.getRetentionManager().setRetentionPolicy(s, (RetentionPolicy)new RegistryRetentionPolicy());
        }
        ((RegistryRetentionManager)this.getRetentionManager()).getPendingPolicyRemoveList().clear();
    }

    public boolean hasPendingChanges() throws RepositoryException {
        return false;
    }

    public ValueFactory getValueFactory() throws UnsupportedRepositoryOperationException, RepositoryException {
        return new RegistryValueFactory();
    }

    public boolean hasPermission(String s, String s1) throws RepositoryException {
        boolean hasPer = false;
        try {
            hasPer = this.userRegistry.getUserRealm().getAuthorizationManager().isUserAuthorized(this.getUserID(), s, s1);
        }
        catch (UserStoreException e) {
            String msg = "failed to resolve the path of the given node " + this;
            log.debug((Object)msg);
            throw new RepositoryException(msg, (Throwable)e);
        }
        return hasPer;
    }

    public void checkPermission(String s, String s1) throws AccessControlException, RepositoryException {
    }

    public boolean hasCapability(String s, Object o, Object[] objects) throws RepositoryException {
        return false;
    }

    public ContentHandler getImportContentHandler(String s, int i) throws PathNotFoundException, ConstraintViolationException, VersionException, LockException, RepositoryException {
        return null;
    }

    public void importXML(String s, InputStream inputStream, int i) throws IOException, PathNotFoundException, ItemExistsException, ConstraintViolationException, VersionException, InvalidSerializedDataException, LockException, RepositoryException {
    }

    public void exportSystemView(String s, ContentHandler contentHandler, boolean b, boolean b1) throws PathNotFoundException, SAXException, RepositoryException {
    }

    public void exportSystemView(String s, OutputStream outputStream, boolean b, boolean b1) throws IOException, PathNotFoundException, RepositoryException {
    }

    public void exportDocumentView(String s, ContentHandler contentHandler, boolean b, boolean b1) throws PathNotFoundException, SAXException, RepositoryException {
    }

    public void exportDocumentView(String s, OutputStream outputStream, boolean b, boolean b1) throws IOException, PathNotFoundException, RepositoryException {
    }

    public void setNamespacePrefix(String s, String s1) throws NamespaceException, RepositoryException {
        if (RegistryJCRSpecificStandardLoderUtil.getJCRSystemNameSpacePrefxMap().containsKey(s1)) {
            RegistryJCRSpecificStandardLoderUtil.getJCRSystemNameSpaceURIMap().remove(RegistryJCRSpecificStandardLoderUtil.getJCRSystemNameSpacePrefxMap().get(s1));
        } else if (RegistryJCRSpecificStandardLoderUtil.getJCRSystemNameSpaceURIMap().containsKey(s)) {
            RegistryJCRSpecificStandardLoderUtil.getJCRSystemNameSpacePrefxMap().remove(RegistryJCRSpecificStandardLoderUtil.getJCRSystemNameSpaceURIMap().get(s));
        }
        RegistryJCRSpecificStandardLoderUtil.getJCRSystemNameSpacePrefxMap().put(s1, s);
        RegistryJCRSpecificStandardLoderUtil.getJCRSystemNameSpaceURIMap().put(s, s1);
        PrivilegeRegistry privilegeRegistry = ((RegistryAccessControlManager)this.getAccessControlManager()).getPrivilegeRegistry();
        privilegeRegistry.refreshPrivRegistry();
    }

    public String[] getNamespacePrefixes() throws RepositoryException {
        Collection<String> s = RegistryJCRSpecificStandardLoderUtil.getJCRSystemNameSpacePrefxMap().values();
        if (s != null) {
            Object[] objrr = s.toArray();
            String[] starr = new String[objrr.length];
            for (int i = 0; i < objrr.length; ++i) {
                starr[i] = objrr[i].toString();
            }
            return starr;
        }
        return new String[0];
    }

    public String getNamespaceURI(String s) throws NamespaceException, RepositoryException {
        if (RegistryJCRSpecificStandardLoderUtil.getJCRSystemNameSpaceURIMap().get(s) != null) {
            return RegistryJCRSpecificStandardLoderUtil.getJCRSystemNameSpaceURIMap().get(s).toString();
        }
        return null;
    }

    public String getNamespacePrefix(String s) throws NamespaceException, RepositoryException {
        if (RegistryJCRSpecificStandardLoderUtil.getJCRSystemNameSpacePrefxMap().get(s) != null) {
            return RegistryJCRSpecificStandardLoderUtil.getJCRSystemNameSpacePrefxMap().get(s).toString();
        }
        return null;
    }

    public void logout() {
        try {
            TCKTestDataLoader.removeRetentionPolicies(this);
        }
        catch (RepositoryException e) {
            log.error((Object)"Cannot remove tck test data");
        }
    }

    public boolean isLive() {
        return false;
    }

    public void addLockToken(String s) {
    }

    public String[] getLockTokens() {
        return new String[0];
    }

    public void removeLockToken(String s) {
    }

    public AccessControlManager getAccessControlManager() throws UnsupportedRepositoryOperationException, RepositoryException {
        return this.regAccControlMngr;
    }

    public RetentionManager getRetentionManager() throws UnsupportedRepositoryOperationException, RepositoryException {
        return this.regRetentionMngr;
    }
}

