/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.jcr;

import java.io.InputStream;
import java.math.BigDecimal;
import java.util.Calendar;
import javax.jcr.Binary;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.ValueFormatException;
import org.wso2.carbon.registry.jcr.RegistryBinary;
import org.wso2.carbon.registry.jcr.util.RegistryJCRItemOperationUtil;

public class RegistryValue
implements Value {
    private Object value;
    private int type = 0;
    private static final Object hashObject = new Object();

    public RegistryValue(Object key) {
        this.validateNameSpaceURIS(key);
    }

    public RegistryValue(Object key, int i) {
        this.validateNameSpaceURIS(key);
        this.type = i;
    }

    private void validateNameSpaceURIS(Object value) {
        String val = "";
        if (value instanceof String && value.toString().contains("{")) {
            val = RegistryJCRItemOperationUtil.replaceNameSpacePrefixURIS(value.toString());
            this.value = val;
        } else {
            this.value = value;
        }
    }

    public int hashCode() {
        if (this.value != null) {
            return hashObject.hashCode() & this.type & this.value.hashCode();
        }
        return hashObject.hashCode() & this.type;
    }

    public boolean equals(Object obj) {
        boolean eql = false;
        if (obj instanceof Value) {
            try {
                if (this.value instanceof String && ((Value)obj).getString().equals(this.getString())) {
                    eql = true;
                } else if (this.value instanceof Calendar && ((Value)obj).getDate().getTimeInMillis() == this.getDate().getTimeInMillis()) {
                    eql = true;
                } else if (this.value instanceof InputStream && ((Value)obj).getStream().equals(this.getStream())) {
                    eql = true;
                }
            }
            catch (RepositoryException e) {
                e.printStackTrace();
            }
        }
        return eql;
    }

    public Object getKey() {
        return this.value;
    }

    public String getString() throws ValueFormatException, IllegalStateException, RepositoryException {
        return this.value.toString();
    }

    public InputStream getStream() throws RepositoryException {
        if (this.value != null) {
            return (InputStream)this.value;
        }
        return null;
    }

    public Binary getBinary() throws RepositoryException {
        RegistryBinary aBinary = new RegistryBinary(this.value);
        return aBinary;
    }

    public long getLong() throws ValueFormatException, RepositoryException {
        long aLong = 0L;
        if (this.value instanceof Long) {
            aLong = (Long)this.value;
        }
        return aLong;
    }

    public double getDouble() throws ValueFormatException, RepositoryException {
        double aDouble = 0.0;
        if (this.value instanceof Double) {
            aDouble = (Double)this.value;
        }
        return aDouble;
    }

    public BigDecimal getDecimal() throws ValueFormatException, RepositoryException {
        BigDecimal aBigDecimal = new BigDecimal("0");
        if (this.value instanceof BigDecimal) {
            aBigDecimal = new BigDecimal(this.value.toString());
        }
        return aBigDecimal;
    }

    public Calendar getDate() throws ValueFormatException, RepositoryException {
        Calendar aCalendar = null;
        if (this.value != null && this.value instanceof Long) {
            aCalendar = Calendar.getInstance();
            aCalendar.setTimeInMillis((Long)this.value);
        } else if (this.value instanceof Calendar) {
            aCalendar = Calendar.getInstance();
            aCalendar.setTimeInMillis(((Calendar)this.value).getTimeInMillis());
        }
        return aCalendar;
    }

    public boolean getBoolean() throws ValueFormatException, RepositoryException {
        return Boolean.getBoolean(this.value.toString());
    }

    public int getType() {
        int type = 0;
        if (this.type == 0) {
            if (this.value instanceof String) {
                type = 1;
            } else if (this.value instanceof Binary) {
                type = 2;
            } else if (this.value instanceof Long) {
                type = 3;
            } else if (this.value instanceof Double) {
                type = 4;
            } else if (this.value instanceof Calendar) {
                type = 5;
            } else if (this.value instanceof Boolean) {
                type = 6;
            } else if (this.value instanceof Node) {
                type = 9;
            } else if (this.value instanceof BigDecimal) {
                type = 12;
            }
            return type;
        }
        return this.type;
    }

    public Node getNode() {
        return null;
    }
}

