/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.jcr.nodetype;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.nodetype.NodeDefinition;
import javax.jcr.nodetype.NodeTypeDefinition;
import javax.jcr.nodetype.NodeTypeTemplate;
import javax.jcr.nodetype.PropertyDefinition;
import org.wso2.carbon.registry.jcr.util.RegistryJCRItemOperationUtil;
import org.wso2.carbon.registry.jcr.util.RegistryJCRSpecificStandardLoderUtil;

public class RegistryNodeTypeTemplate
implements NodeTypeTemplate {
    NodeTypeDefinition ntd = null;
    private String name = null;
    private String[] declSupTpNames = null;
    private String primItmName = null;
    private boolean isAbstract = false;
    private boolean isMixin = false;
    private boolean isOrderbleChildN = false;
    private boolean isQble = false;
    private List<NodeDefinition> nodeDefList = new ArrayList<NodeDefinition>();
    private List<PropertyDefinition> propDefList = new ArrayList<PropertyDefinition>();

    public RegistryNodeTypeTemplate(NodeTypeDefinition ntd) {
        this.ntd = ntd;
        if (ntd != null) {
            this.setData();
        }
    }

    public RegistryNodeTypeTemplate() {
    }

    private void setData() {
        try {
            this.loadData();
        }
        catch (ConstraintViolationException e) {
            e.printStackTrace();
        }
    }

    private void loadData() throws ConstraintViolationException {
        this.setName(this.ntd.getName());
        this.setAbstract(this.ntd.isAbstract());
        this.setDeclaredSuperTypeNames(this.ntd.getDeclaredSupertypeNames());
        this.setMixin(this.ntd.isMixin());
        this.setOrderableChildNodes(this.ntd.hasOrderableChildNodes());
        this.setPrimaryItemName(this.ntd.getPrimaryItemName());
        this.setQueryable(this.ntd.isQueryable());
    }

    public void setName(String s) throws ConstraintViolationException {
        if (!RegistryJCRSpecificStandardLoderUtil.isValidJCRName(s)) {
            throw new ConstraintViolationException("Invalid JCR node type name");
        }
        if (s != null && s.contains("{")) {
            s = RegistryJCRItemOperationUtil.replaceNameSpacePrefixURIS(s);
        }
        this.name = s;
    }

    public void setDeclaredSuperTypeNames(String[] strings) throws ConstraintViolationException {
        if (strings == null) {
            throw new ConstraintViolationException("Null is not a valid array in jcr");
        }
        for (String s : strings) {
            if (RegistryJCRSpecificStandardLoderUtil.isValidJCRName(s)) continue;
            throw new ConstraintViolationException("Invalid JCR super type type name");
        }
        if (strings != null) {
            this.declSupTpNames = Arrays.copyOf(strings, strings.length);
        }
    }

    public void setAbstract(boolean b) {
        this.isAbstract = b;
    }

    public void setMixin(boolean b) {
        this.isMixin = b;
    }

    public void setOrderableChildNodes(boolean b) {
        this.isOrderbleChildN = b;
    }

    public void setPrimaryItemName(String s) throws ConstraintViolationException {
        if (!RegistryJCRSpecificStandardLoderUtil.isValidJCRName(s)) {
            throw new ConstraintViolationException("Invalid JCR super type type name");
        }
        this.primItmName = s;
    }

    public void setQueryable(boolean b) {
        this.isQble = b;
    }

    public List getPropertyDefinitionTemplates() {
        return this.propDefList;
    }

    public List getNodeDefinitionTemplates() {
        return this.nodeDefList;
    }

    public String getName() {
        return this.name;
    }

    public String[] getDeclaredSupertypeNames() {
        if (this.declSupTpNames != null) {
            return Arrays.copyOf(this.declSupTpNames, this.declSupTpNames.length);
        }
        return new String[0];
    }

    public boolean isAbstract() {
        return this.isAbstract;
    }

    public boolean isMixin() {
        return this.isMixin;
    }

    public boolean hasOrderableChildNodes() {
        return this.isOrderbleChildN;
    }

    public boolean isQueryable() {
        return this.isQble;
    }

    public String getPrimaryItemName() {
        return this.primItmName;
    }

    public PropertyDefinition[] getDeclaredPropertyDefinitions() {
        if (this.ntd != null) {
            return this.ntd.getDeclaredPropertyDefinitions();
        }
        if (this.propDefList.size() != 0) {
            return this.propDefList.toArray(new PropertyDefinition[0]);
        }
        return new PropertyDefinition[0];
    }

    public NodeDefinition[] getDeclaredChildNodeDefinitions() {
        if (this.ntd != null) {
            return this.ntd.getDeclaredChildNodeDefinitions();
        }
        if (this.nodeDefList.size() != 0) {
            return this.nodeDefList.toArray(new NodeDefinition[0]);
        }
        return new NodeDefinition[0];
    }
}

