/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.jcr.nodetype;

import java.util.Arrays;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.NodeTypeManager;
import javax.jcr.nodetype.PropertyDefinitionTemplate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.registry.jcr.util.RegistryJCRItemOperationUtil;
import org.wso2.carbon.registry.jcr.util.RegistryJCRSpecificStandardLoderUtil;

public class RegistryPropertyDefinitionTemplate
implements PropertyDefinitionTemplate {
    private String name = null;
    private boolean isAutoCreated = false;
    private boolean isMandatory = false;
    private boolean isProtected = false;
    private boolean isMultiple = false;
    private boolean isFullTxtSearchable = false;
    private boolean isQueryOrderable = false;
    private int onParVersion = 1;
    private int reqType = 1;
    private String[] valConstraints = null;
    private String[] availableQOpr = null;
    private String declaringNT = null;
    private Value[] deftValues = null;
    private NodeTypeManager nodeTypeManager;
    private static Log log = LogFactory.getLog(RegistryPropertyDefinitionTemplate.class);

    public RegistryPropertyDefinitionTemplate(NodeTypeManager ntm) {
        this.nodeTypeManager = ntm;
    }

    public void setName(String s) throws ConstraintViolationException {
        if (s == null || !RegistryJCRSpecificStandardLoderUtil.isValidJCRName(s)) {
            throw new ConstraintViolationException("Null is not a valid property name in JCR");
        }
        if (s != null && s.contains("{")) {
            s = RegistryJCRItemOperationUtil.replaceNameSpacePrefixURIS(s);
        }
        this.name = s;
    }

    public void setAutoCreated(boolean b) {
        this.isAutoCreated = b;
    }

    public void setMandatory(boolean b) {
        this.isMandatory = b;
    }

    public void setOnParentVersion(int i) {
        this.onParVersion = i;
    }

    public void setProtected(boolean b) {
        this.isProtected = b;
    }

    public void setRequiredType(int i) {
        this.reqType = i;
    }

    public void setValueConstraints(String[] strings) {
        this.valConstraints = strings != null ? Arrays.copyOf(strings, strings.length) : null;
    }

    public void setDefaultValues(Value[] values) {
        this.deftValues = values != null ? Arrays.copyOf(values, values.length) : null;
    }

    public void setMultiple(boolean b) {
        this.isMultiple = b;
    }

    public void setAvailableQueryOperators(String[] strings) {
        this.availableQOpr = strings != null ? Arrays.copyOf(strings, strings.length) : null;
    }

    public void setFullTextSearchable(boolean b) {
        this.isFullTxtSearchable = b;
    }

    public void setQueryOrderable(boolean b) {
        this.isQueryOrderable = b;
    }

    public int getRequiredType() {
        return this.reqType;
    }

    public String[] getValueConstraints() {
        if (this.valConstraints != null) {
            return Arrays.copyOf(this.valConstraints, this.valConstraints.length);
        }
        return null;
    }

    public Value[] getDefaultValues() {
        if (this.deftValues != null) {
            return Arrays.copyOf(this.deftValues, this.deftValues.length);
        }
        return null;
    }

    public boolean isMultiple() {
        return this.isMultiple;
    }

    public String[] getAvailableQueryOperators() {
        if (this.availableQOpr != null) {
            return Arrays.copyOf(this.availableQOpr, this.availableQOpr.length);
        }
        return null;
    }

    public boolean isFullTextSearchable() {
        return this.isFullTxtSearchable;
    }

    public boolean isQueryOrderable() {
        return this.isQueryOrderable;
    }

    public NodeType getDeclaringNodeType() {
        NodeType nodeType = null;
        try {
            nodeType = this.nodeTypeManager.getNodeType(this.declaringNT);
        }
        catch (RepositoryException e) {
            log.error((Object)("Error occurred while getting declared node type : " + this.declaringNT));
        }
        return nodeType;
    }

    public String getName() {
        return this.name;
    }

    public boolean isAutoCreated() {
        return this.isAutoCreated;
    }

    public boolean isMandatory() {
        return this.isMandatory;
    }

    public int getOnParentVersion() {
        return this.onParVersion;
    }

    public boolean isProtected() {
        return this.isProtected;
    }

    public void setDeclaringNodeTypeName(String nt) {
        this.declaringNT = nt;
    }
}

