/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.jcr.retention;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jcr.AccessDeniedException;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.lock.LockException;
import javax.jcr.retention.Hold;
import javax.jcr.retention.RetentionManager;
import javax.jcr.retention.RetentionPolicy;
import javax.jcr.version.VersionException;
import org.wso2.carbon.registry.core.CollectionImpl;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.jcr.RegistrySession;
import org.wso2.carbon.registry.jcr.retention.RegistryHold;
import org.wso2.carbon.registry.jcr.util.RegistryJCRSpecificStandardLoderUtil;
import org.wso2.carbon.registry.jcr.util.retention.EffectiveRetentionUtil;
import org.wso2.carbon.registry.jcr.util.test.data.TCKTestDataLoader;

public class RegistryRetentionManager
implements RetentionManager {
    private Map<String, Set<Hold>> pendingHoldMap = new HashMap<String, Set<Hold>>();
    private Map<String, RetentionPolicy> pendingRetentionPolicies = new HashMap<String, RetentionPolicy>();
    private List<String> pendingPolicyRemoveList = new ArrayList<String>();
    private RegistrySession session;

    public List<String> getPendingPolicyRemoveList() {
        return this.pendingPolicyRemoveList;
    }

    public RegistryRetentionManager(RegistrySession session) {
        this.session = session;
        this.loadTCKTestdata();
    }

    private void loadTCKTestdata() {
        try {
            TCKTestDataLoader.loadRetentionPolicies(this.session);
        }
        catch (RepositoryException repositoryException) {
            // empty catch block
        }
    }

    public Map<String, Set<Hold>> getPendingRetentionHolds() {
        return this.pendingHoldMap;
    }

    public Map<String, RetentionPolicy> getPendingRetentionPolicies() {
        return this.pendingRetentionPolicies;
    }

    public Hold[] getHolds(String s) throws PathNotFoundException, AccessDeniedException, RepositoryException {
        if (RegistryJCRSpecificStandardLoderUtil.isSessionReadOnly(this.session.getUserID())) {
            throw new AccessDeniedException("Read-only session doesn't have sufficient privileges to retrieve retention holds");
        }
        if (!this.isPathValid(s)) {
            throw new RepositoryException("Cannot apply invalid path for retention holds " + s);
        }
        if (!this.isPathExists(s)) {
            throw new PathNotFoundException("No such Path exists for getting hold: " + s);
        }
        return EffectiveRetentionUtil.getHoldsFromRegistry(this.session, s);
    }

    public Hold addHold(String s, String s1, boolean b) throws PathNotFoundException, AccessDeniedException, LockException, VersionException, RepositoryException {
        if (!this.isPathValid(s)) {
            throw new RepositoryException("Cannot apply invalid path for retention holds " + s);
        }
        if (!this.isValidJCRName(s1)) {
            throw new RepositoryException("Cannot apply invalid name for retention holds " + s);
        }
        return this.addHoldsToPending(s, s1, b);
    }

    private Hold addHoldsToPending(String s, String s1, boolean b) {
        RegistryHold aHold = new RegistryHold(s1, b);
        if (this.pendingHoldMap.get(s) == null) {
            HashSet<RegistryHold> tempHd = new HashSet<RegistryHold>();
            tempHd.add(aHold);
            this.pendingHoldMap.put(s, tempHd);
        } else {
            this.pendingHoldMap.get(s).add(aHold);
        }
        return aHold;
    }

    public void removeHold(String s, Hold hold) throws PathNotFoundException, AccessDeniedException, LockException, VersionException, RepositoryException {
        if (this.pendingHoldMap.containsKey(s)) {
            this.pendingHoldMap.get(s).remove(hold);
        }
        EffectiveRetentionUtil.removeHoldFromRegistry(this.session, s, hold);
    }

    public RetentionPolicy getRetentionPolicy(String s) throws PathNotFoundException, AccessDeniedException, RepositoryException {
        if (RegistryJCRSpecificStandardLoderUtil.isSessionReadOnly(this.session.getUserID())) {
            throw new AccessDeniedException("Read-only session doesn't have sufficient privileges to retrieve retention policy.");
        }
        if (!this.isPathValid(s)) {
            throw new RepositoryException("Cannot apply invalid path for retention policies " + s);
        }
        if (!this.isPathExists(s)) {
            throw new PathNotFoundException("No such Path exists for apply retention: " + s);
        }
        RetentionPolicy persistedPolicy = EffectiveRetentionUtil.getRetentionPolicyFromRegistry(this.session, s);
        if (persistedPolicy != null) {
            return persistedPolicy;
        }
        return this.pendingRetentionPolicies.get(s);
    }

    private boolean isPathExists(String s) throws RepositoryException {
        try {
            return this.session.getUserRegistry().resourceExists(s) && this.session.getUserRegistry().get(s) instanceof CollectionImpl;
        }
        catch (RegistryException e) {
            throw new RepositoryException("Registry level exception occurred when applying retention to " + s);
        }
    }

    public void setRetentionPolicy(String s, RetentionPolicy retentionPolicy) throws PathNotFoundException, AccessDeniedException, LockException, VersionException, RepositoryException {
        if (this.session.getWorkspace().getLockManager().holdsLock(s)) {
            throw new LockException("Cannot set retention policy on a locked node");
        }
        if (RegistryJCRSpecificStandardLoderUtil.isSessionReadOnly(this.session.getUserID())) {
            throw new AccessDeniedException("Read-only session doesn't have sufficient privileges to retrieve retention policy.");
        }
        if (!this.isPathValid(s)) {
            throw new RepositoryException("Cannot apply invalid path for retention policies " + s);
        }
        if (!this.isValidJCRName(retentionPolicy.getName())) {
            throw new RepositoryException("Cannot apply invalid name for retention policies " + s);
        }
        if (!this.isPathExists(s)) {
            throw new PathNotFoundException("No such Path exists for apply retention: " + s);
        }
        this.pendingRetentionPolicies.put(s, retentionPolicy);
    }

    public void removeRetentionPolicy(String s) throws PathNotFoundException, AccessDeniedException, LockException, VersionException, RepositoryException {
        if (this.session.getWorkspace().getLockManager().holdsLock(s)) {
            throw new LockException("Cannot set retention policy on a locked node");
        }
        if (!this.isPathValid(s)) {
            throw new RepositoryException("Cannot apply invalid path for retention policies " + s);
        }
        if (!this.isPathExists(s)) {
            throw new PathNotFoundException("No such Path exists for apply retention: " + s);
        }
        try {
            if (this.getRetentionPolicy(s) == null && this.getRetentionPolicy(this.session.getUserRegistry().get(s).getParentPath()) != null) {
                throw new RepositoryException("Cannot remove retention from other nodes" + s);
            }
        }
        catch (RegistryException e) {
            throw new RepositoryException("Cannot remove retention from other nodes" + s);
        }
        if (this.pendingRetentionPolicies.get(s) != null) {
            this.pendingRetentionPolicies.remove(s);
        } else if (this.getRetentionPolicy(s) != null) {
            EffectiveRetentionUtil.removeRetentionPolicyFromRegistry(this.session, s);
            this.pendingPolicyRemoveList.add(s);
        }
    }

    private boolean isPathValid(String path) {
        return path != null && path.contains("/") && !path.contains("*") && !path.contains("[") && !path.contains("]");
    }

    private boolean isValidJCRName(String name) {
        return name != null && !name.contains("/") && !name.contains("*");
    }
}

