/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.jcr.security;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.jcr.AccessDeniedException;
import javax.jcr.Item;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.security.AccessControlEntry;
import javax.jcr.security.AccessControlException;
import javax.jcr.security.AccessControlManager;
import javax.jcr.security.AccessControlPolicy;
import javax.jcr.security.AccessControlPolicyIterator;
import javax.jcr.security.Privilege;
import org.wso2.carbon.registry.jcr.RegistrySession;
import org.wso2.carbon.registry.jcr.security.RegistryAccessControlList;
import org.wso2.carbon.registry.jcr.security.RegistryAccessControlPolicyIterator;
import org.wso2.carbon.registry.jcr.security.RegistryNamedAccessControlPolicy;
import org.wso2.carbon.registry.jcr.util.RegistryJCRSpecificStandardLoderUtil;
import org.wso2.carbon.registry.jcr.util.security.PrivilegeRegistry;

public class RegistryAccessControlManager
implements AccessControlManager {
    private PrivilegeRegistry privilegeRegistry;
    private RegistrySession registrySession;
    private Map<String, Set<AccessControlPolicy>> accessCtrlPolicies = new HashMap<String, Set<AccessControlPolicy>>();

    public RegistryAccessControlManager(RegistrySession registrySession) {
        this.privilegeRegistry = new PrivilegeRegistry();
        this.registrySession = registrySession;
    }

    public PrivilegeRegistry getPrivilegeRegistry() {
        return this.privilegeRegistry;
    }

    public Privilege[] getSupportedPrivileges(String s) throws RepositoryException {
        return this.privilegeRegistry.getRegisteredPrivileges();
    }

    public Privilege privilegeFromName(String s) throws RepositoryException {
        return this.privilegeRegistry.getPrivilegeFromName(s);
    }

    public boolean hasPrivileges(String s, Privilege[] privileges) throws RepositoryException {
        boolean hasPrivileges = true;
        Item item = this.registrySession.getItem(s);
        if (item instanceof Property) {
            throw new PathNotFoundException("No privilages can be added for Properties");
        }
        HashSet<Privilege> temp = new HashSet<Privilege>();
        temp.addAll(Arrays.asList(this.getPrivileges(s)));
        for (Privilege pv : privileges) {
            if (temp.contains(pv)) continue;
            hasPrivileges = false;
        }
        return hasPrivileges;
    }

    public Privilege[] getPrivileges(String s) throws RepositoryException {
        Item item = this.registrySession.getItem(s);
        if (item instanceof Property) {
            throw new PathNotFoundException("No privilages can be added for Properties");
        }
        HashSet<Privilege> privileges = new HashSet<Privilege>();
        if (this.accessCtrlPolicies.get(s) instanceof RegistryAccessControlList) {
            AccessControlEntry[] accessNtries;
            for (AccessControlEntry ac : accessNtries = ((RegistryAccessControlList)((Object)this.accessCtrlPolicies.get(s))).getAccessControlEntries()) {
                if (ac == null) continue;
                privileges.addAll(Arrays.asList(ac.getPrivileges()));
            }
        }
        if (RegistryJCRSpecificStandardLoderUtil.isSessionReadOnly(this.registrySession.getUserID()) && !privileges.contains(this.privilegeRegistry.getPrivilegeFromName("{http://www.jcp.org/jcr/1.0}read"))) {
            privileges.add(this.privilegeRegistry.getPrivilegeFromName("{http://www.jcp.org/jcr/1.0}read"));
        }
        if (privileges.size() != 0) {
            return privileges.toArray(new Privilege[privileges.size()]);
        }
        return new Privilege[0];
    }

    public AccessControlPolicy[] getPolicies(String s) throws RepositoryException {
        if (RegistryJCRSpecificStandardLoderUtil.isSessionReadOnly(this.registrySession.getUserID())) {
            throw new AccessDeniedException("Read only session may not read AC content");
        }
        if (this.accessCtrlPolicies.get(s) != null) {
            return this.accessCtrlPolicies.get(s).toArray(new AccessControlPolicy[this.accessCtrlPolicies.get(s).size()]);
        }
        return new AccessControlPolicy[0];
    }

    public AccessControlPolicy[] getEffectivePolicies(String s) throws RepositoryException {
        if (RegistryJCRSpecificStandardLoderUtil.isSessionReadOnly(this.registrySession.getUserID())) {
            throw new AccessDeniedException("Read only session may not read AC content");
        }
        Item item = this.registrySession.getItem(s);
        if (item instanceof Property) {
            throw new PathNotFoundException("Cannot apply policies to a property path");
        }
        return this.getPolicies(s);
    }

    public AccessControlPolicyIterator getApplicablePolicies(String s) throws RepositoryException {
        if (RegistryJCRSpecificStandardLoderUtil.isSessionReadOnly(this.registrySession.getUserID())) {
            throw new AccessDeniedException("Read only session may not read AC content");
        }
        if (this.accessCtrlPolicies.size() != 0) {
            return new RegistryAccessControlPolicyIterator(this.accessCtrlPolicies.get(s));
        }
        return new RegistryAccessControlPolicyIterator(new HashSet());
    }

    public void setPolicy(String s, AccessControlPolicy accessControlPolicy) throws RepositoryException {
        boolean invalidPolicy = true;
        if (RegistryJCRSpecificStandardLoderUtil.isSessionReadOnly(this.registrySession.getUserID())) {
            if (accessControlPolicy instanceof RegistryAccessControlList) {
                invalidPolicy = false;
            } else if (accessControlPolicy instanceof RegistryNamedAccessControlPolicy) {
                invalidPolicy = false;
            }
            if (invalidPolicy) {
                throw new AccessControlException("Invalid policy may not be set by a READ-only session");
            }
        }
        if (this.accessCtrlPolicies.get(s) == null) {
            HashSet<AccessControlPolicy> policies = new HashSet<AccessControlPolicy>();
            policies.add(accessControlPolicy);
            this.accessCtrlPolicies.put(s, policies);
        } else {
            this.accessCtrlPolicies.get(s).add(accessControlPolicy);
        }
    }

    public void removePolicy(String s, AccessControlPolicy accessControlPolicy) throws RepositoryException {
        Set<AccessControlPolicy> temp = this.accessCtrlPolicies.get(s);
        temp.remove(accessControlPolicy);
        this.accessCtrlPolicies.remove(s);
        this.accessCtrlPolicies.put(s, temp);
    }
}

