/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.jcr.util;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Map;
import java.util.Set;
import javax.jcr.AccessDeniedException;
import javax.jcr.InvalidItemStateException;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.retention.Hold;
import javax.jcr.retention.RetentionPolicy;
import org.wso2.carbon.registry.core.CollectionImpl;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.ResourceImpl;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.jcr.RegistryProperty;
import org.wso2.carbon.registry.jcr.RegistrySession;
import org.wso2.carbon.registry.jcr.RegistryValue;
import org.wso2.carbon.registry.jcr.retention.RegistryRetentionManager;
import org.wso2.carbon.registry.jcr.util.RegistryJCRSpecificStandardLoderUtil;
import org.wso2.carbon.registry.jcr.util.retention.EffectiveRetentionUtil;

public class RegistryJCRItemOperationUtil {
    public static String replaceNameSpacePrefixURIS(String path) {
        for (String uri : RegistryJCRSpecificStandardLoderUtil.getJCRSystemNameSpaceURIList()) {
            path = path.replace("{" + uri + "}", RegistryJCRSpecificStandardLoderUtil.getJCRSystemNameSpacePrefxMap().get(uri) + ":");
        }
        return path;
    }

    public static String getAncestorPathAtGivenDepth(RegistrySession registrySession, String path, int depth) throws ItemNotFoundException {
        String[] tmp = path.split("/");
        if (depth > tmp.length - 4 || depth < 0) {
            throw new ItemNotFoundException("No such Ancestor exists. 0 < depth < n violated");
        }
        if (depth == 0) {
            return registrySession.getWorkspaceRootPath();
        }
        int index = RegistryJCRItemOperationUtil.nthOccurrence(path, '/', depth);
        return path.substring(0, index);
    }

    private static int nthOccurrence(String str, char c, int n) {
        str = str + "/";
        int pos = str.indexOf(c, 0);
        while (n-- > 0 && pos != -1) {
            pos = str.indexOf(c, pos + 1);
        }
        return pos;
    }

    public static void validateReadOnlyItemOpr(RegistrySession registrySession) throws AccessDeniedException {
        if (RegistryJCRSpecificStandardLoderUtil.isSessionReadOnly(registrySession.getUserID())) {
            throw new AccessDeniedException("A read only session must not be allowed to modify a property value");
        }
    }

    public static void validateSessionSaved(RegistrySession registrySession) throws InvalidItemStateException {
        if (!registrySession.isSessionSaved()) {
            throw new InvalidItemStateException("Tried to access unsaved operations : Invalid item state");
        }
    }

    public static void validateSystemConfigPath(String path) throws RepositoryException {
        if (path == null) {
            throw new RepositoryException("Null is an invalid path expression");
        }
        if (path.contains("greg_jcr_config")) {
            throw new RepositoryException("greg_jcr_config cannot be included in a path,it is a system specific config node");
        }
    }

    public static boolean isSystemConfigNode(String path) throws RepositoryException {
        if (path == null) {
            throw new RepositoryException("Null is an invalid path expression");
        }
        return path.contains("greg_jcr_config");
    }

    public static String getNodePathFromVersionName(String s) {
        if (!s.contains("/")) {
            return s;
        }
        return s.substring(0, s.lastIndexOf("/")) + "/" + s.split("/")[s.split("/").length - 1].split(";")[0];
    }

    public static RegistryProperty getRegistryProperty(String s, String property, ResourceImpl res, String propQName, RegistrySession session) throws RepositoryException {
        Object prop = null;
        RegistryProperty regProp = null;
        if (s != null) {
            if (s.equals("boolean")) {
                regProp = new RegistryProperty(res.getPath(), session, propQName, Boolean.valueOf(property));
            } else if (s.equals("long")) {
                regProp = new RegistryProperty(res.getPath(), session, propQName, Long.valueOf(property));
            } else if (s.equals("double")) {
                regProp = new RegistryProperty(res.getPath(), session, propQName, Double.valueOf(property).longValue());
            } else if (s.equals("big_decimal")) {
                regProp = new RegistryProperty(res.getPath(), session, propQName, new BigDecimal(property));
            } else if (s.equals("value_type")) {
                regProp = new RegistryProperty(res.getPath(), session, propQName, new RegistryValue(property));
            } else if (s.equals("calendar")) {
                Calendar cal = Calendar.getInstance();
                cal.setTimeInMillis(Long.valueOf(property));
                regProp = new RegistryProperty(res.getPath(), session, propQName, new RegistryValue(cal));
            }
        }
        return regProp;
    }

    public static boolean isValidJCRName(String s) {
        return s != null && !s.contains("*");
    }

    public static void persistPendingChanges(RegistrySession registrySession) throws RepositoryException {
        RegistryJCRItemOperationUtil.persistRententionPolicies(registrySession);
        RegistryJCRItemOperationUtil.persistRetentionHolds(registrySession);
    }

    private static void persistRetentionHolds(RegistrySession registrySession) throws RepositoryException {
        Map<String, Set<Hold>> pending = ((RegistryRetentionManager)registrySession.getRetentionManager()).getPendingRetentionHolds();
        for (String s : pending.keySet()) {
            Set<Hold> holds = pending.get(s);
            for (Hold h : holds) {
                EffectiveRetentionUtil.addHoldsToRegistry(registrySession, s, h.getName(), h.isDeep());
            }
        }
        ((RegistryRetentionManager)registrySession.getRetentionManager()).getPendingRetentionHolds().clear();
    }

    private static void persistRententionPolicies(RegistrySession registrySession) throws RepositoryException {
        Map<String, RetentionPolicy> pending = ((RegistryRetentionManager)registrySession.getRetentionManager()).getPendingRetentionPolicies();
        for (String s : pending.keySet()) {
            EffectiveRetentionUtil.setRetentionPolicyToRegistry(registrySession, s, pending.get(s));
        }
        ((RegistryRetentionManager)registrySession.getRetentionManager()).getPendingRetentionPolicies().clear();
        for (String s : ((RegistryRetentionManager)registrySession.getRetentionManager()).getPendingPolicyRemoveList()) {
            EffectiveRetentionUtil.removeRetentionPolicyFromRegistry(registrySession, s);
        }
        ((RegistryRetentionManager)registrySession.getRetentionManager()).getPendingPolicyRemoveList().clear();
    }

    public static Property persistStringPropertyValues(RegistrySession registrySession, String nodePath, String s, String[] strings) throws RepositoryException {
        CollectionImpl resource;
        boolean allNullInSide = true;
        ArrayList<String> properties = new ArrayList<String>();
        try {
            resource = (CollectionImpl)registrySession.getUserRegistry().get(nodePath);
            if (strings != null) {
                for (String val : strings) {
                    if (val == null) continue;
                    properties.add(val);
                    allNullInSide = false;
                }
                if (allNullInSide) {
                    resource.setProperty(s, "");
                    registrySession.getUserRegistry().put(nodePath, (Resource)resource);
                    RegistryProperty property = new RegistryProperty(resource.getPath(), registrySession, s, new String[0]);
                    return property;
                }
                resource.setProperty(s, properties);
                registrySession.getUserRegistry().put(nodePath, (Resource)resource);
            } else {
                resource.removeProperty(s);
                registrySession.getUserRegistry().put(nodePath, (Resource)resource);
            }
        }
        catch (RegistryException e) {
            String msg = "failed to resolve the path of the given node or violation of repository syntax ";
            throw new RepositoryException(msg, (Throwable)e);
        }
        RegistryProperty property = new RegistryProperty(resource.getPath(), registrySession, s, properties.toArray(new String[0]));
        return property;
    }

    public static void checkRetentionPolicyWithParent(RegistrySession session, String path) throws RepositoryException {
        try {
            if (EffectiveRetentionUtil.checkEffectiveRetentionPolicyFullLocked(session, session.getUserRegistry().get(path).getParentPath())) {
                throw new RepositoryException("Cannot remove a node under retention policy" + path);
            }
            if (EffectiveRetentionUtil.checkEffectiveRetentionPolicyFullLocked(session, path)) {
                throw new RepositoryException("Cannot remove a node under retention policy" + path);
            }
        }
        catch (RegistryException e) {
            throw new RepositoryException("Cannot remove a node under retention policy" + path);
        }
    }

    public static void checkRetentionPolicy(RegistrySession session, String path) throws RepositoryException {
        try {
            if (EffectiveRetentionUtil.checkEffectiveRetentionPolicyFullLocked(session, path)) {
                throw new RepositoryException("Cannot remove a node under retention policy" + path);
            }
        }
        catch (RegistryException e) {
            throw new RepositoryException("Cannot remove a node under retention policy" + path);
        }
    }

    public static void checkRetentionHoldWithParent(RegistrySession session, String path) throws RepositoryException {
        try {
            if (EffectiveRetentionUtil.checkEffectiveRetentionHoldFullLocked(session, session.getUserRegistry().get(path).getParentPath())) {
                throw new RepositoryException("Cannot remove a node under retention hold" + path);
            }
            if (EffectiveRetentionUtil.checkEffectiveRetentionHoldFullLocked(session, path)) {
                throw new RepositoryException("Cannot remove a node under retention hold" + path);
            }
        }
        catch (RegistryException e) {
            throw new RepositoryException("Cannot remove a node under retention hold" + path);
        }
    }

    public static void checkRetentionHold(RegistrySession session, String path) throws RepositoryException {
        try {
            if (EffectiveRetentionUtil.checkEffectiveRetentionHoldFullLocked(session, path)) {
                throw new RepositoryException("Cannot remove a node under retention hold" + path);
            }
        }
        catch (RegistryException e) {
            throw new RepositoryException("Cannot remove a node under retention hold" + path);
        }
    }

    public static boolean isWorkspaceExists(RegistrySession registrySession, String s) {
        Set sessions = registrySession.getRepository().getWorkspaces();
        boolean matchFound = false;
        for (Object ss : sessions) {
            RegistrySession session = (RegistrySession)ss;
            if (session.getWorkspaceName() == null || !session.getWorkspaceName().equals(s)) continue;
            matchFound = true;
        }
        return matchFound;
    }
}

